/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.BaseComponent;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServiceDescriptor;
import com.intellij.openapi.components.ex.ComponentManagerEx;
import com.intellij.openapi.components.impl.CachingComponentAdapter;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.pico.AssignableToComponentAdapter;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.PicoVisitor;
import org.picocontainer.defaults.ConstructorInjectionComponentAdapter;

public class ServiceManagerImpl
implements BaseComponent {
    private static final ExtensionPointName<ServiceDescriptor> APP_SERVICES = new ExtensionPointName("com.intellij.applicationService");
    private static final ExtensionPointName<ServiceDescriptor> PROJECT_SERVICES = new ExtensionPointName("com.intellij.projectService");
    private ExtensionPointName<ServiceDescriptor> myExtensionPointName;
    private ExtensionPointListener<ServiceDescriptor> myExtensionPointListener;

    public ServiceManagerImpl() {
        this.installEP(APP_SERVICES, (ComponentManager)ApplicationManager.getApplication());
    }

    public ServiceManagerImpl(Project project) {
        this.installEP(PROJECT_SERVICES, (ComponentManager)project);
    }

    protected ServiceManagerImpl(boolean ignoreInit) {
    }

    protected void installEP(ExtensionPointName<ServiceDescriptor> pointName, final ComponentManager componentManager) {
        this.myExtensionPointName = pointName;
        ExtensionPoint extensionPoint = Extensions.getArea(null).getExtensionPoint(pointName);
        assert (extensionPoint != null);
        final MutablePicoContainer picoContainer = (MutablePicoContainer)componentManager.getPicoContainer();
        this.myExtensionPointListener = new ExtensionPointListener<ServiceDescriptor>(){

            public void extensionAdded(ServiceDescriptor descriptor, PluginDescriptor pluginDescriptor) {
                picoContainer.registerComponent((ComponentAdapter)new MyComponentAdapter(descriptor, pluginDescriptor, (ComponentManagerEx)componentManager));
            }

            public void extensionRemoved(ServiceDescriptor extension, PluginDescriptor pluginDescriptor) {
                picoContainer.unregisterComponent((Object)extension.serviceInterface);
            }
        };
        extensionPoint.addExtensionPointListener(this.myExtensionPointListener);
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        String string = this.getClass().getName();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/components/impl/ServiceManagerImpl.getComponentName must not return null");
        }
        return string;
    }

    public void initComponent() {
    }

    public void disposeComponent() {
        ExtensionPoint extensionPoint = Extensions.getArea(null).getExtensionPoint(this.myExtensionPointName);
        assert (extensionPoint != null);
        extensionPoint.removeExtensionPointListener(this.myExtensionPointListener);
    }

    private static class MyComponentAdapter
    implements AssignableToComponentAdapter {
        private ComponentAdapter myDelegate;
        private final ServiceDescriptor myDescriptor;
        private final PluginDescriptor myPluginDescriptor;
        private final ComponentManagerEx myComponentManager;
        private volatile Object myInitializedComponentInstance = null;

        public MyComponentAdapter(ServiceDescriptor descriptor, PluginDescriptor pluginDescriptor, ComponentManagerEx componentManager) {
            this.myDescriptor = descriptor;
            this.myPluginDescriptor = pluginDescriptor;
            this.myComponentManager = componentManager;
            this.myDelegate = null;
        }

        public Object getComponentKey() {
            return this.myDescriptor.serviceInterface;
        }

        public Class getComponentImplementation() {
            return this.loadClass(this.myDescriptor.serviceInterface);
        }

        private Class loadClass(String className) {
            try {
                ClassLoader classLoader = this.myPluginDescriptor != null ? this.myPluginDescriptor.getPluginClassLoader() : this.getClass().getClassLoader();
                return Class.forName(className, true, classLoader);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }

        public Object getComponentInstance(final PicoContainer container) throws PicoInitializationException, PicoIntrospectionException {
            Object instance = this.myInitializedComponentInstance;
            if (instance != null) {
                return instance;
            }
            return ApplicationManager.getApplication().runReadAction((Computable)new Computable<Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object compute() {
                    MyComponentAdapter myComponentAdapter = MyComponentAdapter.this;
                    synchronized (myComponentAdapter) {
                        Object instance = MyComponentAdapter.this.myInitializedComponentInstance;
                        if (instance != null) {
                            return instance;
                        }
                        instance = MyComponentAdapter.this.initializeInstance(container);
                        MyComponentAdapter.this.myInitializedComponentInstance = instance;
                        return instance;
                    }
                }
            });
        }

        protected Object initializeInstance(PicoContainer container) {
            Object serviceInstance = this.getDelegate().getComponentInstance(container);
            if (serviceInstance instanceof Disposable) {
                Disposer.register((Disposable)this.myComponentManager, (Disposable)((Disposable)serviceInstance));
            }
            this.myComponentManager.getComponentStore().initComponent(serviceInstance, true);
            return serviceInstance;
        }

        private synchronized ComponentAdapter getDelegate() {
            if (this.myDelegate == null) {
                this.myDelegate = new CachingComponentAdapter((ComponentAdapter)new ConstructorInjectionComponentAdapter(this.getComponentKey(), this.loadClass(this.myDescriptor.serviceImplementation), null, true));
            }
            return this.myDelegate;
        }

        public void verify(PicoContainer container) throws PicoIntrospectionException {
            this.getDelegate().verify(container);
        }

        public void accept(PicoVisitor visitor) {
            visitor.visitComponentAdapter((ComponentAdapter)this);
        }

        public boolean isAssignableTo(Class aClass) {
            return aClass.getName().equals(this.getComponentKey());
        }

        public String getAssignableToClassName() {
            return this.myDescriptor.serviceInterface;
        }
    }
}

