/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.AbnormalCommandTerminationException;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.CommandProcessorEx;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.impl.CommandLog;
import com.intellij.openapi.command.impl.FocusBasedCurrentEditorProvider;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Ref;
import com.intellij.util.containers.ContainerUtil;
import java.util.Stack;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.Nullable;

public class CommandProcessorImpl
extends CommandProcessorEx {
    private CommandDescriptor myCurrentCommand = null;
    private final Stack<CommandDescriptor> myInterruptedCommands = new Stack();
    private final CopyOnWriteArrayList<CommandListener> myListeners = ContainerUtil.createEmptyCOWList();
    private int myUndoTransparentCount = 0;

    public void executeCommand(Runnable runnable, String name, Object groupId) {
        this.executeCommand(null, runnable, name, groupId);
    }

    public void executeCommand(Project project, Runnable runnable, String name, Object groupId) {
        this.executeCommand(project, runnable, name, groupId, UndoConfirmationPolicy.DEFAULT);
    }

    public void executeCommand(Project project, Runnable command, String name, Object groupId, UndoConfirmationPolicy undoConfirmationPolicy) {
        this.executeCommand(project, command, name, groupId, undoConfirmationPolicy, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeCommand(Project project, Runnable command, String name, Object groupId, UndoConfirmationPolicy undoConfirmationPolicy, Document document) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (project != null && project.isDisposed()) {
            return;
        }
        if (CommandLog.LOG.isDebugEnabled()) {
            CommandLog.LOG.debug("executeCommand: " + command + ", name = " + name + ", groupId = " + groupId);
        }
        if (this.myCurrentCommand != null) {
            command.run();
            return;
        }
        Throwable throwable = null;
        try {
            this.myCurrentCommand = new CommandDescriptor(command, project, name, groupId, undoConfirmationPolicy, document);
            this.fireCommandStarted();
            command.run();
        }
        catch (Throwable th) {
            throwable = th;
        }
        finally {
            this.finishCommand(project, this.myCurrentCommand, throwable);
        }
    }

    @Override
    @Nullable
    public Object startCommand(Project project, @Nls String name, Object groupId, UndoConfirmationPolicy undoConfirmationPolicy) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (project != null && project.isDisposed()) {
            return null;
        }
        if (CommandLog.LOG.isDebugEnabled()) {
            CommandLog.LOG.debug("startCommand: name = " + name + ", groupId = " + groupId);
        }
        if (this.myCurrentCommand != null) {
            return null;
        }
        Document document = groupId instanceof Ref && ((Ref)groupId).get() instanceof Document ? (Document)((Ref)groupId).get() : null;
        this.myCurrentCommand = new CommandDescriptor(EmptyRunnable.INSTANCE, project, name, groupId, undoConfirmationPolicy, document);
        this.fireCommandStarted();
        return this.myCurrentCommand;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishCommand(Project project, Object command, Throwable throwable) {
        boolean failed;
        ApplicationManager.getApplication().assertIsDispatchThread();
        CommandLog.LOG.assertTrue(this.myCurrentCommand != null, (Object)"no current command in progress");
        if (this.myCurrentCommand != command) {
            return;
        }
        try {
            if (throwable instanceof AbnormalCommandTerminationException) {
                AbnormalCommandTerminationException rollback = (AbnormalCommandTerminationException)throwable;
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    throw new RuntimeException((Throwable)rollback);
                }
                failed = true;
            } else if (throwable != null) {
                failed = true;
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                CommandLog.LOG.error(throwable);
            } else {
                failed = false;
            }
        }
        finally {
            this.fireCommandFinished();
        }
        if (failed) {
            if (project != null) {
                FileEditor editor = new FocusBasedCurrentEditorProvider().getCurrentEditor();
                UndoManager undoManager = UndoManager.getInstance((Project)project);
                if (undoManager.isUndoAvailable(editor)) {
                    undoManager.undo(editor);
                }
            }
            Messages.showErrorDialog((Project)project, (String)"Cannot perform operation. Too complex, sorry.", (String)"Failed to perform operation");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireCommandFinished() {
        CommandEvent event = new CommandEvent((CommandProcessor)this, this.myCurrentCommand.myCommand, this.myCurrentCommand.myName, this.myCurrentCommand.myGroupId, this.myCurrentCommand.myProject, this.myCurrentCommand.myUndoConfirmationPolicy, this.myCurrentCommand.myDocument);
        try {
            for (CommandListener listener : this.myListeners) {
                try {
                    listener.beforeCommandFinished(event);
                }
                catch (Throwable e) {
                    CommandLog.LOG.error(e);
                }
            }
        }
        finally {
            this.myCurrentCommand = null;
            for (CommandListener listener : this.myListeners) {
                try {
                    listener.commandFinished(event);
                }
                catch (Throwable e) {
                    CommandLog.LOG.error(e);
                }
            }
        }
    }

    @Override
    public void enterModal() {
        this.myInterruptedCommands.push(this.myCurrentCommand);
        if (this.myCurrentCommand != null) {
            this.fireCommandFinished();
        }
    }

    @Override
    public void leaveModal() {
        CommandLog.LOG.assertTrue(this.myCurrentCommand == null);
        this.myCurrentCommand = this.myInterruptedCommands.pop();
        if (this.myCurrentCommand != null) {
            this.fireCommandStarted();
        }
    }

    public void setCurrentCommandName(String name) {
        CommandLog.LOG.assertTrue(this.myCurrentCommand != null);
        this.myCurrentCommand.myName = name;
    }

    public void setCurrentCommandGroupId(Object groupId) {
        CommandLog.LOG.assertTrue(this.myCurrentCommand != null);
        this.myCurrentCommand.myGroupId = groupId;
    }

    @Nullable
    public Runnable getCurrentCommand() {
        return this.myCurrentCommand != null ? this.myCurrentCommand.myCommand : null;
    }

    @Nullable
    public String getCurrentCommandName() {
        if (this.myCurrentCommand != null) {
            return this.myCurrentCommand.myName;
        }
        if (!this.myInterruptedCommands.isEmpty()) {
            CommandDescriptor command = this.myInterruptedCommands.peek();
            return command != null ? command.myName : null;
        }
        return null;
    }

    @Nullable
    public Object getCurrentCommandGroupId() {
        if (this.myCurrentCommand != null) {
            return this.myCurrentCommand.myGroupId;
        }
        if (!this.myInterruptedCommands.isEmpty()) {
            CommandDescriptor command = this.myInterruptedCommands.peek();
            return command != null ? command.myGroupId : null;
        }
        return null;
    }

    @Nullable
    public Project getCurrentCommandProject() {
        return this.myCurrentCommand != null ? this.myCurrentCommand.myProject : null;
    }

    public void addCommandListener(CommandListener listener) {
        this.myListeners.add(listener);
    }

    public void addCommandListener(final CommandListener listener, Disposable parentDisposable) {
        this.addCommandListener(listener);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                CommandProcessorImpl.this.removeCommandListener(listener);
            }
        });
    }

    public void removeCommandListener(CommandListener listener) {
        this.myListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runUndoTransparentAction(Runnable action) {
        if (this.myUndoTransparentCount == 0) {
            this.fireUndoTransparentStarted();
        }
        ++this.myUndoTransparentCount;
        try {
            action.run();
        }
        finally {
            --this.myUndoTransparentCount;
            if (this.myUndoTransparentCount == 0) {
                this.fireUndoTransparentFinished();
            }
        }
    }

    public boolean isUndoTransparentActionInProgress() {
        return this.myUndoTransparentCount > 0;
    }

    public void markCurrentCommandAsGlobal(Project project) {
        UndoManager manager = project != null ? UndoManager.getInstance((Project)project) : UndoManager.getGlobalInstance();
        ((UndoManagerImpl)manager).markCurrentCommandAsGlobal();
    }

    private void fireCommandStarted() {
        CommandEvent event = new CommandEvent((CommandProcessor)this, this.myCurrentCommand.myCommand, this.myCurrentCommand.myName, this.myCurrentCommand.myGroupId, this.myCurrentCommand.myProject, this.myCurrentCommand.myUndoConfirmationPolicy, this.myCurrentCommand.myDocument);
        for (CommandListener listener : this.myListeners) {
            try {
                listener.commandStarted(event);
            }
            catch (Throwable e) {
                CommandLog.LOG.error(e);
            }
        }
    }

    private void fireUndoTransparentStarted() {
        for (CommandListener listener : this.myListeners) {
            try {
                listener.undoTransparentActionStarted();
            }
            catch (Throwable e) {
                CommandLog.LOG.error(e);
            }
        }
    }

    private void fireUndoTransparentFinished() {
        for (CommandListener listener : this.myListeners) {
            try {
                listener.undoTransparentActionFinished();
            }
            catch (Throwable e) {
                CommandLog.LOG.error(e);
            }
        }
    }

    private static class CommandDescriptor {
        public final Runnable myCommand;
        public final Project myProject;
        public String myName;
        public Object myGroupId;
        public final Document myDocument;
        public final UndoConfirmationPolicy myUndoConfirmationPolicy;

        public CommandDescriptor(Runnable command, Project project, String name, Object groupId, UndoConfirmationPolicy undoConfirmationPolicy, Document document) {
            this.myCommand = command;
            this.myProject = project;
            this.myName = name;
            this.myGroupId = groupId;
            this.myUndoConfirmationPolicy = undoConfirmationPolicy;
            this.myDocument = document;
        }
    }
}

