/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Presentation;
import java.util.WeakHashMap;
import org.jetbrains.annotations.NotNull;

public class PresentationFactory {
    private final WeakHashMap<AnAction, Presentation> myAction2Presentation = new WeakHashMap();

    public final Presentation getPresentation(@NotNull AnAction action) {
        if (action == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/actionSystem/impl/PresentationFactory.getPresentation must not be null");
        }
        Presentation presentation = this.myAction2Presentation.get(action);
        if (presentation == null) {
            presentation = (Presentation)action.getTemplatePresentation().clone();
            this.myAction2Presentation.put(action, this.processPresentation(presentation));
        }
        return presentation;
    }

    protected Presentation processPresentation(Presentation presentation) {
        return presentation;
    }

    public void reset() {
        this.myAction2Presentation.clear();
    }
}

