/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.xml;

import com.intellij.lang.LangBundle;
import com.intellij.lang.cacheBuilder.WordsScanner;
import com.intellij.lang.findUsages.FindUsagesProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeDecl;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlElementDecl;
import com.intellij.psi.xml.XmlEntityDecl;
import com.intellij.psi.xml.XmlTag;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usageView.UsageViewUtil;
import org.jetbrains.annotations.NotNull;

public class XmlFindUsagesProvider
implements FindUsagesProvider {
    public boolean canFindUsagesFor(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/xml/XmlFindUsagesProvider.canFindUsagesFor must not be null");
        }
        return element instanceof XmlElementDecl || element instanceof XmlAttributeDecl || element instanceof XmlEntityDecl || element instanceof XmlTag || element instanceof XmlAttributeValue || element instanceof PsiFile || element instanceof XmlComment;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String getType(@NotNull PsiElement element) {
        String string;
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/xml/XmlFindUsagesProvider.getType must not be null");
        }
        if (element instanceof XmlTag) {
            PsiMetaData metaData = ((XmlTag)element).getMetaData();
            if (!(metaData != null && metaData.getDeclaration() instanceof XmlTag ? (string = ((XmlTag)metaData.getDeclaration()).getName()) != null : (string = LangBundle.message("xml.terms.xml.tag", new Object[0])) != null)) throw new IllegalStateException("@NotNull method com/intellij/lang/xml/XmlFindUsagesProvider.getType must not return null");
            return string;
        }
        if (element instanceof XmlElementDecl) {
            string = LangBundle.message("xml.terms.tag", new Object[0]);
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/lang/xml/XmlFindUsagesProvider.getType must not return null");
            return string;
        }
        if (element instanceof XmlAttributeDecl) {
            string = LangBundle.message("xml.terms.attribute", new Object[0]);
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/lang/xml/XmlFindUsagesProvider.getType must not return null");
            return string;
        }
        if (element instanceof XmlAttributeValue) {
            string = LangBundle.message("xml.terms.attribute.value", new Object[0]);
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/lang/xml/XmlFindUsagesProvider.getType must not return null");
            return string;
        }
        if (element instanceof XmlEntityDecl) {
            string = LangBundle.message("xml.terms.entity", new Object[0]);
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/lang/xml/XmlFindUsagesProvider.getType must not return null");
            return string;
        }
        if (element instanceof XmlAttribute) {
            string = LangBundle.message("xml.terms.attribute", new Object[0]);
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/lang/xml/XmlFindUsagesProvider.getType must not return null");
            return string;
        }
        if (!(element instanceof XmlComment)) {
            throw new IllegalArgumentException("Cannot get type for " + element);
        }
        string = LangBundle.message("xml.terms.variable", new Object[0]);
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/intellij/lang/xml/XmlFindUsagesProvider.getType must not return null");
    }

    public String getHelpId(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/xml/XmlFindUsagesProvider.getHelpId must not be null");
        }
        return "reference.dialogs.findUsages.other";
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String getDescriptiveName(@NotNull PsiElement element) {
        String string;
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/xml/XmlFindUsagesProvider.getDescriptiveName must not be null");
        }
        if (element instanceof XmlTag) {
            string = ((XmlTag)element).getName();
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/lang/xml/XmlFindUsagesProvider.getDescriptiveName must not return null");
            return string;
        }
        if (element instanceof XmlAttributeValue) {
            string = ((XmlAttributeValue)element).getValue();
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/lang/xml/XmlFindUsagesProvider.getDescriptiveName must not return null");
            return string;
        }
        if (element instanceof PsiNamedElement) {
            string = ((PsiNamedElement)element).getName();
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/lang/xml/XmlFindUsagesProvider.getDescriptiveName must not return null");
            return string;
        }
        string = element.getText();
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/intellij/lang/xml/XmlFindUsagesProvider.getDescriptiveName must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String getNodeText(@NotNull PsiElement element, boolean useFullName) {
        String string;
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/xml/XmlFindUsagesProvider.getNodeText must not be null");
        }
        if (element instanceof XmlTag) {
            XmlTag xmlTag = (XmlTag)element;
            PsiMetaData metaData = xmlTag.getMetaData();
            String name = metaData != null ? UsageViewUtil.getMetaDataName(metaData) : xmlTag.getName();
            string = UsageViewBundle.message((String)"usage.target.xml.tag.of.file", (Object[])new Object[]{metaData == null ? "<" + name + ">" : name, xmlTag.getContainingFile().getName()});
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/lang/xml/XmlFindUsagesProvider.getNodeText must not return null");
            return string;
        }
        if (element instanceof XmlAttributeValue) {
            string = ((XmlAttributeValue)element).getValue();
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/lang/xml/XmlFindUsagesProvider.getNodeText must not return null");
            return string;
        }
        if (element instanceof PsiNamedElement) {
            string = ((PsiNamedElement)element).getName();
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/lang/xml/XmlFindUsagesProvider.getNodeText must not return null");
            return string;
        }
        string = element.getText();
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/intellij/lang/xml/XmlFindUsagesProvider.getNodeText must not return null");
    }

    public WordsScanner getWordsScanner() {
        return null;
    }
}

