/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.java;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.JavaLexer;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.impl.java.stubs.JavaStubElementType;
import com.intellij.psi.impl.source.PsiJavaFileImpl;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;

public class JavaParserDefinition
implements ParserDefinition {
    private final TokenSet myStringLiteralElementSet = TokenSet.create((IElementType[])new IElementType[]{JavaElementType.LITERAL_EXPRESSION});

    @NotNull
    public Lexer createLexer(Project project) {
        JavaLexer javaLexer = new JavaLexer(LanguageLevelProjectExtension.getInstance((Project)project).getLanguageLevel());
        if (javaLexer == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/java/JavaParserDefinition.createLexer must not return null");
        }
        return javaLexer;
    }

    @NotNull
    public static Lexer createLexer(LanguageLevel languageLevel) {
        JavaLexer javaLexer = new JavaLexer(languageLevel);
        if (javaLexer == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/java/JavaParserDefinition.createLexer must not return null");
        }
        return javaLexer;
    }

    public IFileElementType getFileNodeType() {
        return JavaElementType.JAVA_FILE;
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        TokenSet tokenSet = JavaTokenType.WHITESPACE_BIT_SET;
        if (tokenSet == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/java/JavaParserDefinition.getWhitespaceTokens must not return null");
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        TokenSet tokenSet = JavaTokenType.COMMENT_BIT_SET;
        if (tokenSet == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/java/JavaParserDefinition.getCommentTokens must not return null");
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        TokenSet tokenSet = this.myStringLiteralElementSet;
        if (tokenSet == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/java/JavaParserDefinition.getStringLiteralElements must not return null");
        }
        return tokenSet;
    }

    @NotNull
    public PsiParser createParser(Project project) {
        PsiParser psiParser = PsiUtil.NULL_PARSER;
        if (psiParser == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/java/JavaParserDefinition.createParser must not return null");
        }
        return psiParser;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public PsiElement createElement(ASTNode node) {
        Object object;
        IElementType type = node.getElementType();
        if (type instanceof JavaStubElementType) {
            object = ((JavaStubElementType)type).createPsi(node);
            if (object == null) throw new IllegalStateException("@NotNull method com/intellij/lang/java/JavaParserDefinition.createElement must not return null");
            return object;
        }
        object = PsiUtil.NULL_PSI_ELEMENT;
        if (object != null) return object;
        throw new IllegalStateException("@NotNull method com/intellij/lang/java/JavaParserDefinition.createElement must not return null");
    }

    public PsiFile createFile(FileViewProvider viewProvider) {
        return new PsiJavaFileImpl(viewProvider);
    }

    public ParserDefinition.SpaceRequirements spaceExistanceTypeBetweenTokens(ASTNode left, ASTNode right) {
        String text;
        PsiFile containingFile = left.getTreeParent().getPsi().getContainingFile();
        JavaLexer lexer = containingFile instanceof PsiJavaFile ? new JavaLexer(((PsiJavaFile)containingFile).getLanguageLevel()) : new JavaLexer(LanguageLevel.HIGHEST);
        if (right.getElementType() == JavaDocTokenType.DOC_TAG_VALUE_SHARP_TOKEN) {
            return ParserDefinition.SpaceRequirements.MUST_NOT;
        }
        if (left.getElementType() == JavaDocTokenType.DOC_TAG_VALUE_SHARP_TOKEN) {
            return ParserDefinition.SpaceRequirements.MUST_NOT;
        }
        ParserDefinition.SpaceRequirements spaceRequirements = LanguageUtil.canStickTokensTogetherByLexer((ASTNode)left, (ASTNode)right, (Lexer)lexer);
        if (left.getElementType() == JavaTokenType.END_OF_LINE_COMMENT) {
            return ParserDefinition.SpaceRequirements.MUST_LINE_BREAK;
        }
        if (left.getElementType() == JavaDocTokenType.DOC_COMMENT_DATA && (text = left.getText()).length() > 0 && Character.isWhitespace(text.charAt(text.length() - 1))) {
            return ParserDefinition.SpaceRequirements.MAY;
        }
        if (right.getElementType() == JavaDocTokenType.DOC_COMMENT_DATA ? (text = right.getText()).length() > 0 && Character.isWhitespace(text.charAt(0)) : right.getElementType() == JavaDocTokenType.DOC_INLINE_TAG_END) {
            return ParserDefinition.SpaceRequirements.MAY;
        }
        return spaceRequirements;
    }
}

