/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.psiView;

import com.intellij.internal.psiView.PsiViewerExtension;
import com.intellij.internal.psiView.PsiViewerSettings;
import com.intellij.internal.psiView.ViewerNodeDescriptor;
import com.intellij.internal.psiView.ViewerTreeBuilder;
import com.intellij.internal.psiView.ViewerTreeStructure;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.fileTypes.impl.AbstractFileType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.DimensionService;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.ui.SortedComboBoxModel;
import com.intellij.ui.TitledBorderWithMnemonic;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiViewerDialog
extends DialogWrapper
implements DataProvider {
    private final Project myProject;
    private final Tree myTree;
    private final ViewerTreeBuilder myTreeBuilder;
    private final JList myRefs;
    private static String REFS_CACHE = "References Resolve Cache";
    private EditorEx myEditor;
    private String myLastParsedText = null;
    private JCheckBox myShowWhiteSpacesBox;
    private JPanel myStructureTreePanel;
    private JPanel myTextPanel;
    private JPanel myPanel;
    private JCheckBox myShowTreeNodesCheckBox;
    private JComboBox myDialectsComboBox;
    private JPanel myReferencesPanel;
    private JPanel myButtonPanel;
    private JSplitPane myTextSplit;
    private JSplitPane myTreeSplit;
    private Presentation myPresentation;
    private Map<String, Object> handlers;
    private DefaultActionGroup myGroup;
    private Language[] myLanguageDialects;
    private final Color SELECTION_BG_COLOR;
    private static final Comparator<Language> DIALECTS_COMPARATOR = new Comparator<Language>(){

        @Override
        public int compare(Language o1, Language o2) {
            if (o1 == null) {
                return o2 == null ? 0 : -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.getID().compareTo(o2.getID());
        }
    };
    private EditorListener myEditorListener;
    private int myLastParsedTextHashCode;
    private int myNewDocumentHashCode;

    @Nullable
    private static PsiElement findCommonParent(PsiElement start, PsiElement end) {
        TextRange range = end.getTextRange();
        while (start != null && !start.getTextRange().contains(range)) {
            start = start.getParent();
        }
        return start;
    }

    public PsiViewerDialog(Project project, boolean modal) {
        super(project, true);
        this.$$$setupUI$$$();
        this.myPresentation = new Presentation();
        this.handlers = new HashMap<String, Object>();
        this.SELECTION_BG_COLOR = Registry.getColor((String)"psi.viewer.selection.color", (Color)new Color(255, 204, 204));
        this.myEditorListener = new EditorListener();
        this.myLastParsedTextHashCode = 17;
        this.myNewDocumentHashCode = 11;
        this.setTitle("PSI Viewer");
        this.myProject = project;
        this.myTree = new Tree((TreeModel)new DefaultTreeModel(new DefaultMutableTreeNode()));
        UIUtil.setLineStyleAngled((JTree)this.myTree);
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(true);
        this.myTree.updateUI();
        ToolTipManager.sharedInstance().registerComponent((JComponent)this.myTree);
        TreeUtil.installActions((JTree)this.myTree);
        new TreeSpeedSearch((JTree)this.myTree);
        this.myTreeBuilder = new ViewerTreeBuilder(project, (JTree)this.myTree);
        this.myTree.addTreeSelectionListener((TreeSelectionListener)new MyTreeSelectionListener());
        JScrollPane scrollPane = new JScrollPane((Component)this.myTree);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)scrollPane, "Center");
        this.myStructureTreePanel.setLayout(new BorderLayout());
        this.myStructureTreePanel.add((Component)panel, "Center");
        this.myRefs = new JList(new DefaultListModel());
        JScrollPane refScrollPane = new JScrollPane(this.myRefs);
        JPanel refPanel = new JPanel(new BorderLayout());
        refPanel.add((Component)refScrollPane, "Center");
        this.myReferencesPanel.setLayout(new BorderLayout());
        this.myReferencesPanel.add((Component)refPanel, "Center");
        GoToListener listener = new GoToListener();
        this.myRefs.addKeyListener(listener);
        this.myRefs.addMouseListener(listener);
        this.myRefs.getSelectionModel().addListSelectionListener(listener);
        this.myRefs.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component comp = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (PsiViewerDialog.this.resolve(index) == null) {
                    comp.setForeground(Color.red);
                }
                return comp;
            }
        });
        this.setModal(modal);
        this.setOKButtonText("&Build PSI Tree");
        this.init();
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.internal.psiView.PsiViewerDialog";
    }

    protected String getHelpId() {
        return "reference.psi.viewer";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myEditor.getContentComponent();
    }

    private void updatePresentation(Presentation p) {
        this.myPresentation.setText(p.getText());
        this.myPresentation.setIcon(p.getIcon());
    }

    protected void init() {
        this.initBorders();
        ArrayList<Presentation> items = new ArrayList<Presentation>();
        EditorFactory editorFactory = EditorFactory.getInstance();
        Document document = editorFactory.createDocument((CharSequence)"");
        this.myEditor = (EditorEx)editorFactory.createEditor(document, this.myProject);
        this.myEditor.getSettings().setFoldingOutlineShown(false);
        document.addDocumentListener((DocumentListener)this.myEditorListener);
        this.myEditor.getSelectionModel().addSelectionListener((SelectionListener)this.myEditorListener);
        this.myEditor.getCaretModel().addCaretListener((CaretListener)this.myEditorListener);
        for (PsiViewerExtension extension : (PsiViewerExtension[])Extensions.getExtensions(PsiViewerExtension.EP_NAME)) {
            Presentation p = new Presentation(extension.getName());
            p.setIcon(extension.getIcon());
            this.handlers.put(p.getText(), extension);
            items.add(p);
        }
        HashSet<FileType> allFileTypes = new HashSet<FileType>();
        Collections.addAll(allFileTypes, FileTypeManager.getInstance().getRegisteredFileTypes());
        for (Language language : Language.getRegisteredLanguages()) {
            FileType fileType = language.getAssociatedFileType();
            if (fileType == null) continue;
            allFileTypes.add(fileType);
        }
        for (FileType fileType : allFileTypes) {
            if (fileType == StdFileTypes.GUI_DESIGNER_FORM || fileType == StdFileTypes.IDEA_MODULE || fileType == StdFileTypes.IDEA_PROJECT || fileType == StdFileTypes.IDEA_WORKSPACE || fileType == FileTypes.ARCHIVE || fileType == FileTypes.UNKNOWN || fileType == FileTypes.PLAIN_TEXT || fileType instanceof AbstractFileType || fileType.isBinary() || fileType.isReadOnly()) continue;
            Presentation p = new Presentation(fileType.getName() + " file");
            p.setIcon(fileType.getIcon());
            this.handlers.put(p.getText(), fileType);
            items.add(p);
        }
        Presentation[] popupItems = items.toArray(new Presentation[items.size()]);
        Arrays.sort(popupItems, new Comparator<Presentation>(){

            @Override
            public int compare(Presentation p1, Presentation p2) {
                return p1.getText().toUpperCase().compareTo(p2.getText().toUpperCase());
            }
        });
        final ViewerTreeStructure treeStructure = (ViewerTreeStructure)this.myTreeBuilder.getTreeStructure();
        this.myShowWhiteSpacesBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                treeStructure.setShowWhiteSpaces(PsiViewerDialog.this.myShowWhiteSpacesBox.isSelected());
                PsiViewerDialog.this.myTreeBuilder.queueUpdate();
            }
        });
        this.myShowTreeNodesCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                treeStructure.setShowTreeNodes(PsiViewerDialog.this.myShowTreeNodesCheckBox.isSelected());
                PsiViewerDialog.this.myTreeBuilder.queueUpdate();
            }
        });
        this.myTextPanel.setLayout(new BorderLayout());
        this.myTextPanel.add((Component)this.myEditor.getComponent(), "Center");
        this.myGroup = new DefaultActionGroup();
        for (Presentation popupItem : popupItems) {
            this.myGroup.add((AnAction)new PopupItemAction(popupItem));
        }
        final PsiViewerSettings settings = PsiViewerSettings.getSettings();
        String type = settings.type;
        for (Presentation popupItem : popupItems) {
            if (!popupItem.getText().equals(type)) continue;
            this.updatePresentation(popupItem);
            break;
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                PsiViewerDialog.this.myEditor.getDocument().setText((CharSequence)settings.text);
                PsiViewerDialog.this.myEditor.getSelectionModel().setSelection(0, settings.text.length());
            }
        });
        this.myShowWhiteSpacesBox.setSelected(settings.showWhiteSpaces);
        treeStructure.setShowWhiteSpaces(settings.showWhiteSpaces);
        this.myShowTreeNodesCheckBox.setSelected(settings.showTreeNodes);
        treeStructure.setShowTreeNodes(settings.showTreeNodes);
        ChoosePsiTypeButton typeButton = new ChoosePsiTypeButton();
        this.myButtonPanel.add((Component)typeButton.createCustomComponent(this.myPresentation), "Center");
        this.updateDialectsCombo();
        this.myDialectsComboBox.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component result = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value == null) {
                    this.setText("<no dialect>");
                }
                return result;
            }
        });
        if (this.myDialectsComboBox.isVisible()) {
            for (int i = 0; i < this.myLanguageDialects.length; ++i) {
                if (!settings.dialect.equals(this.myLanguageDialects[i].toString())) continue;
                this.myDialectsComboBox.setSelectedIndex(i + 1);
                break;
            }
        }
        this.registerCustomKeyboardActions();
        Dimension size = DimensionService.getInstance().getSize(this.getDimensionServiceKey(), this.myProject);
        if (size == null) {
            DimensionService.getInstance().setSize(this.getDimensionServiceKey(), new Dimension(600, 600));
        }
        this.myTextSplit.setDividerLocation(settings.textDividerLocation);
        this.myTreeSplit.setDividerLocation(settings.treeDividerLocation);
        this.updateEditor();
        super.init();
    }

    private void registerCustomKeyboardActions() {
        Component button;
        Component component = this.myButtonPanel.getComponents()[0];
        if (component instanceof JComponent && (button = ((JComponent)component).getComponents()[0]) instanceof JButton) {
            final JButton jButton = (JButton)button;
            int mask = SystemInfo.isMac ? 256 : 512;
            this.registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    jButton.doClick();
                }
            }, KeyStroke.getKeyStroke(80, mask));
            this.registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PsiViewerDialog.this.focusEditor();
                }
            }, KeyStroke.getKeyStroke(84, mask));
            this.registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PsiViewerDialog.this.focusTree();
                }
            }, KeyStroke.getKeyStroke(83, mask));
            this.registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PsiViewerDialog.this.focusTree();
                }
            }, KeyStroke.getKeyStroke(83, mask));
            this.registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PsiViewerDialog.this.focusTree();
                }
            }, KeyStroke.getKeyStroke(83, mask));
            this.registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PsiViewerDialog.this.focusRefs();
                }
            }, KeyStroke.getKeyStroke(82, mask));
            this.registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (PsiViewerDialog.this.myRefs.isFocusOwner()) {
                        PsiViewerDialog.this.focusTree();
                    } else if (PsiViewerDialog.this.myTree.isFocusOwner()) {
                        PsiViewerDialog.this.focusRefs();
                    }
                }
            }, KeyStroke.getKeyStroke(9, 0));
        }
    }

    private void registerKeyboardAction(ActionListener actionListener, KeyStroke keyStroke) {
        this.getRootPane().registerKeyboardAction(actionListener, keyStroke, 2);
    }

    private void focusEditor() {
        IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)this.myEditor.getContentComponent(), true);
    }

    private void focusTree() {
        IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)this.myTree, true);
    }

    private void focusRefs() {
        IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)this.myRefs, true);
        if (this.myRefs.getModel().getSize() > 0 && this.myRefs.getSelectedIndex() == -1) {
            this.myRefs.setSelectedIndex(0);
        }
    }

    private void initBorders() {
        this.myTextPanel.setBorder((Border)new TitledBorderWithMnemonic("&Text"));
        this.myStructureTreePanel.setBorder((Border)new TitledBorderWithMnemonic("PSI &Structure"));
        this.myReferencesPanel.setBorder((Border)new TitledBorderWithMnemonic("&References"));
    }

    @Nullable
    private PsiElement getPsiElement() {
        TreePath path = this.myTree.getSelectionPath();
        return path == null ? null : PsiViewerDialog.getPsiElement((DefaultMutableTreeNode)path.getLastPathComponent());
    }

    @Nullable
    private static PsiElement getPsiElement(DefaultMutableTreeNode node) {
        if (node.getUserObject() instanceof ViewerNodeDescriptor) {
            ViewerNodeDescriptor descriptor = (ViewerNodeDescriptor)((Object)node.getUserObject());
            Object elementObject = descriptor.getElement();
            return elementObject instanceof PsiElement ? (PsiElement)elementObject : (elementObject instanceof ASTNode ? ((ASTNode)elementObject).getPsi() : null);
        }
        return null;
    }

    private void updateDialectsCombo() {
        SortedComboBoxModel model = new SortedComboBoxModel(DIALECTS_COMPARATOR);
        Object handler = this.getHandler();
        if (handler instanceof LanguageFileType) {
            Language baseLang = ((LanguageFileType)handler).getLanguage();
            this.myLanguageDialects = LanguageUtil.getLanguageDialects((Language)baseLang);
            Arrays.sort(this.myLanguageDialects, DIALECTS_COMPARATOR);
            model.setAll((Object[])this.myLanguageDialects);
            model.add(null);
        }
        this.myDialectsComboBox.setModel(model);
        this.myDialectsComboBox.setVisible(model.getSize() > 1);
        if (!this.myDialectsComboBox.isVisible()) {
            this.myLanguageDialects = new Language[0];
        }
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    private Object getHandler() {
        return this.handlers.get(this.myPresentation.getText());
    }

    protected void doOKAction() {
        String text = this.myEditor.getDocument().getText();
        if (text.trim().length() == 0) {
            return;
        }
        this.myLastParsedText = text;
        this.myNewDocumentHashCode = this.myLastParsedTextHashCode = text.hashCode();
        PsiElement rootElement = null;
        Object handler = this.getHandler();
        try {
            if (handler instanceof PsiViewerExtension) {
                PsiViewerExtension ext = (PsiViewerExtension)handler;
                rootElement = ext.createElement(this.myProject, text);
            } else if (handler instanceof FileType) {
                FileType type = (FileType)handler;
                if (type instanceof LanguageFileType) {
                    Language language = ((LanguageFileType)type).getLanguage();
                    Language dialect = (Language)this.myDialectsComboBox.getSelectedItem();
                    rootElement = PsiFileFactory.getInstance((Project)this.myProject).createFileFromText("Dummy." + type.getDefaultExtension(), dialect == null ? language : dialect, (CharSequence)text);
                } else {
                    rootElement = PsiFileFactory.getInstance((Project)this.myProject).createFileFromText("Dummy." + type.getDefaultExtension(), text);
                }
            }
            this.focusTree();
        }
        catch (IncorrectOperationException e1) {
            rootElement = null;
            Messages.showMessageDialog((Project)this.myProject, (String)e1.getMessage(), (String)"Error", (Icon)Messages.getErrorIcon());
        }
        ViewerTreeStructure structure = (ViewerTreeStructure)this.myTreeBuilder.getTreeStructure();
        structure.setRootPsiElement(rootElement);
        this.myTreeBuilder.queueUpdate();
        this.myTree.setRootVisible(true);
        this.myTree.expandRow(0);
        this.myTree.setRootVisible(false);
    }

    public Object getData(@NonNls String dataId) {
        if (PlatformDataKeys.NAVIGATABLE.is(dataId)) {
            Object value;
            String fqn = null;
            if (this.myTree.hasFocus()) {
                TreePath path = this.myTree.getSelectionPath();
                if (path != null) {
                    PsiElement element;
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                    if (!(node.getUserObject() instanceof ViewerNodeDescriptor)) {
                        return null;
                    }
                    ViewerNodeDescriptor descriptor = (ViewerNodeDescriptor)((Object)node.getUserObject());
                    Object elementObject = descriptor.getElement();
                    Object object = elementObject instanceof PsiElement ? (PsiElement)elementObject : (element = elementObject instanceof ASTNode ? ((ASTNode)elementObject).getPsi() : null);
                    if (element != null) {
                        fqn = element.getClass().getName();
                    }
                }
            } else if (this.myRefs.hasFocus() && (value = this.myRefs.getSelectedValue()) instanceof String) {
                fqn = (String)value;
            }
            if (fqn != null) {
                return this.getContainingFileForClass(fqn);
            }
        }
        return null;
    }

    public void doCancelAction() {
        PsiViewerSettings settings = PsiViewerSettings.getSettings();
        settings.type = this.myPresentation.getText();
        settings.text = this.myEditor.getDocument().getText();
        settings.showTreeNodes = this.myShowTreeNodesCheckBox.isSelected();
        settings.showWhiteSpaces = this.myShowWhiteSpacesBox.isSelected();
        Object selectedDialect = this.myDialectsComboBox.getSelectedItem();
        settings.dialect = this.myDialectsComboBox.isVisible() && selectedDialect != null ? selectedDialect.toString() : "";
        settings.textDividerLocation = this.myTextSplit.getDividerLocation();
        settings.treeDividerLocation = this.myTreeSplit.getDividerLocation();
        super.doCancelAction();
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myTreeBuilder);
        EditorFactory.getInstance().releaseEditor((Editor)this.myEditor);
        super.dispose();
    }

    @Nullable
    private PsiElement resolve(int index) {
        PsiElement[] elements;
        HashMap map;
        Object cache;
        PsiElement element = this.getPsiElement();
        if (element == null) {
            return null;
        }
        HashMap o = this.myRefs.getClientProperty(REFS_CACHE);
        if (o == null) {
            o = new HashMap();
            this.myRefs.putClientProperty(REFS_CACHE, o);
        }
        if ((cache = (map = (HashMap)o).get(element)) == null) {
            PsiReference[] references = element.getReferences();
            cache = new PsiElement[references.length];
            for (int i = 0; i < references.length; ++i) {
                ((PsiElement[])cache)[i] = references[i].resolve();
            }
            map.put(element, cache);
        }
        return index >= (elements = (PsiElement[])cache).length ? null : elements[index];
    }

    @Nullable
    private PsiFile getContainingFileForClass(String fqn) {
        PsiFile[] files;
        String filename = fqn;
        if (fqn.contains(".")) {
            filename = fqn.substring(fqn.lastIndexOf(46) + 1);
        }
        if (filename.contains("$")) {
            filename = filename.substring(0, filename.indexOf(36));
        }
        if ((files = FilenameIndex.getFilesByName(this.myProject, filename = filename + ".java", GlobalSearchScope.allScope((Project)this.myProject))) != null && files.length > 0) {
            return files[0];
        }
        return null;
    }

    @Nullable
    public static TreeNode findNodeWithObject(Object object, TreeModel model, Object parent) {
        for (int i = 0; i < model.getChildCount(parent); ++i) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)model.getChild(parent, i);
            if (childNode.getUserObject().equals(object)) {
                return childNode;
            }
            TreeNode node = PsiViewerDialog.findNodeWithObject(object, model, childNode);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    private FileType getFileType() {
        Object handler = this.getHandler();
        return handler instanceof FileType ? (FileType)handler : (handler instanceof PsiViewerExtension ? ((PsiViewerExtension)handler).getDefaultFileType() : PlainTextFileType.INSTANCE);
    }

    private void updateEditor() {
        this.myEditor.setHighlighter(EditorHighlighterFactory.getInstance().createEditorHighlighter(this.myProject, this.getFileType()));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JComboBox jComboBox;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JPanel jPanel2;
        JPanel jPanel3;
        JSplitPane jSplitPane;
        JPanel jPanel4;
        JSplitPane jSplitPane2;
        JPanel jPanel5;
        this.myPanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myTextSplit = jSplitPane2 = new JSplitPane();
        jSplitPane2.setOrientation(0);
        jSplitPane2.setDividerLocation(250);
        jSplitPane2.setDividerSize(4);
        jPanel5.add((Component)jSplitPane2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 200), null));
        this.myTextPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.setFocusCycleRoot(true);
        jSplitPane2.setLeftComponent(jPanel4);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jSplitPane2.setRightComponent(jPanel6);
        this.myTreeSplit = jSplitPane = new JSplitPane();
        jSplitPane.setDividerLocation(400);
        jSplitPane.setDividerSize(4);
        jPanel6.add((Component)jSplitPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 200), null));
        this.myStructureTreePanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.setFocusCycleRoot(true);
        jSplitPane.setLeftComponent(jPanel3);
        this.myReferencesPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.setFocusCycleRoot(true);
        jSplitPane.setRightComponent(jPanel2);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 6, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel7, new GridConstraints(0, 0, 1, 1, 8, 2, 3, 0, null, null, null));
        this.myShowWhiteSpacesBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setFocusCycleRoot(true);
        jCheckBox2.setText("Show PsiWhiteSpace");
        jCheckBox2.setMnemonic('W');
        jCheckBox2.setDisplayedMnemonicIndex(8);
        jCheckBox2.setSelected(true);
        jCheckBox2.setMargin(new Insets(0, 0, 0, 0));
        jPanel7.add((Component)jCheckBox2, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myShowTreeNodesCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setFocusCycleRoot(true);
        jCheckBox.setText("Show Tree Nodes");
        jCheckBox.setMnemonic('N');
        jCheckBox.setDisplayedMnemonicIndex(10);
        jCheckBox.setSelected(true);
        jCheckBox.setMargin(new Insets(0, 0, 0, 0));
        jPanel7.add((Component)jCheckBox, new GridConstraints(0, 3, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myDialectsComboBox = jComboBox = new JComboBox();
        jComboBox.setFocusCycleRoot(true);
        jPanel7.add(jComboBox, new GridConstraints(0, 4, 1, 1, 8, 1, 2, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel7.add((Component)spacer, new GridConstraints(0, 5, 1, 1, 0, 1, 6, 1, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setIconTextGap(0);
        jLabel.setText("Show PSI structure for:");
        jLabel.setDisplayedMnemonic('P');
        jLabel.setDisplayedMnemonicIndex(5);
        jPanel7.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myButtonPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel.setFocusCycleRoot(true);
        jPanel7.add((Component)jPanel, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private class EditorListener
    implements CaretListener,
    SelectionListener,
    DocumentListener {
        private EditorListener() {
        }

        public void caretPositionChanged(CaretEvent e) {
            if (!this.available() || PsiViewerDialog.this.myEditor.getSelectionModel().hasSelection()) {
                return;
            }
            PsiFile psiFile = this.getPsiFile();
            if (psiFile == null) {
                return;
            }
            int offset = PsiViewerDialog.this.myEditor.getCaretModel().getOffset();
            PsiElement element = PsiUtilBase.getElementAtOffset((PsiFile)psiFile, (int)offset);
            PsiViewerDialog.this.myTreeBuilder.select(element);
        }

        public void selectionChanged(SelectionEvent e) {
            if (!this.available() || !PsiViewerDialog.this.myEditor.getSelectionModel().hasSelection()) {
                return;
            }
            PsiFile psiFile = this.getPsiFile();
            if (psiFile == null) {
                return;
            }
            SelectionModel selection = PsiViewerDialog.this.myEditor.getSelectionModel();
            int start = selection.getSelectionStart();
            int end = selection.getSelectionEnd();
            PsiElement element = PsiViewerDialog.findCommonParent(PsiUtilBase.getElementAtOffset((PsiFile)psiFile, (int)start), PsiUtilBase.getElementAtOffset((PsiFile)psiFile, (int)end));
            PsiViewerDialog.this.myTreeBuilder.select(element);
        }

        private boolean available() {
            return PsiViewerDialog.this.myLastParsedTextHashCode == PsiViewerDialog.this.myNewDocumentHashCode && PsiViewerDialog.this.myEditor.getContentComponent().hasFocus();
        }

        @Nullable
        private PsiFile getPsiFile() {
            PsiElement root = ((ViewerTreeStructure)PsiViewerDialog.this.myTreeBuilder.getTreeStructure()).getRootPsiElement();
            return root instanceof PsiFile ? (PsiFile)root : null;
        }

        public void beforeDocumentChange(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
            PsiViewerDialog.this.myNewDocumentHashCode = event.getDocument().getText().hashCode();
        }
    }

    private class PopupItemAction
    extends AnAction
    implements DumbAware {
        public PopupItemAction(Presentation p) {
            super(p.getText(), p.getText(), p.getIcon());
        }

        public void actionPerformed(AnActionEvent e) {
            PsiViewerDialog.this.updatePresentation(e.getPresentation());
            PsiViewerDialog.this.updateDialectsCombo();
            PsiViewerDialog.this.updateEditor();
        }
    }

    private class GoToListener
    implements KeyListener,
    MouseListener,
    ListSelectionListener {
        private RangeHighlighter myHighlighter;
        private final TextAttributes myAttributes;

        private GoToListener() {
            this.myAttributes = new TextAttributes(Color.white, PsiViewerDialog.this.SELECTION_BG_COLOR, Color.red, EffectType.BOXED, 0);
        }

        private void navigate() {
            String fqn;
            PsiFile file;
            this.clearSelection();
            Object value = PsiViewerDialog.this.myRefs.getSelectedValue();
            if (value instanceof String && (file = PsiViewerDialog.this.getContainingFileForClass(fqn = (String)value)) != null) {
                file.navigate(true);
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                this.navigate();
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() > 1) {
                this.navigate();
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            PsiReference[] references;
            this.clearSelection();
            PsiViewerDialog.this.updateDialectsCombo();
            int ind = PsiViewerDialog.this.myRefs.getSelectedIndex();
            PsiElement element = PsiViewerDialog.this.getPsiElement();
            if (ind > -1 && element != null && ind < (references = element.getReferences()).length) {
                TextRange textRange = references[ind].getRangeInElement();
                TextRange range = element.getTextRange();
                int start = range.getStartOffset();
                int end = range.getEndOffset();
                ViewerTreeStructure treeStructure = (ViewerTreeStructure)PsiViewerDialog.this.myTreeBuilder.getTreeStructure();
                PsiElement rootPsiElement = treeStructure.getRootPsiElement();
                if (rootPsiElement != null) {
                    int baseOffset = rootPsiElement.getTextRange().getStartOffset();
                    start -= baseOffset;
                    end -= baseOffset;
                }
                end = (start += textRange.getStartOffset()) + textRange.getLength();
                this.myHighlighter = PsiViewerDialog.this.myEditor.getMarkupModel().addRangeHighlighter(start, end, 1001, this.myAttributes, HighlighterTargetArea.EXACT_RANGE);
            }
        }

        public void clearSelection() {
            if (this.myHighlighter != null && Arrays.asList(PsiViewerDialog.this.myEditor.getMarkupModel().getAllHighlighters()).contains(this.myHighlighter)) {
                PsiViewerDialog.this.myEditor.getMarkupModel().removeHighlighter(this.myHighlighter);
                this.myHighlighter = null;
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }

    private class ChoosePsiTypeButton
    extends ComboBoxAction {
        private ChoosePsiTypeButton() {
        }

        protected int getMaxRows() {
            return 15;
        }

        protected int getMinWidth() {
            return 150;
        }

        protected int getMinHeight() {
            return 200;
        }

        @NotNull
        protected DefaultActionGroup createPopupActionGroup(JComponent button) {
            DefaultActionGroup defaultActionGroup = PsiViewerDialog.this.myGroup;
            if (defaultActionGroup == null) {
                throw new IllegalStateException("@NotNull method com/intellij/internal/psiView/PsiViewerDialog$ChoosePsiTypeButton.createPopupActionGroup must not return null");
            }
            return defaultActionGroup;
        }
    }

    private class MyTreeSelectionListener
    implements TreeSelectionListener {
        private final TextAttributes myAttributes = new TextAttributes();

        public MyTreeSelectionListener() {
            this.myAttributes.setBackgroundColor(PsiViewerDialog.this.SELECTION_BG_COLOR);
            this.myAttributes.setForegroundColor(Color.white);
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            if (!PsiViewerDialog.this.myEditor.getDocument().getText().equals(PsiViewerDialog.this.myLastParsedText)) {
                return;
            }
            TreePath path = PsiViewerDialog.this.myTree.getSelectionPath();
            if (path == null) {
                this.clearSelection();
            } else {
                PsiElement element;
                this.clearSelection();
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                if (!(node.getUserObject() instanceof ViewerNodeDescriptor)) {
                    return;
                }
                ViewerNodeDescriptor descriptor = (ViewerNodeDescriptor)((Object)node.getUserObject());
                Object elementObject = descriptor.getElement();
                Object object = elementObject instanceof PsiElement ? (PsiElement)elementObject : (element = elementObject instanceof ASTNode ? ((ASTNode)elementObject).getPsi() : null);
                if (element != null) {
                    int textLength;
                    TextRange range = element.getTextRange();
                    int start = range.getStartOffset();
                    int end = range.getEndOffset();
                    ViewerTreeStructure treeStructure = (ViewerTreeStructure)PsiViewerDialog.this.myTreeBuilder.getTreeStructure();
                    PsiElement rootPsiElement = treeStructure.getRootPsiElement();
                    if (rootPsiElement != null) {
                        int baseOffset = rootPsiElement.getTextRange().getStartOffset();
                        start -= baseOffset;
                        end -= baseOffset;
                    }
                    if (end <= (textLength = PsiViewerDialog.this.myEditor.getDocument().getTextLength())) {
                        PsiViewerDialog.this.myEditor.getMarkupModel().addRangeHighlighter(start, end, 6000, this.myAttributes, HighlighterTargetArea.EXACT_RANGE);
                        if (PsiViewerDialog.this.myTree.hasFocus()) {
                            PsiViewerDialog.this.myEditor.getCaretModel().moveToOffset(start);
                            PsiViewerDialog.this.myEditor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
                        } else {
                            PsiViewerDialog.this.myEditor.getScrollingModel().scrollTo(PsiViewerDialog.this.myEditor.offsetToLogicalPosition(start), ScrollType.MAKE_VISIBLE);
                        }
                    }
                    this.updateReferences(element);
                }
            }
        }

        public void updateReferences(PsiElement element) {
            DefaultListModel model = (DefaultListModel)PsiViewerDialog.this.myRefs.getModel();
            model.clear();
            Object cache = PsiViewerDialog.this.myRefs.getClientProperty(REFS_CACHE);
            if (cache instanceof Map) {
                ((Map)cache).clear();
            } else {
                PsiViewerDialog.this.myRefs.putClientProperty(REFS_CACHE, new HashMap());
            }
            if (element != null) {
                for (PsiReference reference : element.getReferences()) {
                    model.addElement(reference.getClass().getName());
                }
            }
        }

        private void clearSelection() {
            PsiViewerDialog.this.myEditor.getMarkupModel().removeAllHighlighters();
        }
    }
}

