/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInsight.generation.PsiGenerationInfo;
import com.intellij.ide.IdeView;
import com.intellij.ide.util.PackageChooserDialog;
import com.intellij.ide.util.PackageUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCodeFragment;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PackageScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.ui.EditorTextField;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class GenerateVisitorByHierarchyAction
extends AnAction {
    public GenerateVisitorByHierarchyAction() {
        super("Generate Hierarchy Visitor");
    }

    public void actionPerformed(AnActionEvent e) {
        PsiPackage aPackage;
        final Ref visitorNameRef = Ref.create((Object)"MyVisitor");
        final Ref parentClassRef = Ref.create(null);
        final Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        assert (project != null);
        final JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        final PsiNameHelper helper = psiFacade.getNameHelper();
        PackageChooserDialog dialog = new PackageChooserDialog("Choose Visitor Name, Package and Parent Class", project){
            {
                super(x0, x1);
                this.updateOKAction();
            }

            @Override
            protected JComponent createCenterPanel() {
                JPanel panel = new JPanel(new BorderLayout());
                panel.add((Component)super.createCenterPanel(), "Center");
                panel.add((Component)this.createNamePanel(), "North");
                panel.add((Component)this.createBaseClassPanel(), "South");
                return panel;
            }

            private JComponent createNamePanel() {
                JPanel panel = new JPanel(new BorderLayout());
                panel.add((Component)new JLabel("Visitor Name"), "West");
                final JTextField nameField = new JTextField((String)visitorNameRef.get());
                nameField.getDocument().addDocumentListener((javax.swing.event.DocumentListener)new com.intellij.ui.DocumentAdapter(){

                    protected void textChanged(javax.swing.event.DocumentEvent e) {
                        visitorNameRef.set((Object)nameField.getText());
                        this.updateOKAction();
                    }
                });
                panel.add((Component)nameField, "Center");
                return panel;
            }

            private JComponent createBaseClassPanel() {
                JPanel panel = new JPanel(new BorderLayout());
                panel.add((Component)new JLabel("Hierarchy Base Class"), "West");
                PsiElementFactory factory = psiFacade.getElementFactory();
                final PsiTypeCodeFragment codeFragment = factory.createTypeCodeFragment("", null, true, true);
                Document document = PsiDocumentManager.getInstance((Project)project).getDocument((PsiFile)codeFragment);
                EditorTextField editorTextField = new EditorTextField(document, project, (FileType)StdFileTypes.JAVA);
                editorTextField.addDocumentListener((DocumentListener)new DocumentAdapter(){

                    public void documentChanged(DocumentEvent e) {
                        parentClassRef.set(null);
                        try {
                            PsiType psiType = codeFragment.getType();
                            PsiClass psiClass = psiType instanceof PsiClassType ? ((PsiClassType)psiType).resolve() : null;
                            parentClassRef.set((Object)psiClass);
                        }
                        catch (PsiTypeCodeFragment.IncorrectTypeException incorrectTypeException) {
                            // empty catch block
                        }
                        this.updateOKAction();
                    }
                });
                panel.add((Component)editorTextField.getComponent(), "Center");
                return panel;
            }

            private void updateOKAction() {
                PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
                String message = !helper.isQualifiedName((String)visitorNameRef.get()) ? "Visitor name is not valid" : (parentClassRef.isNull() ? "Hierarchy parent should be specified" : (((PsiClass)parentClassRef.get()).isAnnotationType() || ((PsiClass)parentClassRef.get()).isEnum() ? "Hierarchy parent should be interface or class" : null));
                this.setErrorText(message);
                this.setOKActionEnabled(message == null);
            }
        };
        PsiElement element = (PsiElement)LangDataKeys.PSI_ELEMENT.getData(e.getDataContext());
        if (element instanceof PsiPackage) {
            dialog.selectPackage(((PsiPackage)element).getQualifiedName());
        } else if (element instanceof PsiDirectory && (aPackage = JavaDirectoryService.getInstance().getPackage((PsiDirectory)element)) != null) {
            dialog.selectPackage(aPackage.getQualifiedName());
        }
        dialog.show();
        if (dialog.getExitCode() != 0 || dialog.getSelectedPackage() == null || dialog.getSelectedPackage().getQualifiedName().length() == 0 || parentClassRef.isNull()) {
            return;
        }
        aPackage = dialog.getSelectedPackage();
        PsiClass psiClass = (PsiClass)parentClassRef.get();
        String visitorName = (String)visitorNameRef.get();
        String visitorQName = PsiNameHelper.getShortClassName((String)visitorName).equals(visitorName) ? aPackage.getQualifiedName() + "." + visitorName : visitorName;
        GenerateVisitorByHierarchyAction.generateVisitorClass(visitorQName, aPackage, psiClass);
        IdeView ideView = (IdeView)LangDataKeys.IDE_VIEW.getData(e.getDataContext());
        PsiClass visitorClass = JavaPsiFacade.getInstance((Project)project).findClass(visitorQName, GlobalSearchScope.projectScope((Project)project));
        if (ideView != null && visitorClass != null) {
            ideView.selectElement((PsiElement)visitorClass);
        }
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setEnabled(e.getData(PlatformDataKeys.PROJECT) != null);
    }

    private static void generateVisitorClass(final String visitorName, PsiPackage aPackage, PsiClass baseClass) {
        final THashMap classes = new THashMap();
        for (PsiClass aClass : ClassInheritorsSearch.search((PsiClass)baseClass, (SearchScope)new PackageScope(aPackage, false, false), (boolean)true).findAll()) {
            if (aClass.hasModifierProperty("abstract") != baseClass.hasModifierProperty("abstract")) continue;
            List implementors = ContainerUtil.findAll((Collection)ClassInheritorsSearch.search((PsiClass)aClass).findAll(), (Condition)new Condition<PsiClass>(){

                public boolean value(PsiClass psiClass) {
                    return !psiClass.hasModifierProperty("abstract");
                }
            });
            classes.put((Object)aClass, (Object)new THashSet((Collection)implementors));
        }
        final THashMap pathMap = new THashMap();
        for (PsiClass aClass : classes.keySet()) {
            LinkedHashSet<PsiClass> superClasses = new LinkedHashSet<PsiClass>();
            for (PsiClass superClass : aClass.getSupers()) {
                if (!superClass.isInheritor(baseClass, true)) continue;
                superClasses.add(superClass);
                Set superImplementors = (Set)classes.get((Object)superClass);
                if (superImplementors == null) continue;
                superImplementors.removeAll((Collection)classes.get((Object)aClass));
            }
            if (superClasses.isEmpty()) {
                superClasses.add(baseClass);
            }
            pathMap.put((Object)aClass, superClasses);
        }
        pathMap.put((Object)baseClass, Collections.emptySet());
        ArrayList<PsiFile> psiFiles = new ArrayList<PsiFile>();
        for (Set implementors : classes.values()) {
            for (PsiClass psiClass : implementors) {
                psiFiles.add(psiClass.getContainingFile());
            }
        }
        final Project project = baseClass.getProject();
        final PsiClass visitorClass = JavaPsiFacade.getInstance((Project)project).findClass(visitorName, GlobalSearchScope.projectScope((Project)project));
        if (visitorClass != null) {
            psiFiles.add(visitorClass.getContainingFile());
        }
        new WriteCommandAction(project, psiFiles.toArray(new PsiFile[psiFiles.size()])){

            protected void run(Result result) throws Throwable {
                if (visitorClass == null) {
                    String shortClassName = PsiNameHelper.getShortClassName((String)visitorName);
                    String packageName = visitorName.substring(0, visitorName.length() - shortClassName.length() - 1);
                    PsiDirectory directory = PackageUtil.findOrCreateDirectoryForPackage(project, packageName, null, false);
                    if (directory != null) {
                        PsiClass visitorClass2 = JavaDirectoryService.getInstance().createClass(directory, shortClassName);
                        GenerateVisitorByHierarchyAction.generateVisitorClass(visitorClass2, (Map)classes, (THashMap<PsiClass, Set<PsiClass>>)pathMap);
                    }
                } else {
                    GenerateVisitorByHierarchyAction.generateVisitorClass(visitorClass, (Map)classes, (THashMap<PsiClass, Set<PsiClass>>)pathMap);
                }
            }

            protected boolean isGlobalUndoAction() {
                return true;
            }
        }.execute();
    }

    private static void generateVisitorClass(PsiClass visitorClass, Map<PsiClass, Set<PsiClass>> classes, THashMap<PsiClass, Set<PsiClass>> pathMap) throws Throwable {
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)visitorClass.getProject()).getElementFactory();
        for (PsiClass psiClass : classes.keySet()) {
            PsiMethod method = elementFactory.createMethodFromText("public void accept(final " + visitorClass.getQualifiedName() + " visitor) { visitor.visit" + psiClass.getName() + "(this); }", (PsiElement)psiClass);
            for (PsiClass implementor : classes.get(psiClass)) {
                GenerateVisitorByHierarchyAction.addOrReplaceMethod(method, implementor);
            }
        }
        THashSet visitedClasses = new THashSet();
        LinkedList<PsiClass> toProcess = new LinkedList<PsiClass>(classes.keySet());
        while (!toProcess.isEmpty()) {
            PsiClass psiClass = toProcess.removeFirst();
            if (!visitedClasses.add((Object)psiClass)) continue;
            Set pathClasses = (Set)pathMap.get((Object)psiClass);
            toProcess.addAll(pathClasses);
            StringBuilder methodText = new StringBuilder();
            methodText.append("public void visit").append(psiClass.getName()).append("(final ").append(psiClass.getQualifiedName()).append(" o) {");
            boolean first = true;
            for (PsiClass pathClass : pathClasses) {
                if (first) {
                    first = false;
                } else {
                    methodText.append("// ");
                }
                methodText.append("visit").append(pathClass.getName()).append("(o);\n");
            }
            methodText.append("}");
            PsiMethod method = elementFactory.createMethodFromText(methodText.toString(), (PsiElement)psiClass);
            GenerateVisitorByHierarchyAction.addOrReplaceMethod(method, visitorClass);
        }
    }

    private static void addOrReplaceMethod(PsiMethod method, PsiClass implementor) throws IncorrectOperationException {
        PsiMethod accept = implementor.findMethodBySignature(method, false);
        if (accept != null) {
            accept.replace((PsiElement)method);
        } else {
            GenerateMembersUtil.insertMembersAtOffset(implementor.getContainingFile(), implementor.getLastChild().getTextOffset(), Collections.singletonList(new PsiGenerationInfo<PsiMethod>(method)));
        }
    }
}

