/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.injected.editor;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.impl.HighlighterList;
import com.intellij.openapi.editor.impl.event.MarkupModelListener;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolderBase;
import org.jetbrains.annotations.NotNull;

class MarkupModelWindow
extends UserDataHolderBase
implements MarkupModelEx {
    private final DocumentWindow myDocument;
    private final MarkupModelEx myHostModel;

    public MarkupModelWindow(MarkupModelEx editorMarkupModel, DocumentWindow document) {
        this.myDocument = document;
        this.myHostModel = editorMarkupModel;
    }

    @NotNull
    public Document getDocument() {
        DocumentWindow documentWindow = this.myDocument;
        if (documentWindow == null) {
            throw new IllegalStateException("@NotNull method com/intellij/injected/editor/MarkupModelWindow.getDocument must not return null");
        }
        return documentWindow;
    }

    @NotNull
    public RangeHighlighter addRangeHighlighter(int startOffset, int endOffset, int layer, TextAttributes textAttributes, @NotNull HighlighterTargetArea targetArea) {
        if (targetArea == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of com/intellij/injected/editor/MarkupModelWindow.addRangeHighlighter must not be null");
        }
        TextRange hostRange = this.myDocument.injectedToHost((TextRange)new ProperTextRange(startOffset, endOffset));
        RangeHighlighter rangeHighlighter = this.myHostModel.addRangeHighlighter(hostRange.getStartOffset(), hostRange.getEndOffset(), layer, textAttributes, targetArea);
        if (rangeHighlighter == null) {
            throw new IllegalStateException("@NotNull method com/intellij/injected/editor/MarkupModelWindow.addRangeHighlighter must not return null");
        }
        return rangeHighlighter;
    }

    @NotNull
    public RangeHighlighter addLineHighlighter(int line, int layer, TextAttributes textAttributes) {
        int hostLine = this.myDocument.injectedToHostLine(line);
        RangeHighlighter rangeHighlighter = this.myHostModel.addLineHighlighter(hostLine, layer, textAttributes);
        if (rangeHighlighter == null) {
            throw new IllegalStateException("@NotNull method com/intellij/injected/editor/MarkupModelWindow.addLineHighlighter must not return null");
        }
        return rangeHighlighter;
    }

    public void removeHighlighter(RangeHighlighter rangeHighlighter) {
        this.myHostModel.removeHighlighter(rangeHighlighter);
    }

    public void removeAllHighlighters() {
        this.myHostModel.removeAllHighlighters();
    }

    @NotNull
    public RangeHighlighter[] getAllHighlighters() {
        RangeHighlighter[] rangeHighlighterArray = this.myHostModel.getAllHighlighters();
        if (rangeHighlighterArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/injected/editor/MarkupModelWindow.getAllHighlighters must not return null");
        }
        return rangeHighlighterArray;
    }

    @Override
    public void dispose() {
        this.myHostModel.dispose();
    }

    @Override
    public HighlighterList getHighlighterList() {
        return this.myHostModel.getHighlighterList();
    }

    @Override
    public RangeHighlighter addPersistentLineHighlighter(int line, int layer, TextAttributes textAttributes) {
        int hostLine = this.myDocument.injectedToHostLine(line);
        return this.myHostModel.addPersistentLineHighlighter(hostLine, layer, textAttributes);
    }

    @Override
    public boolean containsHighlighter(RangeHighlighter highlighter) {
        return this.myHostModel.containsHighlighter(highlighter);
    }

    @Override
    public void addMarkupModelListener(MarkupModelListener listener) {
        this.myHostModel.addMarkupModelListener(listener);
    }

    @Override
    public void removeMarkupModelListener(MarkupModelListener listener) {
        this.myHostModel.removeMarkupModelListener(listener);
    }

    @Override
    public void setRangeHighlighterAttributes(RangeHighlighter highlighter, TextAttributes textAttributes) {
        this.myHostModel.setRangeHighlighterAttributes(highlighter, textAttributes);
    }
}

