/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.idea;

import com.intellij.idea.IdeaApplication;
import com.intellij.idea.LoggerFactory;
import com.intellij.idea.Main;
import com.intellij.idea.StartupUtil;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ConfigImportHelper;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.AppUIUtil;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class MainImpl {
    static final String APPLICATION_NAME = "idea";
    private static final String LOG_CATEGORY = "#com.intellij.idea.Main";

    private MainImpl() {
    }

    protected static void start(String[] args) {
        System.setProperty("idea.platform.prefix", "Idea");
        StartupUtil.isHeadless = Main.isHeadless((String[])args);
        boolean isNewConfigFolder = PathManager.ensureConfigFolderExists((boolean)true);
        if (!StartupUtil.isHeadless && isNewConfigFolder) {
            try {
                if (SystemInfo.isWindowsVista || SystemInfo.isWindows7 || SystemInfo.isMac) {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (ApplicationNamesInfo.getInstance().getLowercaseProductName().equals("Idea")) {
                ConfigImportHelper.importConfigsTo(PathManager.getConfigPath());
            }
        }
        if (!StartupUtil.checkStartupPossible()) {
            System.exit(-1);
        }
        Logger.setFactory((Logger.Factory)LoggerFactory.getInstance());
        final Logger LOG = Logger.getInstance((String)LOG_CATEGORY);
        Runtime.getRuntime().addShutdownHook(new Thread("Shutdown hook - logging"){

            @Override
            public void run() {
                LOG.info("------------------------------------------------------ IDEA SHUTDOWN ------------------------------------------------------");
            }
        });
        LOG.info("------------------------------------------------------ IDEA STARTED ------------------------------------------------------");
        MainImpl._main(args);
    }

    protected static void _main(String[] args) {
        System.setProperty("sun.swing.enableImprovedDragGesture", "");
        if (!StartupUtil.isHeadless()) {
            AppUIUtil.updateFrameIcon(JOptionPane.getRootFrame());
        }
        if (SystemInfo.isWindows && !SystemInfo.isWindows9x) {
            Logger LOG = Logger.getInstance((String)LOG_CATEGORY);
            try {
                if (SystemInfo.isAMD64) {
                    System.loadLibrary("focuskiller64");
                } else {
                    System.loadLibrary("focuskiller");
                }
                LOG.info("Using \"FocusKiller\" library to prevent focus stealing.");
            }
            catch (Throwable e) {
                LOG.info("\"FocusKiller\" library not found or there were problems loading it.", e);
            }
        }
        MainImpl.startApplication(args);
    }

    private static void startApplication(String[] args) {
        final IdeaApplication app = new IdeaApplication(args);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                app.run();
            }
        });
    }
}

