/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard;

import com.intellij.CommonBundle;
import com.intellij.conversion.ConversionResult;
import com.intellij.conversion.ConversionService;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.components.impl.stores.StorageUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleWithNameAlreadyExists;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.impl.ProjectMacrosUtil;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import javax.swing.Icon;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;

public class ExistingModuleLoader
extends ModuleBuilder {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.util.projectWizard.ExistingModuleLoader");

    @NotNull
    public Module createModule(ModifiableModuleModel moduleModel) throws InvalidDataException, IOException, ModuleWithNameAlreadyExists, JDOMException, ConfigurationException {
        LOG.assertTrue(this.getName() != null);
        String moduleFilePath = this.getModuleFilePath();
        LOG.assertTrue(moduleFilePath != null);
        LOG.assertTrue(new File(moduleFilePath).exists());
        Module module = moduleModel.loadModule(moduleFilePath);
        if (module == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/util/projectWizard/ExistingModuleLoader.createModule must not return null");
        }
        return module;
    }

    public void setupRootModel(ModifiableRootModel modifiableRootModel) throws ConfigurationException {
    }

    public ModuleType getModuleType() {
        return null;
    }

    public boolean validate(Project current, Project dest) {
        block8: {
            if (this.getName() == null) {
                return false;
            }
            if (this.getModuleFilePath() == null) {
                return false;
            }
            File file = new File(this.getModuleFilePath());
            if (file.exists()) {
                try {
                    boolean ok;
                    ConversionResult result = ConversionService.getInstance().convertModule(dest, file);
                    if (result.openingIsCanceled()) {
                        return false;
                    }
                    Document document = JDOMUtil.loadDocument((File)file);
                    Element root = document.getRootElement();
                    Set<String> usedMacros = StorageUtil.getMacroNames(root);
                    Set definedMacros = PathMacros.getInstance().getAllMacroNames();
                    usedMacros.remove("$MODULE_DIR$");
                    usedMacros.removeAll(definedMacros);
                    if (usedMacros.size() > 0 && !(ok = ProjectMacrosUtil.showMacrosConfigurationDialog(current, usedMacros))) {
                        return false;
                    }
                    break block8;
                }
                catch (JDOMException e) {
                    Messages.showMessageDialog((String)e.getMessage(), (String)IdeBundle.message((String)"title.error.reading.file", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
                    return false;
                }
                catch (IOException e) {
                    Messages.showMessageDialog((String)e.getMessage(), (String)IdeBundle.message((String)"title.error.reading.file", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
                    return false;
                }
            }
            Messages.showErrorDialog((Project)current, (String)IdeBundle.message((String)"title.module.file.does.not.exist", (Object[])new Object[0]), (String)CommonBundle.message((String)"title.error", (Object[])new Object[0]));
            return false;
        }
        return true;
    }
}

