/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.newProjectWizard.modes;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.BrowseFilesListener;
import com.intellij.ide.util.newProjectWizard.StepSequence;
import com.intellij.ide.util.newProjectWizard.modes.WizardMode;
import com.intellij.ide.util.projectWizard.ExistingModuleLoader;
import com.intellij.ide.util.projectWizard.ProjectBuilder;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportImlMode
extends WizardMode {
    private TextFieldWithBrowseButton myModulePathFieldPanel;

    @Override
    @NotNull
    public String getDisplayName(WizardContext context) {
        String string = IdeBundle.message((String)"radio.import.existing.module", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/util/newProjectWizard/modes/ImportImlMode.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String getDescription(WizardContext context) {
        String string = IdeBundle.message((String)"prompt.select.module.file.to.import", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getProductName()});
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/util/newProjectWizard/modes/ImportImlMode.getDescription must not return null");
        }
        return string;
    }

    @Override
    @Nullable
    protected StepSequence createSteps(WizardContext context, ModulesProvider modulesProvider) {
        return null;
    }

    @Override
    public boolean isAvailable(WizardContext context) {
        return context.getProject() != null;
    }

    @Override
    public ProjectBuilder getModuleBuilder() {
        ExistingModuleLoader moduleLoader = new ExistingModuleLoader();
        String moduleFilePath = FileUtil.toSystemIndependentName((String)this.myModulePathFieldPanel.getText().trim());
        moduleLoader.setModuleFilePath(moduleFilePath);
        int startIndex = moduleFilePath.lastIndexOf(47);
        int endIndex = moduleFilePath.lastIndexOf(".");
        if (startIndex >= 0 && endIndex > startIndex + 1) {
            String name = moduleFilePath.substring(startIndex + 1, endIndex);
            moduleLoader.setName(name);
        }
        return moduleLoader;
    }

    @Override
    public void dispose() {
        this.myModulePathFieldPanel = null;
    }

    @Override
    public JComponent getAdditionalSettings() {
        JTextField tfModuleFilePath = new JTextField();
        String productName = ApplicationNamesInfo.getInstance().getProductName();
        this.myModulePathFieldPanel = new TextFieldWithBrowseButton(tfModuleFilePath, (ActionListener)new BrowseFilesListener(tfModuleFilePath, IdeBundle.message((String)"prompt.select.module.file.to.import", (Object[])new Object[]{productName}), null, (FileChooserDescriptor)new ModuleFileChooserDescriptor()));
        this.onChosen(false);
        return this.myModulePathFieldPanel;
    }

    @Override
    public boolean validate() throws ConfigurationException {
        String imlPath = this.myModulePathFieldPanel.getText().trim();
        if (!new File(imlPath).exists()) {
            throw new ConfigurationException("File '" + imlPath + "' doesn't exist");
        }
        if (!FileTypeManager.getInstance().getFileTypeByFileName(imlPath).equals(StdFileTypes.IDEA_MODULE)) {
            throw new ConfigurationException("File '" + imlPath + "' doesn't contain IDEA module");
        }
        return super.validate();
    }

    @Override
    public void onChosen(boolean enabled) {
        UIUtil.setEnabled((Component)this.myModulePathFieldPanel, (boolean)enabled, (boolean)true);
        if (enabled) {
            this.myModulePathFieldPanel.getTextField().requestFocusInWindow();
        }
    }

    private static class ModuleFileChooserDescriptor
    extends FileChooserDescriptor {
        public ModuleFileChooserDescriptor() {
            super(true, false, false, false, false, false);
            this.setHideIgnored(false);
        }

        public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
            boolean isVisible = super.isFileVisible(file, showHiddenFiles);
            if (!isVisible || file.isDirectory()) {
                return isVisible;
            }
            return StdFileTypes.IDEA_MODULE.equals(FileTypeManager.getInstance().getFileTypeByFile(file));
        }
    }
}

