/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.newProjectWizard;

import com.intellij.ide.BrowserUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.BrowseFilesListener;
import com.intellij.ide.util.newProjectWizard.ProjectNameStep;
import com.intellij.ide.util.newProjectWizard.StepSequence;
import com.intellij.ide.util.newProjectWizard.modes.WizardMode;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ProjectWizardUtil;
import com.intellij.ide.util.projectWizard.SourcePathsBuilder;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ProjectNameWithTypeStep
extends ProjectNameStep {
    private JEditorPane myModuleDescriptionPane;
    private JList myTypesList;
    private JCheckBox myCreateModuleCb;
    private JPanel myModulePanel;
    private JPanel myInternalPanel;
    private JTextField myModuleName;
    private TextFieldWithBrowseButton myModuleContentRoot;
    private TextFieldWithBrowseButton myModuleFileLocation;
    private boolean myModuleNameChangedByUser = false;
    private boolean myModuleNameDocListenerEnabled = true;
    private boolean myContentRootChangedByUser = false;
    private boolean myContentRootDocListenerEnabled = true;
    private boolean myImlLocationChangedByUser = false;
    private boolean myImlLocationDocListenerEnabled = true;

    public ProjectNameWithTypeStep(final WizardContext wizardContext, StepSequence sequence, WizardMode mode) {
        super(wizardContext, sequence, mode);
        this.$$$setupUI$$$();
        this.myAdditionalContentPanel.add((Component)this.myModulePanel, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.myCreateModuleCb.setVisible(this.myWizardContext.isCreatingNewProject());
        this.myCreateModuleCb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UIUtil.setEnabled((Component)ProjectNameWithTypeStep.this.myInternalPanel, (boolean)ProjectNameWithTypeStep.this.myCreateModuleCb.isSelected(), (boolean)true);
                ProjectNameWithTypeStep.this.fireStateChanged();
            }
        });
        this.myCreateModuleCb.setSelected(true);
        if (!this.myWizardContext.isCreatingNewProject()) {
            this.myInternalPanel.setBorder(null);
        }
        this.myModuleDescriptionPane.setContentType("text/html");
        this.myModuleDescriptionPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    try {
                        BrowserUtil.launchBrowser((String)e.getURL().toString());
                    }
                    catch (IllegalThreadStateException illegalThreadStateException) {
                        // empty catch block
                    }
                }
            }
        });
        this.myModuleDescriptionPane.setEditable(false);
        DefaultListModel<ModuleBuilder> defaultListModel = new DefaultListModel<ModuleBuilder>();
        for (ModuleBuilder builder : ModuleBuilder.getAllBuilders()) {
            defaultListModel.addElement(builder);
        }
        this.myTypesList.setModel(defaultListModel);
        this.myTypesList.setSelectionModel(new PermanentSingleSelectionModel());
        this.myTypesList.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component rendererComponent = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                ModuleBuilder builder = (ModuleBuilder)value;
                this.setIcon(builder.getBigIcon());
                this.setDisabledIcon(builder.getBigIcon());
                this.setText(builder.getPresentableName());
                return rendererComponent;
            }
        });
        this.myTypesList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ModuleBuilder typeSelected = (ModuleBuilder)ProjectNameWithTypeStep.this.myTypesList.getSelectedValue();
                StringBuilder sb = new StringBuilder("<html><body><font face=\"Verdana\" ");
                sb.append(SystemInfo.isMac ? "" : "size=\"-1\"").append('>');
                sb.append(typeSelected.getDescription()).append("</font></body></html>");
                ProjectNameWithTypeStep.this.myModuleDescriptionPane.setText(sb.toString());
                ProjectNameWithTypeStep.this.fireStateChanged();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ProjectNameWithTypeStep.this.myTypesList.requestFocusInWindow();
                    }
                });
            }
        });
        this.myTypesList.setSelectedIndex(0);
        this.myTypesList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && e.getButton() == 1) {
                    ProjectNameWithTypeStep.this.myWizardContext.requestNextStep();
                }
            }
        });
        this.myNamePathComponent.getNameComponent().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                if (!ProjectNameWithTypeStep.this.myModuleNameChangedByUser) {
                    ProjectNameWithTypeStep.this.setModuleName(ProjectNameWithTypeStep.this.myNamePathComponent.getNameValue());
                }
            }
        });
        this.myModuleContentRoot.addBrowseFolderListener(ProjectBundle.message((String)"project.new.wizard.module.content.root.chooser.title", (Object[])new Object[0]), ProjectBundle.message((String)"project.new.wizard.module.content.root.chooser.description", (Object[])new Object[0]), this.myWizardContext.getProject(), BrowseFilesListener.SINGLE_DIRECTORY_DESCRIPTOR);
        this.myNamePathComponent.getPathComponent().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                if (!ProjectNameWithTypeStep.this.myContentRootChangedByUser) {
                    ProjectNameWithTypeStep.this.setModuleContentRoot(ProjectNameWithTypeStep.this.myNamePathComponent.getPath());
                }
            }
        });
        this.myModuleName.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                String path;
                if (ProjectNameWithTypeStep.this.myModuleNameDocListenerEnabled) {
                    ProjectNameWithTypeStep.this.myModuleNameChangedByUser = true;
                }
                if ((path = ProjectNameWithTypeStep.this.getDefaultBaseDir(wizardContext)).length() > 0 && !Comparing.strEqual((String)ProjectNameWithTypeStep.this.myModuleName.getText().trim(), (String)ProjectNameWithTypeStep.this.myNamePathComponent.getNameValue())) {
                    path = path + "/" + ProjectNameWithTypeStep.this.myModuleName.getText();
                }
                if (!ProjectNameWithTypeStep.this.myContentRootChangedByUser) {
                    boolean f = ProjectNameWithTypeStep.this.myModuleNameChangedByUser;
                    ProjectNameWithTypeStep.this.myModuleNameChangedByUser = true;
                    ProjectNameWithTypeStep.this.setModuleContentRoot(path);
                    ProjectNameWithTypeStep.this.myModuleNameChangedByUser = f;
                }
                if (!ProjectNameWithTypeStep.this.myImlLocationChangedByUser) {
                    ProjectNameWithTypeStep.this.setImlFileLocation(path);
                }
            }
        });
        this.myModuleContentRoot.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                if (ProjectNameWithTypeStep.this.myContentRootDocListenerEnabled) {
                    ProjectNameWithTypeStep.this.myContentRootChangedByUser = true;
                }
                if (!ProjectNameWithTypeStep.this.myImlLocationChangedByUser) {
                    ProjectNameWithTypeStep.this.setImlFileLocation(ProjectNameWithTypeStep.this.myModuleContentRoot.getText());
                }
                if (!ProjectNameWithTypeStep.this.myModuleNameChangedByUser) {
                    String path = FileUtil.toSystemIndependentName((String)ProjectNameWithTypeStep.this.myModuleContentRoot.getText());
                    int idx = path.lastIndexOf("/");
                    boolean f = ProjectNameWithTypeStep.this.myContentRootChangedByUser;
                    ProjectNameWithTypeStep.this.myContentRootChangedByUser = true;
                    boolean i = ProjectNameWithTypeStep.this.myImlLocationChangedByUser;
                    ProjectNameWithTypeStep.this.myImlLocationChangedByUser = true;
                    ProjectNameWithTypeStep.this.setModuleName(idx >= 0 ? path.substring(idx + 1) : "");
                    ProjectNameWithTypeStep.this.myContentRootChangedByUser = f;
                    ProjectNameWithTypeStep.this.myImlLocationChangedByUser = i;
                }
            }
        });
        this.myModuleFileLocation.addBrowseFolderListener(ProjectBundle.message((String)"project.new.wizard.module.file.chooser.title", (Object[])new Object[0]), ProjectBundle.message((String)"project.new.wizard.module.file.description", (Object[])new Object[0]), this.myWizardContext.getProject(), BrowseFilesListener.SINGLE_DIRECTORY_DESCRIPTOR);
        this.myModuleFileLocation.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                if (ProjectNameWithTypeStep.this.myImlLocationDocListenerEnabled) {
                    ProjectNameWithTypeStep.this.myImlLocationChangedByUser = true;
                }
            }
        });
        this.myNamePathComponent.getPathComponent().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                if (!ProjectNameWithTypeStep.this.myImlLocationChangedByUser) {
                    ProjectNameWithTypeStep.this.setImlFileLocation(ProjectNameWithTypeStep.this.myNamePathComponent.getPath());
                }
            }
        });
        if (wizardContext.isCreatingNewProject()) {
            this.setModuleName(this.myNamePathComponent.getNameValue());
            this.setModuleContentRoot(this.myNamePathComponent.getPath());
            this.setImlFileLocation(this.myNamePathComponent.getPath());
        } else {
            Project project = wizardContext.getProject();
            assert (project != null);
            VirtualFile baseDir = project.getBaseDir();
            if (baseDir != null) {
                String moduleName = ProjectWizardUtil.findNonExistingFileName(baseDir.getPath(), "untitled", "");
                this.setModuleName(moduleName);
                this.setModuleContentRoot(baseDir.getPath() + "/" + moduleName);
                this.setImlFileLocation(baseDir.getPath() + "/" + moduleName);
                this.myModuleName.setSelectionStart(0);
                this.myModuleName.setSelectionEnd(moduleName.length());
            }
        }
    }

    private String getDefaultBaseDir(WizardContext wizardContext) {
        if (wizardContext.isCreatingNewProject()) {
            return this.myNamePathComponent.getPath();
        }
        Project project = wizardContext.getProject();
        assert (project != null);
        VirtualFile baseDir = project.getBaseDir();
        if (baseDir != null) {
            return baseDir.getPath();
        }
        return "";
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return this.myWizardContext.isCreatingNewProject() ? super.getPreferredFocusedComponent() : this.myModuleName;
    }

    private void setImlFileLocation(String path) {
        this.myImlLocationDocListenerEnabled = false;
        this.myModuleFileLocation.setText(FileUtil.toSystemDependentName((String)path));
        this.myImlLocationDocListenerEnabled = true;
    }

    private void setModuleContentRoot(String path) {
        this.myContentRootDocListenerEnabled = false;
        this.myModuleContentRoot.setText(FileUtil.toSystemDependentName((String)path));
        this.myContentRootDocListenerEnabled = true;
    }

    private void setModuleName(String moduleName) {
        this.myModuleNameDocListenerEnabled = false;
        this.myModuleName.setText(moduleName);
        this.myModuleNameDocListenerEnabled = true;
    }

    public void updateStep() {
        super.updateStep();
        if (this.myCreateModuleCb.isSelected()) {
            this.mySequence.setType(this.getSelectedBuilderId());
        } else {
            this.mySequence.setType(null);
        }
    }

    @Override
    public void updateDataModel() {
        if (this.myCreateModuleCb.isSelected()) {
            this.mySequence.setType(this.getSelectedBuilderId());
            super.updateDataModel();
            ModuleBuilder builder = (ModuleBuilder)this.myMode.getModuleBuilder();
            assert (builder != null);
            builder.setName(this.myModuleName.getText());
            builder.setModuleFilePath(FileUtil.toSystemIndependentName((String)this.myModuleFileLocation.getText()) + "/" + this.myModuleName.getText() + ".iml");
            ((SourcePathsBuilder)builder).setContentEntryPath(FileUtil.toSystemIndependentName((String)this.myModuleContentRoot.getText()));
        } else {
            this.mySequence.setType(null);
            super.updateDataModel();
        }
    }

    private String getSelectedBuilderId() {
        return ((ModuleBuilder)this.myTypesList.getSelectedValue()).getBuilderId();
    }

    @Override
    public boolean validate() throws ConfigurationException {
        ProjectStructureConfigurable fromConfigurable;
        Module module;
        String moduleName = this.myModuleName.getText().trim();
        if (this.myCreateModuleCb.isSelected() || !this.myWizardContext.isCreatingNewProject()) {
            int answer;
            String moduleFileDirectory = this.myModuleFileLocation.getText();
            if (moduleFileDirectory.length() == 0) {
                throw new ConfigurationException("Enter module file location");
            }
            if (moduleName.length() == 0) {
                throw new ConfigurationException("Enter a module name");
            }
            if (!ProjectWizardUtil.createDirectoryIfNotExists(IdeBundle.message((String)"directory.module.file", (Object[])new Object[0]), moduleFileDirectory, this.myImlLocationChangedByUser)) {
                return false;
            }
            if (!ProjectWizardUtil.createDirectoryIfNotExists(IdeBundle.message((String)"directory.module.content.root", (Object[])new Object[0]), this.myModuleContentRoot.getText(), this.myContentRootChangedByUser)) {
                return false;
            }
            File moduleFile = new File(moduleFileDirectory, moduleName + ".iml");
            if (moduleFile.exists() && (answer = Messages.showYesNoDialog((String)IdeBundle.message((String)"prompt.overwrite.project.file", (Object[])new Object[]{moduleFile.getAbsolutePath(), IdeBundle.message((String)"project.new.wizard.module.identification", (Object[])new Object[0])}), (String)IdeBundle.message((String)"title.file.already.exists", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon())) != 0) {
                return false;
            }
        }
        if (!this.myWizardContext.isCreatingNewProject() && (module = (fromConfigurable = ProjectStructureConfigurable.getInstance(this.myWizardContext.getProject())) != null ? fromConfigurable.getModulesConfig().getModule(moduleName) : ModuleManager.getInstance((Project)this.myWizardContext.getProject()).findModuleByName(moduleName)) != null) {
            throw new ConfigurationException("Module '" + moduleName + "' already exist in project. Please, specify another name.");
        }
        return !this.myWizardContext.isCreatingNewProject() || super.validate();
    }

    public void disposeUIResources() {
        super.disposeUIResources();
    }

    @Override
    public String getHelpId() {
        return "reference.dialogs.new.project.fromScratch";
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JEditorPane jEditorPane;
        JList jList;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JTextField jTextField;
        JPanel jPanel;
        JPanel jPanel2;
        this.myModulePanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        this.myInternalPanel = jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setPreferredSize(new Dimension(250, 150));
        jPanel.setMaximumSize(new Dimension(250, 150));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 0);
        jPanel2.add((Component)jPanel, gridBagConstraints);
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Module Settings", 0, 0, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/ProjectBundle").getString("project.new.wizard.module.name.title"));
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.insets = new Insets(0, 4, 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints2);
        this.myModuleName = jTextField = new JTextField();
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 1;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.insets = new Insets(2, 0, 0, 0);
        jPanel.add((Component)jTextField, gridBagConstraints3);
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/ProjectBundle").getString("project.new.wizard.module.root.title"));
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.gridy = 1;
        gridBagConstraints4.anchor = 17;
        gridBagConstraints4.insets = new Insets(0, 4, 0, 0);
        jPanel.add((Component)jLabel2, gridBagConstraints4);
        this.myModuleContentRoot = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridx = 1;
        gridBagConstraints5.gridy = 1;
        gridBagConstraints5.weightx = 1.0;
        gridBagConstraints5.fill = 2;
        gridBagConstraints5.insets = new Insets(2, 0, 0, 0);
        jPanel.add((Component)textFieldWithBrowseButton2, gridBagConstraints5);
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("messages/ProjectBundle").getString("project.new.wizard.module.file.title"));
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.gridx = 0;
        gridBagConstraints6.gridy = 2;
        gridBagConstraints6.anchor = 17;
        gridBagConstraints6.insets = new Insets(0, 4, 0, 0);
        jPanel.add((Component)jLabel3, gridBagConstraints6);
        this.myModuleFileLocation = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton.setPreferredSize(new Dimension(280, 20));
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.gridx = 1;
        gridBagConstraints7.gridy = 2;
        gridBagConstraints7.weightx = 1.0;
        gridBagConstraints7.fill = 2;
        gridBagConstraints7.insets = new Insets(2, 0, 0, 0);
        jPanel.add((Component)textFieldWithBrowseButton, gridBagConstraints7);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setPreferredSize(new Dimension(125, 128));
        jScrollPane.setHorizontalScrollBarPolicy(31);
        GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
        gridBagConstraints8.gridx = 0;
        gridBagConstraints8.gridy = 4;
        gridBagConstraints8.weightx = 0.1;
        gridBagConstraints8.weighty = 1.0;
        gridBagConstraints8.fill = 1;
        gridBagConstraints8.insets = new Insets(0, 4, 0, 0);
        jPanel.add((Component)jScrollPane, gridBagConstraints8);
        this.myTypesList = jList = new JList();
        jScrollPane.setViewportView(jList);
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("messages/ProjectBundle").getString("project.new.wizard.select.type.label"));
        GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
        gridBagConstraints9.gridx = 0;
        gridBagConstraints9.gridy = 3;
        gridBagConstraints9.anchor = 17;
        gridBagConstraints9.insets = new Insets(20, 4, 0, 0);
        jPanel.add((Component)jLabel4, gridBagConstraints9);
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("messages/ProjectBundle").getString("project.new.wizard.description.title"));
        GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
        gridBagConstraints10.gridx = 1;
        gridBagConstraints10.gridy = 3;
        gridBagConstraints10.anchor = 17;
        gridBagConstraints10.insets = new Insets(20, 3, 0, 0);
        jPanel.add((Component)jLabel5, gridBagConstraints10);
        JScrollPane jScrollPane2 = new JScrollPane();
        jScrollPane2.setPreferredSize(new Dimension(28, 20));
        jScrollPane2.setHorizontalScrollBarPolicy(30);
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.gridx = 1;
        gridBagConstraints11.gridy = 4;
        gridBagConstraints11.weightx = 0.8;
        gridBagConstraints11.fill = 1;
        gridBagConstraints11.insets = new Insets(0, 3, 0, 0);
        jPanel.add((Component)jScrollPane2, gridBagConstraints11);
        this.myModuleDescriptionPane = jEditorPane = new JEditorPane();
        jEditorPane.setText("");
        jScrollPane2.setViewportView(jEditorPane);
        this.myCreateModuleCb = jCheckBox = new JCheckBox();
        jCheckBox.setText("Create module");
        jCheckBox.setMnemonic('C');
        jCheckBox.setDisplayedMnemonicIndex(0);
        GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
        gridBagConstraints12.gridx = 0;
        gridBagConstraints12.gridy = 0;
        gridBagConstraints12.anchor = 17;
        gridBagConstraints12.insets = new Insets(10, 0, 0, 0);
        jPanel2.add((Component)jCheckBox, gridBagConstraints12);
        jLabel.setLabelFor(jTextField);
        jLabel2.setLabelFor((Component)textFieldWithBrowseButton2);
        jLabel3.setLabelFor((Component)textFieldWithBrowseButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myModulePanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static class PermanentSingleSelectionModel
    extends DefaultListSelectionModel {
        public PermanentSingleSelectionModel() {
            super.setSelectionMode(0);
        }

        @Override
        public final void setSelectionMode(int selectionMode) {
        }

        @Override
        public final void removeSelectionInterval(int index0, int index1) {
        }
    }
}

