/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import com.intellij.navigation.ChooseByNameContributor;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;

public class ProjectBaseDirNavigationContributor
implements ChooseByNameContributor,
DumbAware {
    public String[] getNames(Project project, boolean includeNonProjectItems) {
        VirtualFile baseDir = project.getBaseDir();
        if (baseDir == null) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        VirtualFile[] files = baseDir.getChildren();
        ArrayList<String> list = new ArrayList<String>();
        for (VirtualFile file : files) {
            if (file.isDirectory()) continue;
            list.add(file.getName());
        }
        return ArrayUtil.toStringArray(list);
    }

    public NavigationItem[] getItemsByName(String name, String pattern, Project project, boolean includeNonProjectItems) {
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        VirtualFile baseDir = project.getBaseDir();
        if (baseDir == null) {
            return NavigationItem.EMPTY_NAVIGATION_ITEM_ARRAY;
        }
        VirtualFile[] files = baseDir.getChildren();
        ArrayList<PsiFile> list = new ArrayList<PsiFile>();
        for (VirtualFile file : files) {
            PsiFile psiFile;
            if (!ProjectBaseDirNavigationContributor.isEditable(file, includeNonProjectItems) || !Comparing.strEqual((String)name, (String)file.getName()) || (psiFile = psiManager.findFile(file)) == null) continue;
            list.add(psiFile);
        }
        return (NavigationItem[])list.toArray(new PsiFile[list.size()]);
    }

    private static boolean isEditable(VirtualFile file, boolean checkboxState) {
        FileType type = file.getFileType();
        if (!checkboxState && type == StdFileTypes.JAVA) {
            return false;
        }
        return type != StdFileTypes.CLASS;
    }
}

