/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import com.intellij.ide.util.DefaultPsiElementCellRenderer;
import com.intellij.navigation.ChooseByNameContributor;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;

public class DefaultSymbolNavigationContributor
implements ChooseByNameContributor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.util.gotoByName.DefaultSymbolNavigationContributor");

    public String[] getNames(Project project, boolean includeNonProjectItems) {
        PsiShortNamesCache cache = JavaPsiFacade.getInstance((Project)project).getShortNamesCache();
        HashSet set = new HashSet();
        cache.getAllMethodNames(set);
        cache.getAllFieldNames(set);
        cache.getAllClassNames(set);
        return ArrayUtil.toStringArray((Collection)set);
    }

    public NavigationItem[] getItemsByName(String name, String pattern, Project project, boolean includeNonProjectItems) {
        GlobalSearchScope scope = includeNonProjectItems ? GlobalSearchScope.allScope((Project)project) : GlobalSearchScope.projectScope((Project)project);
        PsiShortNamesCache cache = JavaPsiFacade.getInstance((Project)project).getShortNamesCache();
        PsiMethod[] methods = cache.getMethodsByName(name, scope);
        methods = DefaultSymbolNavigationContributor.filterInheritedMethods(methods);
        PsiField[] fields = cache.getFieldsByName(name, scope);
        PsiClass[] classes = cache.getClassesByName(name, scope);
        ArrayList<PsiMember> result = new ArrayList<PsiMember>();
        result.addAll(Arrays.asList(methods));
        result.addAll(Arrays.asList(fields));
        result.addAll(Arrays.asList(classes));
        DefaultSymbolNavigationContributor.filterOutNonOpenable(result);
        PsiMember[] array = result.toArray(new PsiMember[result.size()]);
        Arrays.sort(array, MyComparator.INSTANCE);
        return array;
    }

    private static void filterOutNonOpenable(List<PsiMember> members) {
        ListIterator<PsiMember> it = members.listIterator();
        while (it.hasNext()) {
            PsiMember member = it.next();
            if (!DefaultSymbolNavigationContributor.isNonOpenable(member)) continue;
            it.remove();
        }
    }

    private static boolean isNonOpenable(PsiMember member) {
        return member.getContainingFile().getVirtualFile() == null;
    }

    private static PsiMethod[] filterInheritedMethods(PsiMethod[] methods) {
        ArrayList<PsiMethod> list = new ArrayList<PsiMethod>(methods.length);
        for (PsiMethod method : methods) {
            PsiMethod[] supers;
            ProgressManager.checkCanceled();
            if (method.isConstructor() || (supers = method.findSuperMethods()).length > 0) continue;
            list.add(method);
        }
        return list.toArray(new PsiMethod[list.size()]);
    }

    private static class MyComparator
    implements Comparator<PsiModifierListOwner> {
        public static final MyComparator INSTANCE = new MyComparator();
        private final DefaultPsiElementCellRenderer myRenderer = new DefaultPsiElementCellRenderer();

        private MyComparator() {
        }

        @Override
        public int compare(PsiModifierListOwner element1, PsiModifierListOwner element2) {
            String text2;
            String text1;
            int kind2;
            int level2;
            if (element1 == element2) {
                return 0;
            }
            PsiModifierList modifierList1 = element1.getModifierList();
            PsiModifierList modifierList2 = element2.getModifierList();
            int level1 = modifierList1 == null ? 4 : PsiUtil.getAccessLevel((PsiModifierList)modifierList1);
            int n = level2 = modifierList2 == null ? 4 : PsiUtil.getAccessLevel((PsiModifierList)modifierList2);
            if (level1 != level2) {
                return level2 - level1;
            }
            int kind1 = MyComparator.getElementTypeLevel((PsiElement)element1);
            if (kind1 != (kind2 = MyComparator.getElementTypeLevel((PsiElement)element2))) {
                return kind1 - kind2;
            }
            if (element1 instanceof PsiMethod) {
                LOG.assertTrue(element2 instanceof PsiMethod);
                PsiParameter[] parms1 = ((PsiMethod)element1).getParameterList().getParameters();
                PsiParameter[] parms2 = ((PsiMethod)element2).getParameterList().getParameters();
                if (parms1.length != parms2.length) {
                    return parms1.length - parms2.length;
                }
            }
            if (!(text1 = this.myRenderer.getElementText((PsiElement)element1)).equals(text2 = this.myRenderer.getElementText((PsiElement)element2))) {
                return text1.compareTo(text2);
            }
            String containerText1 = this.myRenderer.getContainerText((PsiElement)element1, text1);
            String containerText2 = this.myRenderer.getContainerText((PsiElement)element2, text2);
            if (containerText1 == null) {
                containerText1 = "";
            }
            if (containerText2 == null) {
                containerText2 = "";
            }
            return containerText1.compareTo(containerText2);
        }

        private static int getElementTypeLevel(PsiElement element) {
            if (element instanceof PsiMethod) {
                return 1;
            }
            if (element instanceof PsiField) {
                return 2;
            }
            if (element instanceof PsiClass) {
                return 3;
            }
            LOG.error((Object)element);
            return 0;
        }
    }
}

