/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.util.SuperMethodWarningDialog;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.searches.DeepestSuperMethodsSearch;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.ArrayUtil;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class SuperMethodWarningUtil {
    private SuperMethodWarningUtil() {
    }

    @NotNull
    public static PsiMethod[] checkSuperMethods(PsiMethod method, String actionString) {
        PsiMethod[] psiMethodArray = SuperMethodWarningUtil.checkSuperMethods(method, actionString, null);
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/util/SuperMethodWarningUtil.checkSuperMethods must not return null");
        }
        return psiMethodArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static PsiMethod[] checkSuperMethods(PsiMethod method, String actionString, Collection<PsiElement> ignore) {
        PsiMethod[] psiMethodArray;
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            psiMethodArray = new PsiMethod[]{method};
            if (psiMethodArray == null) throw new IllegalStateException("@NotNull method com/intellij/ide/util/SuperMethodWarningUtil.checkSuperMethods must not return null");
            return psiMethodArray;
        }
        Collection superMethods = DeepestSuperMethodsSearch.search((PsiMethod)method).findAll();
        if (ignore != null) {
            superMethods.removeAll(ignore);
        }
        if (superMethods.isEmpty()) {
            psiMethodArray = new PsiMethod[]{method};
            if (psiMethodArray == null) throw new IllegalStateException("@NotNull method com/intellij/ide/util/SuperMethodWarningUtil.checkSuperMethods must not return null");
            return psiMethodArray;
        }
        HashSet<String> superClasses = new HashSet<String>();
        boolean superAbstract = false;
        boolean parentInterface = false;
        for (PsiMethod superMethod : superMethods) {
            PsiClass containingClass = superMethod.getContainingClass();
            superClasses.add(containingClass.getQualifiedName());
            boolean isInterface = containingClass.isInterface();
            superAbstract |= isInterface || superMethod.hasModifierProperty("abstract");
            parentInterface |= isInterface;
        }
        SuperMethodWarningDialog dialog = new SuperMethodWarningDialog(method.getProject(), UsageViewUtil.getDescriptiveName((PsiElement)method), actionString, superAbstract, parentInterface, aClass.isInterface(), ArrayUtil.toStringArray(superClasses));
        dialog.show();
        if (dialog.getExitCode() == 0) {
            psiMethodArray = superMethods.toArray(new PsiMethod[superMethods.size()]);
            if (psiMethodArray == null) throw new IllegalStateException("@NotNull method com/intellij/ide/util/SuperMethodWarningUtil.checkSuperMethods must not return null");
            return psiMethodArray;
        }
        if (dialog.getExitCode() == 3) {
            psiMethodArray = new PsiMethod[]{method};
            if (psiMethodArray == null) throw new IllegalStateException("@NotNull method com/intellij/ide/util/SuperMethodWarningUtil.checkSuperMethods must not return null");
            return psiMethodArray;
        }
        psiMethodArray = PsiMethod.EMPTY_ARRAY;
        if (PsiMethod.EMPTY_ARRAY != null) return psiMethodArray;
        throw new IllegalStateException("@NotNull method com/intellij/ide/util/SuperMethodWarningUtil.checkSuperMethods must not return null");
    }

    public static PsiMethod checkSuperMethod(PsiMethod method, String actionString) {
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return method;
        }
        PsiMethod superMethod = method.findDeepestSuperMethod();
        if (superMethod == null) {
            return method;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return superMethod;
        }
        PsiClass containingClass = superMethod.getContainingClass();
        SuperMethodWarningDialog dialog = new SuperMethodWarningDialog(method.getProject(), UsageViewUtil.getDescriptiveName((PsiElement)method), actionString, containingClass.isInterface() || superMethod.hasModifierProperty("abstract"), containingClass.isInterface(), aClass.isInterface(), containingClass.getQualifiedName());
        dialog.show();
        if (dialog.getExitCode() == 0) {
            return superMethod;
        }
        if (dialog.getExitCode() == 3) {
            return method;
        }
        return null;
    }
}

