/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.lexer.JavaLexer;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaTokenType;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class JavaUtilForVfs {
    private JavaUtilForVfs() {
    }

    public static List<VirtualFile> suggestRoots(VirtualFile dir) {
        ArrayList<VirtualFile> foundDirectories = new ArrayList<VirtualFile>();
        try {
            JavaUtilForVfs.suggestRootsImpl(dir, foundDirectories);
        }
        catch (PathFoundException pathFoundException) {
            // empty catch block
        }
        return foundDirectories;
    }

    private static void suggestRootsImpl(VirtualFile dir, ArrayList<? super VirtualFile> foundDirectories) throws PathFoundException {
        VirtualFile[] list;
        String dirName;
        if (!dir.isDirectory()) {
            return;
        }
        FileTypeManager typeManager = FileTypeManager.getInstance();
        if (typeManager.isFileIgnored(dirName = dir.getName()) || StringUtil.startsWithIgnoreCase((String)dirName, (String)"testdata")) {
            return;
        }
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        if (progressIndicator != null) {
            if (progressIndicator.isCanceled()) {
                return;
            }
            progressIndicator.setText2(dir.getPath());
        }
        if ((list = dir.getChildren()) == null || list.length == 0) {
            return;
        }
        for (VirtualFile child : list) {
            FileType type;
            if (child.isDirectory() || StdFileTypes.JAVA != (type = typeManager.getFileTypeByFileName(child.getName()))) continue;
            if (progressIndicator != null && progressIndicator.isCanceled()) {
                return;
            }
            VirtualFile root = JavaUtilForVfs.suggestRootForJavaFile(child);
            if (root != null) {
                foundDirectories.add((VirtualFile)root);
                throw new PathFoundException(root);
            }
            return;
        }
        for (VirtualFile child : list) {
            if (!child.isDirectory()) continue;
            try {
                JavaUtilForVfs.suggestRootsImpl(child, foundDirectories);
            }
            catch (PathFoundException found) {
                if (found.myDirectory.equals(child)) continue;
                throw found;
            }
        }
    }

    @Nullable
    private static VirtualFile suggestRootForJavaFile(VirtualFile javaFile) {
        if (javaFile.isDirectory()) {
            return null;
        }
        CharSequence chars = LoadTextUtil.loadText(javaFile);
        String packageName = JavaUtilForVfs.getPackageStatement(chars);
        if (packageName != null) {
            VirtualFile root = javaFile.getParent();
            int index = packageName.length();
            while (index > 0) {
                boolean equalsToToken;
                int index1 = packageName.lastIndexOf(46, index - 1);
                String token = packageName.substring(index1 + 1, index);
                String dirName = root.getName();
                boolean bl = equalsToToken = SystemInfo.isFileSystemCaseSensitive ? dirName.equals(token) : dirName.equalsIgnoreCase(token);
                if (!equalsToToken) {
                    return null;
                }
                if ((root = root.getParent()) == null) {
                    return null;
                }
                index = index1;
            }
            return root;
        }
        return null;
    }

    private static String getPackageStatement(CharSequence text) {
        JavaLexer lexer = new JavaLexer(LanguageLevel.JDK_1_3);
        lexer.start(text);
        JavaUtilForVfs.skipWhiteSpaceAndComments((Lexer)lexer);
        if (lexer.getTokenType() != JavaTokenType.PACKAGE_KEYWORD) {
            return null;
        }
        lexer.advance();
        JavaUtilForVfs.skipWhiteSpaceAndComments((Lexer)lexer);
        StringBuffer buffer = new StringBuffer();
        while (lexer.getTokenType() == JavaTokenType.IDENTIFIER) {
            buffer.append(text, lexer.getTokenStart(), lexer.getTokenEnd());
            lexer.advance();
            JavaUtilForVfs.skipWhiteSpaceAndComments((Lexer)lexer);
            if (lexer.getTokenType() != JavaTokenType.DOT) break;
            buffer.append('.');
            lexer.advance();
            JavaUtilForVfs.skipWhiteSpaceAndComments((Lexer)lexer);
        }
        String packageName = buffer.toString();
        if (packageName.length() == 0 || StringUtil.endsWithChar((CharSequence)packageName, (char)'.')) {
            return null;
        }
        return packageName;
    }

    private static void skipWhiteSpaceAndComments(Lexer lexer) {
        while (JavaTokenType.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(lexer.getTokenType())) {
            lexer.advance();
        }
    }

    private static class PathFoundException
    extends Exception {
        public VirtualFile myDirectory;

        public PathFoundException(VirtualFile directory) {
            this.myDirectory = directory;
        }
    }
}

