/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.CommonBundle;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.ide.DataManager;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.DeleteDialog;
import com.intellij.ide.util.DeleteUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ex.MessagesEx;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.safeDelete.SafeDeleteProcessor;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.io.ReadOnlyAttributeUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class DeleteHandler {
    private DeleteHandler() {
    }

    public static void deletePsiElement(PsiElement[] elementsToDelete, final Project project) {
        if (elementsToDelete == null || elementsToDelete.length == 0) {
            return;
        }
        final PsiElement[] elements = PsiTreeUtil.filterAncestors((PsiElement[])elementsToDelete);
        boolean safeDeleteApplicable = true;
        for (int i = 0; i < elements.length && safeDeleteApplicable; ++i) {
            PsiElement element = elements[i];
            safeDeleteApplicable = SafeDeleteProcessor.validElement(element);
        }
        boolean dumb = DumbService.getInstance((Project)project).isDumb();
        if (safeDeleteApplicable && !dumb) {
            DeleteDialog dialog = new DeleteDialog(project, elements, new DeleteDialog.Callback(){

                @Override
                public void run(final DeleteDialog dialog) {
                    if (!CommonRefactoringUtil.checkReadOnlyStatusRecursively((Project)project, Arrays.asList(elements))) {
                        return;
                    }
                    SafeDeleteProcessor.createInstance(project, new Runnable(){

                        @Override
                        public void run() {
                            dialog.close(1);
                        }
                    }, elements, dialog.isSearchInComments(), dialog.isSearchInNonJava(), true).run();
                }
            });
            dialog.show();
            if (!dialog.isOK()) {
                return;
            }
        } else {
            int result;
            String warningMessage = DeleteUtil.generateWarningMessage(IdeBundle.message((String)"prompt.delete.elements", (Object[])new Object[0]), elements);
            boolean anyDirectories = false;
            String directoryName = null;
            for (PsiElement psiElement : elementsToDelete) {
                if (!(psiElement instanceof PsiDirectory)) continue;
                anyDirectories = true;
                directoryName = ((PsiDirectory)psiElement).getName();
                break;
            }
            if (anyDirectories) {
                warningMessage = elements.length == 1 ? warningMessage + IdeBundle.message((String)"warning.delete.all.files.and.subdirectories", (Object[])new Object[]{directoryName}) : warningMessage + IdeBundle.message((String)"warning.delete.all.files.and.subdirectories.in.the.selected.directory", (Object[])new Object[0]);
            }
            if (safeDeleteApplicable && dumb) {
                warningMessage = warningMessage + "\n\nWarning:\n  Safe delete is not available while IntelliJ IDEA updates indices,\n  no usages will be checked.";
            }
            if ((result = Messages.showDialog((Project)project, (String)warningMessage, (String)IdeBundle.message((String)"title.delete", (Object[])new Object[0]), (String[])new String[]{CommonBundle.getOkButtonText(), CommonBundle.getCancelButtonText()}, (int)0, (Icon)Messages.getQuestionIcon())) != 0) {
                return;
            }
        }
        final FileTypeManager ftManager = FileTypeManager.getInstance();
        CommandProcessor.getInstance().executeCommand(project, new Runnable(){

            @Override
            public void run() {
                CommonRefactoringUtil.checkReadOnlyStatusRecursively((Project)project, Arrays.asList(elements), (boolean)false);
                if (PlatformDataKeys.EDITOR.getData(DataManager.getInstance().getDataContext()) == null) {
                    CommandProcessor.getInstance().markCurrentCommandAsGlobal(project);
                }
                for (final PsiElement elementToDelete : elements) {
                    VirtualFile virtualFile;
                    PsiFile file;
                    boolean success;
                    int _result;
                    if (!elementToDelete.isValid()) continue;
                    if (elementToDelete instanceof PsiDirectory) {
                        VirtualFile virtualFile2 = ((PsiDirectory)elementToDelete).getVirtualFile();
                        if (virtualFile2.isInLocalFileSystem()) {
                            ArrayList readOnlyFiles = new ArrayList();
                            DeleteHandler.getReadOnlyVirtualFiles(virtualFile2, readOnlyFiles, ftManager);
                            if (readOnlyFiles.size() > 0) {
                                VirtualFile file2;
                                _result = Messages.showYesNoDialog((Project)project, (String)IdeBundle.message((String)"prompt.directory.contains.read.only.files", (Object[])new Object[]{virtualFile2.getPresentableUrl()}), (String)IdeBundle.message((String)"title.delete", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
                                if (_result != 0) continue;
                                success = true;
                                Iterator i$ = readOnlyFiles.iterator();
                                while (i$.hasNext() && (success = DeleteHandler.clearReadOnlyFlag(file2 = (VirtualFile)i$.next(), project))) {
                                }
                                if (!success) {
                                    continue;
                                }
                            }
                        }
                    } else if (!elementToDelete.isWritable() && (file = elementToDelete.getContainingFile()) != null && (virtualFile = file.getVirtualFile()).isInLocalFileSystem() && ((_result = ((MessagesEx.MessageInfo)((MessagesEx.MessageInfo)MessagesEx.fileIsReadOnly(project, virtualFile).setTitle(IdeBundle.message((String)"title.delete", (Object[])new Object[0]))).appendMessage(IdeBundle.message((String)"prompt.delete.it.anyway", (Object[])new Object[0]))).askYesNo()) != 0 || !(success = DeleteHandler.clearReadOnlyFlag(virtualFile, project)))) continue;
                    try {
                        elementToDelete.checkDelete();
                    }
                    catch (IncorrectOperationException ex) {
                        Messages.showMessageDialog((Project)project, (String)ex.getMessage(), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
                        continue;
                    }
                    ApplicationManager.getApplication().runWriteAction(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                elementToDelete.delete();
                            }
                            catch (IncorrectOperationException ex) {
                                ApplicationManager.getApplication().invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        Messages.showMessageDialog((Project)project, (String)ex.getMessage(), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
                                    }
                                });
                            }
                        }
                    });
                }
            }
        }, RefactoringBundle.message((String)"safe.delete.command", (Object[])new Object[]{RefactoringUIUtil.calculatePsiElementDescriptionList(elements)}), null);
    }

    private static boolean clearReadOnlyFlag(final VirtualFile virtualFile, final Project project) {
        final boolean[] success = new boolean[1];
        CommandProcessor.getInstance().executeCommand(project, new Runnable(){

            @Override
            public void run() {
                Runnable action = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ReadOnlyAttributeUtil.setReadOnlyAttribute((VirtualFile)virtualFile, (boolean)false);
                            success[0] = true;
                        }
                        catch (IOException e1) {
                            Messages.showMessageDialog((Project)project, (String)e1.getMessage(), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
                        }
                    }
                };
                ApplicationManager.getApplication().runWriteAction(action);
            }
        }, "", null);
        return success[0];
    }

    private static void getReadOnlyVirtualFiles(VirtualFile file, ArrayList<VirtualFile> readOnlyFiles, FileTypeManager ftManager) {
        if (ftManager.isFileIgnored(file.getName())) {
            return;
        }
        if (!file.isWritable()) {
            readOnlyFiles.add(file);
        }
        if (file.isDirectory()) {
            VirtualFile[] children;
            for (VirtualFile child : children = file.getChildren()) {
                DeleteHandler.getReadOnlyVirtualFiles(child, readOnlyFiles, ftManager);
            }
        }
    }

    public static boolean shouldEnableDeleteAction(PsiElement[] elements) {
        if (elements == null || elements.length == 0) {
            return false;
        }
        for (PsiElement element : elements) {
            if (!(element instanceof PsiCompiledElement)) continue;
            return false;
        }
        return true;
    }

    public static class DefaultDeleteProvider
    implements DeleteProvider {
        public boolean canDeleteElement(DataContext dataContext) {
            if (PlatformDataKeys.PROJECT.getData(dataContext) == null) {
                return false;
            }
            PsiElement[] elements = DefaultDeleteProvider.getPsiElements(dataContext);
            return elements != null && DeleteHandler.shouldEnableDeleteAction(elements);
        }

        @Nullable
        private static PsiElement[] getPsiElements(DataContext dataContext) {
            PsiElement[] elements = (PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(dataContext);
            if (elements == null) {
                Object data = LangDataKeys.PSI_ELEMENT.getData(dataContext);
                if (data != null) {
                    elements = new PsiElement[]{(PsiElement)data};
                } else {
                    Object data1 = LangDataKeys.PSI_FILE.getData(dataContext);
                    if (data1 != null) {
                        elements = new PsiElement[]{(PsiFile)data1};
                    }
                }
            }
            return elements;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deleteElement(DataContext dataContext) {
            PsiElement[] elements = DefaultDeleteProvider.getPsiElements(dataContext);
            if (elements == null) {
                return;
            }
            Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
            if (project == null) {
                return;
            }
            LocalHistoryAction a = LocalHistory.startAction((Project)project, (String)IdeBundle.message((String)"progress.deleting", (Object[])new Object[0]));
            try {
                DeleteHandler.deletePsiElement(elements, project);
            }
            finally {
                a.finish();
            }
        }
    }
}

