/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.DeleteUtil;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringSettings;
import com.intellij.refactoring.safeDelete.SafeDeleteHandler;
import com.intellij.ui.StateRestoringCheckBox;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DeleteDialog
extends DialogWrapper {
    private final PsiElement[] myElements;
    private final Callback myCallback;
    private StateRestoringCheckBox myCbSearchInComments;
    private StateRestoringCheckBox myCbSearchInNonJava;
    private JCheckBox myCbSafeDelete;

    public DeleteDialog(Project project, PsiElement[] elements, Callback callback) {
        super(project, true);
        this.myElements = elements;
        this.myCallback = callback;
        this.setTitle(SafeDeleteHandler.REFACTORING_NAME);
        this.init();
    }

    public boolean isSearchInComments() {
        return this.myCbSearchInComments.isSelected();
    }

    public boolean isSearchInNonJava() {
        return this.myCbSearchInNonJava.isSelected();
    }

    protected Action[] createActions() {
        return new Action[]{this.getOKAction(), this.getCancelAction()};
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp("refactoring.safeDelete");
    }

    protected JComponent createNorthPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        String warningMessage = DeleteUtil.generateWarningMessage(IdeBundle.message((String)"prompt.delete.elements", (Object[])new Object[0]), this.myElements);
        gbc.insets = new Insets(4, 8, 4, 8);
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.fill = 1;
        gbc.anchor = 17;
        panel.add((Component)new JLabel(warningMessage), gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.weightx = 0.0;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(4, 8, 0, 8);
        this.myCbSafeDelete = new JCheckBox(IdeBundle.message((String)"checkbox.safe.delete.with.usage.search", (Object[])new Object[0]));
        panel.add((Component)this.myCbSafeDelete, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.weightx = 0.0;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(0, 8, 4, 8);
        this.myCbSearchInComments = new StateRestoringCheckBox(IdeBundle.message((String)"checkbox.search.in.comments.and.strings", (Object[])new Object[0]));
        panel.add((Component)this.myCbSearchInComments, gbc);
        ++gbc.gridx;
        this.myCbSearchInNonJava = new StateRestoringCheckBox(IdeBundle.message((String)"checkbox.search.in.non.java.files", (Object[])new Object[0]));
        panel.add((Component)this.myCbSearchInNonJava, gbc);
        RefactoringSettings refactoringSettings = RefactoringSettings.getInstance();
        this.myCbSafeDelete.setSelected(refactoringSettings.SAFE_DELETE_WHEN_DELETE);
        this.myCbSearchInComments.setSelected(refactoringSettings.SAFE_DELETE_SEARCH_IN_COMMENTS);
        this.myCbSearchInNonJava.setSelected(refactoringSettings.SAFE_DELETE_SEARCH_IN_NON_JAVA);
        this.myCbSafeDelete.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                DeleteDialog.this.updateControls();
            }
        });
        this.updateControls();
        return panel;
    }

    private void updateControls() {
        if (this.myCbSafeDelete.isSelected()) {
            this.myCbSearchInComments.makeSelectable();
            this.myCbSearchInNonJava.makeSelectable();
        } else {
            this.myCbSearchInComments.makeUnselectable(false);
            this.myCbSearchInNonJava.makeUnselectable(false);
        }
    }

    protected JComponent createCenterPanel() {
        return null;
    }

    protected void doOKAction() {
        RefactoringSettings refactoringSettings = RefactoringSettings.getInstance();
        refactoringSettings.SAFE_DELETE_WHEN_DELETE = this.myCbSafeDelete.isSelected();
        if (this.myCbSafeDelete.isSelected()) {
            if (this.myCallback != null) {
                this.myCallback.run(this);
            } else {
                super.doOKAction();
            }
            refactoringSettings.SAFE_DELETE_SEARCH_IN_COMMENTS = this.isSearchInComments();
            refactoringSettings.SAFE_DELETE_SEARCH_IN_NON_JAVA = this.isSearchInNonJava();
        } else {
            super.doOKAction();
        }
    }

    public static interface Callback {
        public void run(DeleteDialog var1);
    }
}

