/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.customization;

import com.intellij.ide.ui.customization.ActionUrl;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.keymap.impl.ui.Group;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.PopupHandler;
import com.intellij.util.diff.Diff;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomizationUtil {
    public static ActionGroup correctActionGroup(ActionGroup group, CustomActionsSchema schema, String defaultGroupName) {
        if (!schema.isCorrectActionGroup(group)) {
            return group;
        }
        String text = group.getTemplatePresentation().getText();
        int mnemonic = group.getTemplatePresentation().getMnemonic();
        if (text != null) {
            for (int i = 0; i < text.length(); ++i) {
                if (Character.toUpperCase(text.charAt(i)) != mnemonic) continue;
                text = text.replaceFirst(String.valueOf(text.charAt(i)), "_" + text.charAt(i));
                break;
            }
        }
        return new CachedAction(text, group.isPopup(), group, schema, defaultGroupName);
    }

    private static AnAction[] getReordableChildren(ActionGroup group, CustomActionsSchema schema, String defaultGroupName, AnActionEvent e) {
        String text = group.getTemplatePresentation().getText();
        ActionManager actionManager = ActionManager.getInstance();
        ArrayList<Object> reordableChildren = new ArrayList<Object>();
        reordableChildren.addAll(Arrays.asList(group.getChildren(e)));
        ArrayList<ActionUrl> actions = schema.getActions();
        for (ActionUrl actionUrl : actions) {
            AnAction anAction;
            AnAction componentAction;
            if (!actionUrl.getParentGroup().equals(text) && !actionUrl.getParentGroup().equals(defaultGroupName) && !actionUrl.getParentGroup().equals(actionManager.getId((AnAction)group)) || (componentAction = actionUrl.getComponentAction()) == null) continue;
            if (actionUrl.getActionType() == 1) {
                if (reordableChildren.size() > actionUrl.getAbsolutePosition()) {
                    reordableChildren.add(actionUrl.getAbsolutePosition(), componentAction);
                    continue;
                }
                reordableChildren.add(componentAction);
                continue;
            }
            if (actionUrl.getActionType() != -1 || reordableChildren.size() <= actionUrl.getAbsolutePosition() || ((anAction = (AnAction)reordableChildren.get(actionUrl.getAbsolutePosition())).getTemplatePresentation().getText() == null ? componentAction.getTemplatePresentation().getText() != null && componentAction.getTemplatePresentation().getText().length() > 0 : !anAction.getTemplatePresentation().getText().equals(componentAction.getTemplatePresentation().getText()))) continue;
            reordableChildren.remove(actionUrl.getAbsolutePosition());
        }
        for (int i = 0; i < reordableChildren.size(); ++i) {
            if (!(reordableChildren.get(i) instanceof ActionGroup)) continue;
            ActionGroup groupToCorrect = (ActionGroup)reordableChildren.get(i);
            ActionGroup correctedAction = CustomizationUtil.correctActionGroup(groupToCorrect, schema, "");
            reordableChildren.set(i, correctedAction);
        }
        return reordableChildren.toArray(new AnAction[reordableChildren.size()]);
    }

    public static void optimizeSchema(JTree tree, final CustomActionsSchema schema) {
        Group rootGroup = new Group("root", null, null);
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(rootGroup);
        root.removeAllChildren();
        CustomActionsSchema.fillActionGroups(root);
        final JTree defaultTree = new JTree(new DefaultTreeModel(root));
        final ArrayList<ActionUrl> actions = new ArrayList<ActionUrl>();
        TreeUtil.traverseDepth((TreeNode)((TreeNode)tree.getModel().getRoot()), (TreeUtil.Traverse)new TreeUtil.Traverse(){

            public boolean accept(Object node) {
                DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)node;
                if (treeNode.isLeaf()) {
                    return true;
                }
                ActionUrl url = CustomizationUtil.getActionUrl(new TreePath(treeNode.getPath()), 0);
                url.getGroupPath().add(((Group)treeNode.getUserObject()).getName());
                TreePath treePath = CustomizationUtil.getTreePath(defaultTree, url);
                if (treePath != null) {
                    DefaultMutableTreeNode visited = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                    ActionUrl[] defaultUserObjects = CustomizationUtil.getChildUserObjects(visited, url);
                    ActionUrl[] currentUserObjects = CustomizationUtil.getChildUserObjects(treeNode, url);
                    CustomizationUtil.computeDiff(defaultUserObjects, currentUserObjects, actions);
                } else {
                    url.getGroupPath().remove(url.getParentGroup());
                    if (actions.contains(url)) {
                        url.getGroupPath().add(((Group)treeNode.getUserObject()).getName());
                        actions.addAll(schema.getChildActions(url));
                    }
                }
                return true;
            }
        });
        schema.setActions(actions);
    }

    private static void computeDiff(ActionUrl[] defaultUserObjects, ActionUrl[] currentUserObjects, ArrayList<ActionUrl> actions) {
        Diff.Change change = Diff.buildChanges((Object[])defaultUserObjects, (Object[])currentUserObjects);
        while (change != null) {
            ActionUrl currentUserObject;
            int idx;
            int i;
            for (i = 0; i < change.deleted; ++i) {
                idx = change.line0 + i;
                currentUserObject = defaultUserObjects[idx];
                currentUserObject.setActionType(-1);
                currentUserObject.setAbsolutePosition(idx);
                actions.add(currentUserObject);
            }
            for (i = 0; i < change.inserted; ++i) {
                idx = change.line1 + i;
                currentUserObject = currentUserObjects[idx];
                currentUserObject.setActionType(1);
                currentUserObject.setAbsolutePosition(idx);
                actions.add(currentUserObject);
            }
            change = change.link;
        }
    }

    public static TreePath getPathByUserObjects(JTree tree, TreePath treePath) {
        ArrayList<String> path = new ArrayList<String>();
        for (int i = 0; i < treePath.getPath().length; ++i) {
            Object o = ((DefaultMutableTreeNode)treePath.getPath()[i]).getUserObject();
            if (!(o instanceof Group)) continue;
            path.add(((Group)o).getName());
        }
        return CustomizationUtil.getTreePath(0, path, tree.getModel().getRoot(), tree);
    }

    public static ActionUrl getActionUrl(TreePath treePath, int actionType) {
        ActionUrl url = new ActionUrl();
        for (int i = 0; i < treePath.getPath().length - 1; ++i) {
            Object o = ((DefaultMutableTreeNode)treePath.getPath()[i]).getUserObject();
            if (!(o instanceof Group)) continue;
            url.getGroupPath().add(((Group)o).getName());
        }
        DefaultMutableTreeNode component = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        url.setComponent(component.getUserObject());
        DefaultMutableTreeNode node = component;
        TreeNode parent = node.getParent();
        url.setAbsolutePosition(parent != null ? parent.getIndex(node) : 0);
        url.setActionType(actionType);
        return url;
    }

    public static TreePath getTreePath(JTree tree, ActionUrl url) {
        return CustomizationUtil.getTreePath(0, url.getGroupPath(), tree.getModel().getRoot(), tree);
    }

    private static TreePath getTreePath(int positionInPath, List<String> path, Object root, JTree tree) {
        TreeNode child;
        if (!(root instanceof DefaultMutableTreeNode)) {
            return null;
        }
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)root;
        Object userObject = treeNode.getUserObject();
        if (path.size() <= positionInPath) {
            return null;
        }
        String pathElement = path.get(positionInPath);
        if (pathElement == null) {
            return null;
        }
        if (!(userObject instanceof Group)) {
            return null;
        }
        if (!pathElement.equals(((Group)userObject).getName())) {
            return null;
        }
        TreePath currentPath = new TreePath(treeNode.getPath());
        if (positionInPath == path.size() - 1) {
            return currentPath;
        }
        for (int j = 0; j < treeNode.getChildCount() && (currentPath = CustomizationUtil.getTreePath(positionInPath + 1, path, child = treeNode.getChildAt(j), tree)) == null; ++j) {
        }
        return currentPath;
    }

    private static ActionUrl[] getChildUserObjects(DefaultMutableTreeNode node, ActionUrl parent) {
        ArrayList<ActionUrl> result = new ArrayList<ActionUrl>();
        ArrayList<String> groupPath = new ArrayList<String>();
        groupPath.addAll(parent.getGroupPath());
        for (int i = 0; i < node.getChildCount(); ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
            ActionUrl url = new ActionUrl();
            url.setGroupPath(groupPath);
            Object userObject = child.getUserObject();
            url.setComponent(userObject instanceof Pair ? ((Pair)userObject).first : userObject);
            result.add(url);
        }
        return result.toArray(new ActionUrl[result.size()]);
    }

    public static MouseListener installPopupHandler(JComponent component, final @NotNull String groupId, final String place) {
        if (groupId == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ide/ui/customization/CustomizationUtil.installPopupHandler must not be null");
        }
        if (ApplicationManager.getApplication() == null) {
            return new MouseAdapter(){};
        }
        PopupHandler popupHandler = new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                ActionGroup group = (ActionGroup)CustomActionsSchema.getInstance().getCorrectedAction(groupId);
                ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu(place, group);
                popupMenu.getComponent().show(comp, x, y);
            }
        };
        component.addMouseListener((MouseListener)popupHandler);
        return popupHandler;
    }

    private static class CachedAction
    extends ActionGroup {
        private boolean myForceUpdate;
        private final ActionGroup myGroup;
        private AnAction[] myChildren;
        private final CustomActionsSchema mySchema;
        private final String myDefaultGroupName;

        public CachedAction(String shortName, boolean popup, ActionGroup group, CustomActionsSchema schema, String defaultGroupName) {
            super(shortName, popup);
            this.myGroup = group;
            this.mySchema = schema;
            this.myDefaultGroupName = defaultGroupName;
            this.myForceUpdate = true;
        }

        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            if (this.myForceUpdate) {
                this.myChildren = CustomizationUtil.getReordableChildren(this.myGroup, this.mySchema, this.myDefaultGroupName, e);
                this.myForceUpdate = false;
                return this.myChildren;
            }
            if (!(this.myGroup instanceof DefaultActionGroup) || this.myChildren == null) {
                this.myChildren = CustomizationUtil.getReordableChildren(this.myGroup, this.mySchema, this.myDefaultGroupName, e);
            }
            return this.myChildren;
        }

        public void update(AnActionEvent e) {
            this.myGroup.update(e);
        }
    }
}

