/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo.configurable;

import com.intellij.psi.search.TodoPattern;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

final class TodoPatternTableCellRenderer
extends DefaultTableCellRenderer {
    private final List<TodoPattern> myPatterns;

    public TodoPatternTableCellRenderer(List<TodoPattern> patterns) {
        this.myPatterns = patterns;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        TodoPattern pattern = this.myPatterns.get(row);
        if (isSelected) {
            this.setForeground(UIUtil.getTableSelectionForeground());
        } else if (pattern.getPattern() == null) {
            this.setForeground(Color.RED);
        } else {
            this.setForeground(UIUtil.getTableForeground());
        }
        return this;
    }
}

