/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.impl.xml;

import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.impl.xml.AbstractXmlTagTreeElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class XmlTagTreeElement
extends AbstractXmlTagTreeElement<XmlTag> {
    @NonNls
    private static final String ID_ATTR_NAME = "id";
    @NonNls
    private static final String NAME_ATTR_NAME = "name";

    public XmlTagTreeElement(XmlTag tag) {
        super(tag);
    }

    @Override
    @NotNull
    public Collection<StructureViewTreeElement> getChildrenBase() {
        Collection<StructureViewTreeElement> collection = XmlTagTreeElement.getStructureViewTreeElements(((XmlTag)this.getElement()).getSubTags());
        if (collection == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/structureView/impl/xml/XmlTagTreeElement.getChildrenBase must not return null");
        }
        return collection;
    }

    public String getPresentableText() {
        XmlTag element = (XmlTag)this.getElement();
        String id = element.getAttributeValue(ID_ATTR_NAME);
        if (id == null) {
            id = element.getAttributeValue(NAME_ATTR_NAME);
        }
        if ((id = XmlTagTreeElement.toCanonicalForm(id)) != null) {
            return id + ":" + element.getLocalName();
        }
        return element.getName();
    }

    @Override
    public String getLocationString() {
        StringBuffer buffer = new StringBuffer();
        XmlTag element = (XmlTag)this.getElement();
        XmlAttribute[] attributes = element.getAttributes();
        String id = element.getAttributeValue(ID_ATTR_NAME);
        String usedAttrName = null;
        if (id == null) {
            id = element.getAttributeValue(NAME_ATTR_NAME);
            if (id != null) {
                usedAttrName = NAME_ATTR_NAME;
            }
        } else {
            usedAttrName = ID_ATTR_NAME;
        }
        id = XmlTagTreeElement.toCanonicalForm(id);
        for (XmlAttribute attribute : attributes) {
            if (buffer.length() != 0) {
                buffer.append(" ");
            }
            String name = attribute.getName();
            if (usedAttrName != null && id != null && usedAttrName.equals(name)) continue;
            buffer.append(name);
            buffer.append("=");
            buffer.append("\"");
            buffer.append(attribute.getValue());
            buffer.append("\"");
        }
        return buffer.toString();
    }

    private static String toCanonicalForm(String id) {
        if (id != null && (id = id.trim()).length() == 0) {
            id = null;
        }
        return id;
    }
}

