/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.impl.StructureViewWrapperImpl;
import com.intellij.ide.structureView.StructureView;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewFactoryEx;
import com.intellij.ide.structureView.StructureViewWrapper;
import com.intellij.ide.structureView.impl.StructureViewComposite;
import com.intellij.ide.structureView.impl.StructureViewState;
import com.intellij.ide.structureView.newStructureView.StructureViewComponent;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageStructureViewBuilder;
import com.intellij.lang.PsiStructureViewFactory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TemplateLanguageStructureViewBuilder
implements StructureViewBuilder {
    private final VirtualFile myVirtualFile;
    private final Project myProject;
    private final PsiTreeChangeAdapter myPsiTreeChangeAdapter;
    private Language myTemplateDataLanguage;
    private StructureViewComposite.StructureViewDescriptor myBaseStructureViewDescriptor;
    private FileEditor myFileEditor;
    private StructureViewComposite myStructureViewComposite;
    private int myBaseLanguageViewDescriptorIndex;

    protected TemplateLanguageStructureViewBuilder(PsiElement psiElement) {
        this.myVirtualFile = psiElement.getContainingFile().getVirtualFile();
        this.myProject = psiElement.getProject();
        this.myPsiTreeChangeAdapter = new PsiTreeChangeAdapter(){
            final Alarm myAlarm = new Alarm();

            public void childAdded(PsiTreeChangeEvent event) {
                this.childrenChanged(event);
            }

            public void childRemoved(PsiTreeChangeEvent event) {
                this.childrenChanged(event);
            }

            public void childReplaced(PsiTreeChangeEvent event) {
                this.childrenChanged(event);
            }

            public void childMoved(PsiTreeChangeEvent event) {
                this.childrenChanged(event);
            }

            public void childrenChanged(PsiTreeChangeEvent event) {
                this.myAlarm.cancelAllRequests();
                this.myAlarm.addRequest(new Runnable(){

                    @Override
                    public void run() {
                        if (TemplateLanguageStructureViewBuilder.this.myProject.isDisposed()) {
                            return;
                        }
                        if (TemplateLanguageStructureViewBuilder.this.myBaseStructureViewDescriptor != null && ((StructureViewComponent)((TemplateLanguageStructureViewBuilder)TemplateLanguageStructureViewBuilder.this).myBaseStructureViewDescriptor.structureView).getTree() == null) {
                            return;
                        }
                        if (!TemplateLanguageStructureViewBuilder.this.myVirtualFile.isValid()) {
                            return;
                        }
                        ApplicationManager.getApplication().runReadAction(new Runnable(){

                            @Override
                            public void run() {
                                TemplateLanguageFileViewProvider provider = TemplateLanguageStructureViewBuilder.this.getViewProvider();
                                if (provider == null) {
                                    return;
                                }
                                StructureViewWrapper structureViewWrapper = StructureViewFactoryEx.getInstanceEx(TemplateLanguageStructureViewBuilder.this.myProject).getStructureViewWrapper();
                                if (structureViewWrapper == null) {
                                    return;
                                }
                                Language baseLanguage = provider.getTemplateDataLanguage();
                                if (baseLanguage == TemplateLanguageStructureViewBuilder.this.myTemplateDataLanguage) {
                                    TemplateLanguageStructureViewBuilder.this.updateBaseLanguageView();
                                } else {
                                    TemplateLanguageStructureViewBuilder.this.myTemplateDataLanguage = baseLanguage;
                                    ((StructureViewWrapperImpl)structureViewWrapper).rebuild();
                                }
                            }
                        });
                    }
                }, 300, ModalityState.NON_MODAL);
            }
        };
        TemplateLanguageFileViewProvider provider = this.getViewProvider();
        assert (provider != null);
        this.myTemplateDataLanguage = provider.getTemplateDataLanguage();
        PsiManager.getInstance((Project)this.myProject).addPsiTreeChangeListener((PsiTreeChangeListener)this.myPsiTreeChangeAdapter);
    }

    @Nullable
    private TemplateLanguageFileViewProvider getViewProvider() {
        FileViewProvider provider = PsiManager.getInstance((Project)this.myProject).findViewProvider(this.myVirtualFile);
        return provider instanceof TemplateLanguageFileViewProvider ? (TemplateLanguageFileViewProvider)provider : null;
    }

    private void updateBaseLanguageView() {
        PsiElement element;
        if (this.myBaseStructureViewDescriptor == null || !this.myProject.isOpen()) {
            return;
        }
        StructureViewComponent view = (StructureViewComponent)this.myBaseStructureViewDescriptor.structureView;
        if (view.isDisposed()) {
            return;
        }
        StructureViewState state = view.getState();
        List<PsiAnchor> expanded = TemplateLanguageStructureViewBuilder.collectAnchors(state.getExpandedElements());
        List<PsiAnchor> selected = TemplateLanguageStructureViewBuilder.collectAnchors(state.getSelectedElements());
        this.updateTemplateDataFileView();
        if (view.isDisposed()) {
            return;
        }
        for (PsiAnchor pointer : expanded) {
            element = pointer.retrieve();
            if (element == null) continue;
            view.expandPathToElement(element);
        }
        for (PsiAnchor pointer : selected) {
            element = pointer.retrieve();
            if (element == null) continue;
            view.addSelectionPathTo(element);
        }
    }

    private static List<PsiAnchor> collectAnchors(Object[] expandedElements) {
        ArrayList<PsiAnchor> expanded = new ArrayList<PsiAnchor>(expandedElements == null ? 0 : expandedElements.length);
        if (expandedElements != null) {
            for (Object element : expandedElements) {
                if (!(element instanceof PsiElement) || !((PsiElement)element).isValid()) continue;
                expanded.add(PsiAnchor.create((PsiElement)element));
            }
        }
        return expanded;
    }

    private void removeBaseLanguageListener() {
        PsiManager.getInstance((Project)this.myProject).removePsiTreeChangeListener((PsiTreeChangeListener)this.myPsiTreeChangeAdapter);
    }

    @NotNull
    public StructureView createStructureView(FileEditor fileEditor, Project project) {
        this.myFileEditor = fileEditor;
        ArrayList<StructureViewComposite.StructureViewDescriptor> viewDescriptors = new ArrayList<StructureViewComposite.StructureViewDescriptor>();
        TemplateLanguageFileViewProvider provider = this.getViewProvider();
        assert (provider != null);
        StructureViewComposite.StructureViewDescriptor structureViewDescriptor = this.createMainView(fileEditor, provider.getPsi(provider.getBaseLanguage()));
        if (structureViewDescriptor != null) {
            viewDescriptors.add(structureViewDescriptor);
        }
        this.myBaseLanguageViewDescriptorIndex = -1;
        Language dataLanguage = provider.getTemplateDataLanguage();
        this.updateTemplateDataFileView();
        if (this.myBaseStructureViewDescriptor != null) {
            viewDescriptors.add(this.myBaseStructureViewDescriptor);
            this.myBaseLanguageViewDescriptorIndex = viewDescriptors.size() - 1;
        }
        for (Language language : provider.getLanguages()) {
            if (language == dataLanguage || language == provider.getBaseLanguage()) continue;
            ContainerUtil.addIfNotNull((Object)this.createBaseLanguageStructureView(fileEditor, language), viewDescriptors);
        }
        StructureViewComposite.StructureViewDescriptor[] array = viewDescriptors.toArray(new StructureViewComposite.StructureViewDescriptor[viewDescriptors.size()]);
        StructureViewComposite structureViewComposite = this.myStructureViewComposite = new StructureViewComposite(array){

            @Override
            public void dispose() {
                TemplateLanguageStructureViewBuilder.this.removeBaseLanguageListener();
                super.dispose();
            }
        };
        if (structureViewComposite == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/structureView/impl/TemplateLanguageStructureViewBuilder.createStructureView must not return null");
        }
        return structureViewComposite;
    }

    protected abstract StructureViewComposite.StructureViewDescriptor createMainView(FileEditor var1, PsiFile var2);

    @Nullable
    private StructureViewComposite.StructureViewDescriptor createBaseLanguageStructureView(FileEditor fileEditor, Language language) {
        if (!this.myVirtualFile.isValid()) {
            return null;
        }
        TemplateLanguageFileViewProvider viewProvider = this.getViewProvider();
        if (viewProvider == null) {
            return null;
        }
        PsiFile dataFile = viewProvider.getPsi(language);
        if (dataFile == null || !this.isAcceptableBaseLanguageFile(dataFile)) {
            return null;
        }
        PsiStructureViewFactory factory = (PsiStructureViewFactory)LanguageStructureViewBuilder.INSTANCE.forLanguage(language);
        if (factory == null) {
            return null;
        }
        StructureViewBuilder builder = factory.getStructureViewBuilder(dataFile);
        if (builder == null) {
            return null;
        }
        StructureView structureView = builder.createStructureView(fileEditor, this.myProject);
        return new StructureViewComposite.StructureViewDescriptor(IdeBundle.message((String)"tab.structureview.baselanguage.view", (Object[])new Object[]{language.getDisplayName()}), structureView, TemplateLanguageStructureViewBuilder.findFileType(language).getIcon());
    }

    protected boolean isAcceptableBaseLanguageFile(PsiFile dataFile) {
        return true;
    }

    private void updateTemplateDataFileView() {
        new WriteCommandAction(this.myProject, new PsiFile[0]){

            protected void run(Result result) throws Throwable {
                Language newDataLanguage;
                TemplateLanguageFileViewProvider provider = TemplateLanguageStructureViewBuilder.this.getViewProvider();
                Language language = newDataLanguage = provider == null ? null : provider.getTemplateDataLanguage();
                if (TemplateLanguageStructureViewBuilder.this.myBaseStructureViewDescriptor != null) {
                    if (TemplateLanguageStructureViewBuilder.this.myTemplateDataLanguage == newDataLanguage) {
                        return;
                    }
                    Disposer.dispose((Disposable)((TemplateLanguageStructureViewBuilder)TemplateLanguageStructureViewBuilder.this).myBaseStructureViewDescriptor.structureView);
                }
                if (newDataLanguage != null) {
                    TemplateLanguageStructureViewBuilder.this.myBaseStructureViewDescriptor = TemplateLanguageStructureViewBuilder.this.createBaseLanguageStructureView(TemplateLanguageStructureViewBuilder.this.myFileEditor, newDataLanguage);
                    if (TemplateLanguageStructureViewBuilder.this.myStructureViewComposite != null) {
                        TemplateLanguageStructureViewBuilder.this.myStructureViewComposite.setStructureView(TemplateLanguageStructureViewBuilder.this.myBaseLanguageViewDescriptorIndex, TemplateLanguageStructureViewBuilder.this.myBaseStructureViewDescriptor);
                    }
                }
            }
        }.execute();
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static FileType findFileType(Language language) {
        FileType fileType;
        FileType[] registeredFileTypes;
        for (FileType fileType2 : registeredFileTypes = FileTypeManager.getInstance().getRegisteredFileTypes()) {
            if (!(fileType2 instanceof LanguageFileType) || ((LanguageFileType)fileType2).getLanguage() != language) continue;
            fileType = fileType2;
            if (fileType == null) throw new IllegalStateException("@NotNull method com/intellij/ide/structureView/impl/TemplateLanguageStructureViewBuilder.findFileType must not return null");
            return fileType;
        }
        fileType = FileTypes.UNKNOWN;
        if (fileType != null) return fileType;
        throw new IllegalStateException("@NotNull method com/intellij/ide/structureView/impl/TemplateLanguageStructureViewBuilder.findFileType must not return null");
    }
}

