/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.impl;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.BaseScopeProcessor;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.HashMap;
import java.util.Collection;
import java.util.Map;

public class AddAllMembersProcessor
extends BaseScopeProcessor {
    private final Collection<PsiElement> myAllMembers;
    private final PsiClass myPsiClass;
    private final Map<MethodSignature, PsiMethod> myMethodsBySignature = new HashMap();
    private final MemberFilter myFilter;
    public static final MemberFilter ALL_ACCESSIBLE = new MemberFilter(){

        @Override
        protected boolean isVisible(PsiModifierListOwner member) {
            return true;
        }
    };
    public static final MemberFilter PUBLIC_ONLY = new MemberFilter(){

        @Override
        protected boolean isVisible(PsiModifierListOwner member) {
            return member.hasModifierProperty("public");
        }
    };

    public AddAllMembersProcessor(Collection<PsiElement> allMembers, PsiClass psiClass) {
        this(allMembers, psiClass, ALL_ACCESSIBLE);
    }

    public AddAllMembersProcessor(Collection<PsiElement> allMembers, PsiClass psiClass, MemberFilter filter) {
        for (PsiElement psiElement : allMembers) {
            if (!(psiElement instanceof PsiMethod)) continue;
            this.mapMethodBySignature((PsiMethod)psiElement);
        }
        this.myAllMembers = allMembers;
        this.myPsiClass = psiClass;
        this.myFilter = filter;
    }

    public boolean execute(PsiElement element, ResolveState state) {
        PsiMember member = (PsiMember)element;
        if (!AddAllMembersProcessor.isInteresting(element)) {
            return true;
        }
        if (this.myPsiClass.isInterface() && AddAllMembersProcessor.isObjectMember(element)) {
            return true;
        }
        if (!this.myAllMembers.contains(member) && this.myFilter.isVisible(member, this.myPsiClass)) {
            if (member instanceof PsiMethod) {
                PsiMethod psiMethod = (PsiMethod)member;
                if (this.shouldAdd(psiMethod)) {
                    this.mapMethodBySignature(psiMethod);
                    this.myAllMembers.add((PsiElement)psiMethod);
                }
            } else {
                this.myAllMembers.add((PsiElement)member);
            }
        }
        return true;
    }

    private static boolean isObjectMember(PsiElement element) {
        if (!(element instanceof PsiMethod)) {
            return false;
        }
        PsiClass containingClass = ((PsiMethod)element).getContainingClass();
        if (containingClass == null) {
            return false;
        }
        String qualifiedName = containingClass.getQualifiedName();
        return qualifiedName != null && qualifiedName.equals(Object.class.getName());
    }

    private void mapMethodBySignature(PsiMethod psiMethod) {
        this.myMethodsBySignature.put(psiMethod.getSignature(PsiSubstitutor.EMPTY), psiMethod);
    }

    private boolean shouldAdd(PsiMethod psiMethod) {
        MethodSignature signature = psiMethod.getSignature(PsiSubstitutor.EMPTY);
        PsiMethod previousMethod = this.myMethodsBySignature.get(signature);
        if (previousMethod == null) {
            return true;
        }
        if (AddAllMembersProcessor.isInheritor(psiMethod, previousMethod)) {
            this.myAllMembers.remove(previousMethod);
            return true;
        }
        return false;
    }

    private static boolean isInteresting(PsiElement element) {
        return element instanceof PsiMethod || element instanceof PsiField || element instanceof PsiClass || element instanceof PsiClassInitializer;
    }

    public static boolean isInheritor(PsiMethod method, PsiMethod baseMethod) {
        return !AddAllMembersProcessor.isStatic(method) && !AddAllMembersProcessor.isStatic(baseMethod) && method.getContainingClass().isInheritor(baseMethod.getContainingClass(), true);
    }

    private static boolean isStatic(PsiMethod method) {
        return method.hasModifierProperty("static");
    }

    public static abstract class MemberFilter {
        public boolean isVisible(PsiMember element, PsiClass psiClass) {
            return !MemberFilter.isInheritedConstructor(element, psiClass) && PsiUtil.isAccessible((PsiMember)element, (PsiElement)psiClass, null) && this.isVisible((PsiModifierListOwner)element);
        }

        private static boolean isInheritedConstructor(PsiMember member, PsiClass psiClass) {
            if (!(member instanceof PsiMethod)) {
                return false;
            }
            PsiMethod method = (PsiMethod)member;
            return method.isConstructor() && method.getContainingClass() != psiClass;
        }

        protected abstract boolean isVisible(PsiModifierListOwner var1);
    }
}

