/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.passwordSafe.impl.providers.memory;

import com.intellij.ide.passwordSafe.impl.providers.BasePasswordSafeProvider;
import com.intellij.ide.passwordSafe.impl.providers.ByteArrayWrapper;
import com.intellij.ide.passwordSafe.impl.providers.EncryptionUtil;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.HashMap;
import java.security.SecureRandom;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public class MemoryPasswordSafe
extends BasePasswordSafeProvider {
    private final transient AtomicReference<byte[]> key = new AtomicReference();
    private final transient Map<ByteArrayWrapper, byte[]> database = new HashMap();

    @Override
    protected byte[] key(Project project) {
        if (this.key.get() == null) {
            byte[] rnd = new byte[256];
            new SecureRandom().nextBytes(rnd);
            this.key.compareAndSet(null, EncryptionUtil.genKey(EncryptionUtil.hash(new byte[][]{rnd})));
        }
        return this.key.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected byte[] getEncryptedPassword(byte[] key) {
        Map<ByteArrayWrapper, byte[]> map = this.database;
        synchronized (map) {
            return this.database.get(new ByteArrayWrapper(key));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void removeEncryptedPassword(byte[] key) {
        Map<ByteArrayWrapper, byte[]> map = this.database;
        synchronized (map) {
            this.database.remove(new ByteArrayWrapper(key));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void storeEncryptedPassword(byte[] key, byte[] encryptedPassword) {
        Map<ByteArrayWrapper, byte[]> map = this.database;
        synchronized (map) {
            this.database.put(new ByteArrayWrapper(key), encryptedPassword);
        }
    }

    @Override
    public boolean isSupported() {
        return true;
    }

    @Override
    public String getDescription() {
        return "Memory-based password safe provider. The passwords are stored only for the duration of IDEA process.";
    }

    @Override
    public String getName() {
        return "Memory PasswordSafe";
    }
}

