/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.passwordSafe.impl;

import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.ide.passwordSafe.PasswordSafeException;
import com.intellij.ide.passwordSafe.config.PasswordSafeSettings;
import com.intellij.ide.passwordSafe.impl.PasswordSafeProvider;
import com.intellij.ide.passwordSafe.impl.providers.masterKey.MasterKeyPasswordSafe;
import com.intellij.ide.passwordSafe.impl.providers.masterKey.PasswordDatabase;
import com.intellij.ide.passwordSafe.impl.providers.memory.MemoryPasswordSafe;
import com.intellij.ide.passwordSafe.impl.providers.nil.NilProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;

public class PasswordSafeImpl
extends PasswordSafe {
    private static final Logger LOG = Logger.getInstance((String)PasswordSafeImpl.class.getName());
    private final PasswordSafeSettings mySettings;
    private final MasterKeyPasswordSafe myMasterKeyProvider;
    private final NilProvider myNilProvider;
    private final MemoryPasswordSafe myMemoryProvider;

    public PasswordSafeImpl(PasswordSafeSettings settings, PasswordDatabase database) {
        this.mySettings = settings;
        this.myMasterKeyProvider = new MasterKeyPasswordSafe(database);
        this.myNilProvider = new NilProvider();
        this.myMemoryProvider = new MemoryPasswordSafe();
    }

    private PasswordSafeProvider provider() {
        PasswordSafeProvider p = null;
        switch (this.mySettings.getProviderType()) {
            case DO_NOT_STORE: {
                p = this.myNilProvider;
                break;
            }
            case MEMORY_ONLY: {
                p = this.myMemoryProvider;
                break;
            }
            case MASTER_PASSWORD: {
                p = this.myMasterKeyProvider;
                break;
            }
            default: {
                LOG.error("Unknown provider type: " + (Object)((Object)this.mySettings.getProviderType()));
            }
        }
        if (p == null || !p.isSupported()) {
            p = this.myMemoryProvider;
        }
        return p;
    }

    public PasswordSafeSettings getSettings() {
        return this.mySettings;
    }

    @Override
    public String getPassword(Project project, Class requester, String key) throws PasswordSafeException {
        return this.provider().getPassword(project, requester, key);
    }

    @Override
    public void removePassword(Project project, Class requester, String key) throws PasswordSafeException {
        this.provider().removePassword(project, requester, key);
    }

    @Override
    public void storePassword(Project project, Class requester, String key, String value) throws PasswordSafeException {
        this.provider().storePassword(project, requester, key, value);
    }

    public MasterKeyPasswordSafe getMasterKeyProvider() {
        return this.myMasterKeyProvider;
    }
}

