/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.palette.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.palette.PaletteDragEventListener;
import com.intellij.ide.palette.PaletteItem;
import com.intellij.ide.palette.impl.PaletteWindow;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PaletteManager
implements ProjectComponent {
    private final Project myProject;
    private final FileEditorManager myFileEditorManager;
    private PaletteWindow myPaletteWindow;
    private ToolWindow myPaletteToolWindow;
    private final List<KeyListener> myKeyListeners = ContainerUtil.createEmptyCOWList();
    private final List<PaletteDragEventListener> myDragEventListeners = ContainerUtil.createEmptyCOWList();
    private final List<ListSelectionListener> mySelectionListeners = ContainerUtil.createEmptyCOWList();
    private MergingUpdateQueue myQueue = new MergingUpdateQueue("palette", 200, true, null);

    public PaletteManager(Project project, FileEditorManager fileEditorManager) {
        this.myProject = project;
        this.myFileEditorManager = fileEditorManager;
    }

    public void projectOpened() {
        StartupManager.getInstance((Project)this.myProject).registerPostStartupActivity(new Runnable(){

            @Override
            public void run() {
                PaletteManager.this.myPaletteWindow = new PaletteWindow(PaletteManager.this.myProject);
                PaletteManager.this.myPaletteToolWindow = ToolWindowManager.getInstance((Project)PaletteManager.this.myProject).registerToolWindow(IdeBundle.message((String)"toolwindow.palette", (Object[])new Object[0]), (JComponent)PaletteManager.this.myPaletteWindow, ToolWindowAnchor.RIGHT, (Disposable)PaletteManager.this.myProject, true);
                PaletteManager.this.myPaletteToolWindow.setIcon(IconLoader.getIcon((String)"/general/toolWindowPalette.png"));
                PaletteManager.this.myPaletteToolWindow.setAvailable(false, null);
                MyFileEditorManagerListener myListener = new MyFileEditorManagerListener();
                PaletteManager.this.myFileEditorManager.addFileEditorManagerListener((FileEditorManagerListener)myListener, (Disposable)PaletteManager.this.myProject);
            }
        });
    }

    public void projectClosed() {
        if (this.myPaletteWindow != null) {
            ToolWindowManager.getInstance((Project)this.myProject).unregisterToolWindow(IdeBundle.message((String)"toolwindow.palette", (Object[])new Object[0]));
            this.myPaletteWindow = null;
        }
    }

    @NotNull
    public String getComponentName() {
        if ("PaletteManager" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/palette/impl/PaletteManager.getComponentName must not return null");
        }
        return "PaletteManager";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    public static PaletteManager getInstance(Project project) {
        return (PaletteManager)project.getComponent(PaletteManager.class);
    }

    public void clearActiveItem() {
        if (this.myPaletteWindow != null) {
            this.myPaletteWindow.clearActiveItem();
        }
    }

    @Nullable
    public PaletteItem getActiveItem() {
        if (this.myPaletteWindow != null) {
            return this.myPaletteWindow.getActiveItem();
        }
        return null;
    }

    @Nullable
    public <T extends PaletteItem> T getActiveItem(Class<T> cls) {
        PaletteItem item = this.getActiveItem();
        if (item != null && item.getClass().isInstance(item)) {
            return (T)item;
        }
        return null;
    }

    public void addKeyListener(KeyListener l) {
        this.myKeyListeners.add(l);
    }

    public void removeKeyListener(KeyListener l) {
        this.myKeyListeners.remove(l);
    }

    public void addDragEventListener(PaletteDragEventListener l) {
        this.myDragEventListeners.add(l);
    }

    public void removeDragEventListener(PaletteDragEventListener l) {
        this.myDragEventListeners.remove(l);
    }

    public void addSelectionListener(ListSelectionListener l) {
        this.mySelectionListeners.add(l);
    }

    public void removeSelectionListener(ListSelectionListener l) {
        this.mySelectionListeners.remove(l);
    }

    private void processFileEditorChange(final @Nullable VirtualFile selectedFile) {
        this.myQueue.cancelAllUpdates();
        this.myQueue.queue(new Update("update"){

            public void run() {
                if (PaletteManager.this.myPaletteWindow == null) {
                    return;
                }
                PaletteManager.this.myPaletteWindow.refreshPaletteIfChanged(selectedFile);
                if (PaletteManager.this.myPaletteWindow.getActiveGroupCount() == 0) {
                    PaletteManager.this.myPaletteToolWindow.setAvailable(false, null);
                } else {
                    PaletteManager.this.myPaletteToolWindow.setAvailable(true, null);
                    PaletteManager.this.myPaletteToolWindow.show(null);
                }
            }
        });
    }

    void notifyKeyEvent(KeyEvent e) {
        for (KeyListener l : this.myKeyListeners) {
            if (e.getID() == 401) {
                l.keyPressed(e);
                continue;
            }
            if (e.getID() == 402) {
                l.keyReleased(e);
                continue;
            }
            if (e.getID() != 400) continue;
            l.keyTyped(e);
        }
    }

    void notifyDropActionChanged(int gestureModifiers) {
        for (PaletteDragEventListener l : this.myDragEventListeners) {
            l.dropActionChanged(gestureModifiers);
        }
    }

    void notifySelectionChanged(ListSelectionEvent event) {
        for (ListSelectionListener l : this.mySelectionListeners) {
            l.valueChanged(event);
        }
    }

    private class MyFileEditorManagerListener
    implements FileEditorManagerListener {
        private MyFileEditorManagerListener() {
        }

        public void fileOpened(FileEditorManager source, VirtualFile file) {
            PaletteManager.this.processFileEditorChange(file);
        }

        public void fileClosed(FileEditorManager source, VirtualFile file) {
            PaletteManager.this.processFileEditorChange(null);
        }

        public void selectionChanged(FileEditorManagerEvent event) {
            PaletteManager.this.processFileEditorChange(event.getNewFile());
        }
    }
}

