/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl.dataRules;

import com.intellij.ide.impl.dataRules.GetDataRule;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;

public class FileTextRule
implements GetDataRule {
    @Override
    public Object getData(DataProvider dataProvider) {
        VirtualFile virtualFile = (VirtualFile)dataProvider.getData(PlatformDataKeys.VIRTUAL_FILE.getName());
        if (virtualFile == null) {
            return null;
        }
        FileType fileType = virtualFile.getFileType();
        if (fileType.isBinary() || fileType.isReadOnly()) {
            return null;
        }
        Project project = (Project)dataProvider.getData(PlatformDataKeys.PROJECT.getName());
        if (project == null) {
            return null;
        }
        Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
        if (document == null) {
            return null;
        }
        return document.getText();
    }
}

