/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl;

import com.intellij.ide.SelectInContext;
import com.intellij.ide.SelectInManager;
import com.intellij.ide.impl.ProjectViewSelectInTarget;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.PsiUtilBase;

public class PackagesPaneSelectInTarget
extends ProjectViewSelectInTarget {
    public PackagesPaneSelectInTarget(Project project) {
        super(project);
    }

    @Override
    public String toString() {
        return SelectInManager.PACKAGES;
    }

    @Override
    public boolean canSelect(PsiFileSystemItem file) {
        if (!super.canSelect(file)) {
            return false;
        }
        VirtualFile vFile = PsiUtilBase.getVirtualFile((PsiElement)file);
        return this.canSelect(vFile);
    }

    private boolean canSelect(VirtualFile vFile) {
        if (vFile != null && vFile.isValid()) {
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
            return fileIndex.isInSourceContent(vFile) || this.isInLibraryContentOnly(vFile);
        }
        return false;
    }

    @Override
    public boolean isSubIdSelectable(String subId, SelectInContext context) {
        return this.canSelect(context);
    }

    private boolean isInLibraryContentOnly(VirtualFile vFile) {
        if (vFile == null) {
            return false;
        }
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        return (projectFileIndex.isInLibraryClasses(vFile) || projectFileIndex.isInLibrarySource(vFile)) && !projectFileIndex.isInSourceContent(vFile);
    }

    public String getMinorViewId() {
        return "PackagesPane";
    }

    public float getWeight() {
        return 2.0f;
    }

    @Override
    protected boolean canWorkWithCustomObjects() {
        return false;
    }
}

