/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.highlighter.custom;

public class PosBufferTokenizer {
    private CharSequence buffer;
    private char[] buf = new char[20];
    private int peekc = Integer.MAX_VALUE;
    private static final int NEED_CHAR = Integer.MAX_VALUE;
    private boolean pushedBack;
    private final byte[] ctype = new byte[256];
    private static final byte CT_WHITESPACE = 1;
    private static final byte CT_DIGIT = 2;
    private static final byte CT_ALPHA = 4;
    private static final byte CT_QUOTE = 8;
    private static final byte CT_POSTFIX = 16;
    public int ttype = -4;
    public static final int TT_EOF = -1;
    public static final int TT_EOL = 10;
    public static final int TT_NUMBER = -2;
    public static final int TT_WORD = -3;
    public static final int TT_QUOTE = -5;
    public static final int TT_WHITESPACE = -6;
    private static final int TT_NOTHING = -4;
    private String hexPrefix;
    private Object lock;
    private int bufferEnd;
    private int pos;
    public String sval;
    public int startOffset;
    public int endOffset;
    private boolean myIgnoreCase;

    public PosBufferTokenizer() {
        this.wordChars(97, 122);
        this.wordChars(65, 90);
        this.wordChars(160, 255);
        this.whitespaceChars(0, 32);
        this.parseNumbers();
    }

    public void start(CharSequence buffer, int from, int to) {
        if (buffer == null) {
            throw new NullPointerException();
        }
        this.lock = this;
        this.buffer = buffer;
        if (to < from) {
            throw new IllegalArgumentException();
        }
        this.pos = from;
        this.bufferEnd = to;
    }

    public void resetSyntax() {
        int i = this.ctype.length;
        while (--i >= 0) {
            this.ctype[i] = 0;
        }
    }

    public void wordChars(int low, int hi) {
        if (low < 0) {
            low = 0;
        }
        if (hi >= this.ctype.length) {
            hi = this.ctype.length - 1;
        }
        while (low <= hi) {
            int n = low++;
            this.ctype[n] = (byte)(this.ctype[n] | 4);
        }
    }

    public void whitespaceChars(int low, int hi) {
        if (low < 0) {
            low = 0;
        }
        if (hi >= this.ctype.length) {
            hi = this.ctype.length - 1;
        }
        while (low <= hi) {
            this.ctype[low++] = 1;
        }
    }

    public void ordinaryChars(int low, int hi) {
        if (low < 0) {
            low = 0;
        }
        if (hi >= this.ctype.length) {
            hi = this.ctype.length - 1;
        }
        while (low <= hi) {
            this.ctype[low++] = 0;
        }
    }

    public void ordinaryChar(int ch) {
        if (ch >= 0 && ch < this.ctype.length) {
            this.ctype[ch] = 0;
        }
    }

    public void quoteChar(int ch) {
        if (ch >= 0 && ch < this.ctype.length) {
            this.ctype[ch] = 8;
        }
    }

    public void parseNumbers() {
        int i = 48;
        while (i <= 57) {
            int n = i++;
            this.ctype[n] = (byte)(this.ctype[n] | 2);
        }
        this.ctype[46] = (byte)(this.ctype[46] | 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int read() {
        Object object = this.lock;
        synchronized (object) {
            if (this.buffer == null) {
                throw new NullPointerException();
            }
            if (this.pos < 0) {
                this.pos = 0;
            }
            if (this.pos >= this.bufferEnd) {
                if (this.pos == this.bufferEnd) {
                    ++this.pos;
                }
                return -1;
            }
            return this.buffer.charAt(this.pos++);
        }
    }

    public void skipToEol() {
        int c;
        while ((c = this.read()) != 13 && c != 10 && c != -1) {
        }
        --this.pos;
        this.peekc = Integer.MAX_VALUE;
    }

    public void skipToChar(char c) {
        int d;
        while ((d = this.read()) != c && d != -1) {
        }
        this.peekc = Integer.MAX_VALUE;
    }

    public void skipToStr(String s) {
        char c = '\u0000';
        while (c != '\uffffffff') {
            this.skipToChar(s.charAt(0));
            int i = 1;
            do {
                if (i != s.length()) continue;
                return;
            } while ((c = this.read()) == s.charAt(i++) && c != '\uffffffff');
            this.peekc = Integer.MAX_VALUE;
        }
    }

    public int nextToken() {
        int ctype;
        if (this.pushedBack) {
            this.pushedBack = false;
            return this.ttype;
        }
        byte[] ct = this.ctype;
        this.sval = null;
        this.startOffset = 0;
        this.endOffset = 0;
        int c = this.peekc;
        if (c < 0) {
            c = Integer.MAX_VALUE;
        }
        if (c == Integer.MAX_VALUE && (c = this.read()) < 0) {
            this.ttype = -1;
            return -1;
        }
        this.ttype = c;
        this.peekc = Integer.MAX_VALUE;
        int n = ctype = c < 256 ? ct[c] : 4;
        if (this.isWhiteSpace(c)) {
            this.startOffset = this.pos - 1;
            while ((c = this.read()) >= 0) {
                int n2 = ctype = c < 256 ? ct[c] : 4;
                if (this.isWhiteSpace(c)) continue;
            }
            this.peekc = c;
            this.endOffset = this.pos - 1;
            this.ttype = -6;
            return -6;
        }
        if ((ctype & 2) != 0) {
            this.startOffset = this.pos - 1;
            if (this.hexPrefix != null) {
                for (int i = 0; i < this.hexPrefix.length() && c == this.hexPrefix.charAt(i); ++i) {
                    c = this.read();
                }
            }
            while ((c = this.read()) >= 0) {
                int n3 = ctype = c < 256 ? ct[c] : 4;
                if ((48 <= c && c <= 57 || c == 46 || (ctype & 0x10) != 0) && c != -1) continue;
            }
            this.peekc = c;
            this.endOffset = this.pos - 1;
            this.ttype = -2;
            return -2;
        }
        if ((ctype & 4) != 0) {
            int i = 0;
            do {
                if (i >= this.buf.length) {
                    char[] nb = new char[this.buf.length * 2];
                    System.arraycopy(this.buf, 0, nb, 0, this.buf.length);
                    this.buf = nb;
                }
                this.buf[i++] = (char)c;
                c = this.read();
                int n4 = c < 0 ? 1 : (ctype = c < 256 ? ct[c] : 4);
                if (c != 45) continue;
                ctype = 4;
            } while ((ctype & 6) != 0);
            this.peekc = c;
            this.startOffset = this.pos - i - 1;
            this.endOffset = this.pos - 1;
            this.sval = String.copyValueOf(this.buf, 0, i);
            if (this.myIgnoreCase) {
                this.sval = this.sval.toLowerCase();
            }
            this.ttype = -3;
            return -3;
        }
        if ((ctype & 8) != 0) {
            int prev;
            this.startOffset = this.pos - 1;
            this.ttype = c;
            int d = -1;
            do {
                prev = d;
            } while (((d = this.read()) != this.ttype || prev == 92) && d != 13 && d != 10 && d != -1);
            this.endOffset = d == this.ttype ? this.pos : this.pos - 1;
            this.peekc = d != this.ttype ? d : Integer.MAX_VALUE;
            this.ttype = -5;
            return -5;
        }
        this.startOffset = this.pos - 1;
        this.endOffset = this.pos;
        this.ttype = c;
        return this.ttype;
    }

    private boolean isWhiteSpace(int c) {
        return c == 32 || c == 9 || c == 10;
    }

    public void pushBack() {
        if (this.ttype != -4) {
            this.pushedBack = true;
        }
    }

    public int getPos() {
        if (this.pos > this.bufferEnd) {
            return this.bufferEnd;
        }
        return this.pos;
    }

    public void setHexPrefix(String hexPrefix) {
        int c;
        this.hexPrefix = hexPrefix;
        for (c = 97; c <= 102; c = (int)((char)(c + 1))) {
            int n = c;
            this.ctype[n] = (byte)(this.ctype[n] | 0x10);
        }
        for (c = 65; c <= 70; c = (int)((char)(c + 1))) {
            int n = c;
            this.ctype[n] = (byte)(this.ctype[n] | 0x10);
        }
    }

    public void setNumPostifxChars(String numPostfixChars) {
        if (numPostfixChars == null) {
            return;
        }
        for (int i = 0; i < numPostfixChars.length(); ++i) {
            char ch = numPostfixChars.charAt(i);
            if (ch < '\u0000' || ch >= this.ctype.length) continue;
            char c = ch;
            this.ctype[c] = (byte)(this.ctype[c] | 0x10);
        }
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.myIgnoreCase = ignoreCase;
    }

    public boolean matchString(String s, int from) {
        for (int i = from; i < s.length(); ++i) {
            int c = this.peekc;
            if (this.peekc == Integer.MAX_VALUE) {
                c = this.read();
            }
            if (c != s.charAt(i)) {
                this.peekc = c;
                return false;
            }
            this.peekc = Integer.MAX_VALUE;
        }
        return true;
    }
}

