/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.hierarchy.type;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.ide.hierarchy.HierarchyBrowser;
import com.intellij.ide.hierarchy.HierarchyProvider;
import com.intellij.ide.hierarchy.TypeHierarchyBrowserBase;
import com.intellij.ide.hierarchy.type.TypeHierarchyBrowser;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;

public class JavaTypeHierarchyProvider
implements HierarchyProvider {
    public PsiElement getTarget(DataContext dataContext) {
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return null;
        }
        Editor editor = (Editor)PlatformDataKeys.EDITOR.getData(dataContext);
        if (editor != null) {
            PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
            if (file == null) {
                return null;
            }
            PsiElement targetElement = TargetElementUtil.findTargetElement(editor, 3);
            if (targetElement instanceof PsiClass) {
                return targetElement;
            }
            int offset = editor.getCaretModel().getOffset();
            for (PsiElement element = file.findElementAt(offset); element != null; element = element.getParent()) {
                if (element instanceof PsiFile) {
                    if (!(element instanceof PsiClassOwner)) {
                        return null;
                    }
                    PsiClass[] classes = ((PsiClassOwner)element).getClasses();
                    return classes.length == 1 ? classes[0] : null;
                }
                if (!(element instanceof PsiClass) || element instanceof PsiAnonymousClass) continue;
                return element;
            }
            return null;
        }
        PsiElement element = (PsiElement)LangDataKeys.PSI_ELEMENT.getData(dataContext);
        return element instanceof PsiClass ? (PsiClass)element : null;
    }

    public HierarchyBrowser createHierarchyBrowser(PsiElement target) {
        return new TypeHierarchyBrowser(target.getProject(), (PsiClass)target);
    }

    public void browserActivated(HierarchyBrowser hierarchyBrowser) {
        TypeHierarchyBrowser browser = (TypeHierarchyBrowser)hierarchyBrowser;
        String typeName = browser.isInterface() ? TypeHierarchyBrowserBase.SUBTYPES_HIERARCHY_TYPE : TypeHierarchyBrowserBase.TYPE_HIERARCHY_TYPE;
        browser.changeView(typeName);
    }
}

