/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates.impl;

import com.intellij.ide.fileTemplates.impl.FileTemplateTokenType;
import com.intellij.lexer.FlexLexer;
import com.intellij.psi.tree.IElementType;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

class FileTemplateTextLexer
implements FlexLexer {
    private static final int ZZ_BUFFERSIZE = 16384;
    public static final int YYINITIAL = 0;
    private static final String ZZ_CMAP_PACKED = "#\u0000\u0001\u0006\u0001\u0003\u000b\u0000\n\u0002\u0007\u0000\u001a\u0001\u0004\u0000\u0001\u0001\u0001\u0000\u001a\u0001\u0001\u0004\u0001\u0000\u0001\u0005\uff82\u0000";
    private static final char[] ZZ_CMAP = FileTemplateTextLexer.zzUnpackCMap("#\u0000\u0001\u0006\u0001\u0003\u000b\u0000\n\u0002\u0007\u0000\u001a\u0001\u0004\u0000\u0001\u0001\u0001\u0000\u001a\u0001\u0001\u0004\u0001\u0000\u0001\u0005\uff82\u0000");
    private static final int[] ZZ_ACTION = FileTemplateTextLexer.zzUnpackAction();
    private static final String ZZ_ACTION_PACKED_0 = "\u0001\u0000\u0003\u0001\u0001\u0002\u0001\u0000\u0001\u0003\u0001\u0000\u0001\u0002";
    private static final int[] ZZ_ROWMAP = FileTemplateTextLexer.zzUnpackRowMap();
    private static final String ZZ_ROWMAP_PACKED_0 = "\u0000\u0000\u0000\u0007\u0000\u000e\u0000\u0015\u0000\u001c\u0000#\u0000\u0015\u0000*\u0000\u0007";
    private static final int[] ZZ_TRANS = FileTemplateTextLexer.zzUnpackTrans();
    private static final String ZZ_TRANS_PACKED_0 = "\u0003\u0002\u0001\u0003\u0002\u0002\u0001\u0004\b\u0000\u0002\u0005\u0001\u0000\u0001\u0006\u0003\u0000\u0001\u0007\u0006\u0000\u0002\u0005\u0005\u0000\u0002\b\u0005\u0000\u0002\b\u0002\u0000\u0001\t\u0001\u0000";
    private static final int ZZ_UNKNOWN_ERROR = 0;
    private static final int ZZ_NO_MATCH = 1;
    private static final int ZZ_PUSHBACK_2BIG = 2;
    private static final char[] EMPTY_BUFFER = new char[0];
    private static final int YYEOF = -1;
    private static Reader zzReader = null;
    private static final String[] ZZ_ERROR_MSG = new String[]{"Unkown internal scanner error", "Error: could not match input", "Error: pushback value was too large"};
    private static final int[] ZZ_ATTRIBUTE = FileTemplateTextLexer.zzUnpackAttribute();
    private static final String ZZ_ATTRIBUTE_PACKED_0 = "\u0001\u0000\u0001\t\u0003\u0001\u0001\u0000\u0001\u0001\u0001\u0000\u0001\t";
    private int zzState;
    private int zzLexicalState = 0;
    private CharSequence zzBuffer = "";
    private int zzMarkedPos;
    private int zzPushbackPos;
    private int zzCurrentPos;
    private int zzStartRead;
    private int zzEndRead;
    private final boolean zzAtBOL = true;
    private boolean zzAtEOF;
    private boolean zzEOFDone;

    private static int[] zzUnpackAction() {
        int[] result = new int[9];
        int offset = 0;
        offset = FileTemplateTextLexer.zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAction(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackRowMap() {
        int[] result = new int[9];
        int offset = 0;
        offset = FileTemplateTextLexer.zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackRowMap(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int high = packed.charAt(i++) << 16;
            result[j++] = high | packed.charAt(i++);
        }
        return j;
    }

    private static int[] zzUnpackTrans() {
        int[] result = new int[49];
        int offset = 0;
        offset = FileTemplateTextLexer.zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackTrans(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            int value = packed.charAt(i++);
            do {
                result[j++] = --value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackAttribute() {
        int[] result = new int[9];
        int offset = 0;
        offset = FileTemplateTextLexer.zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAttribute(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    public FileTemplateTextLexer() {
        this((Reader)null);
    }

    FileTemplateTextLexer(Reader in) {
        zzReader = in;
    }

    FileTemplateTextLexer(InputStream in) {
        this(new InputStreamReader(in));
    }

    private static char[] zzUnpackCMap(String packed) {
        char[] map = new char[65536];
        int i = 0;
        int j = 0;
        while (i < 30) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                map[j++] = value;
            } while (--count > 0);
        }
        return map;
    }

    public final int getTokenStart() {
        return this.zzStartRead - this.zzPushbackPos;
    }

    public final int getTokenEnd() {
        return this.getTokenStart() + this.yylength();
    }

    public void reset(CharSequence buffer, int start, int end, int initialState) {
        this.zzBuffer = buffer;
        this.zzMarkedPos = this.zzStartRead = start;
        this.zzCurrentPos = this.zzStartRead;
        this.zzPushbackPos = 0;
        this.zzAtEOF = false;
        this.zzEndRead = end;
        this.yybegin(initialState);
    }

    public void reset(CharSequence buffer, int initialState) {
        this.reset(buffer, 0, buffer.length(), initialState);
    }

    private boolean zzRefill() throws IOException {
        return true;
    }

    public final int yystate() {
        return this.zzLexicalState;
    }

    public final void yybegin(int newState) {
        this.zzLexicalState = newState;
    }

    public final CharSequence yytext() {
        return this.zzBuffer.subSequence(this.zzStartRead, this.zzMarkedPos);
    }

    public final char yycharat(int pos) {
        return this.zzBuffer.charAt(this.zzStartRead + pos);
    }

    public final int yylength() {
        return this.zzMarkedPos - this.zzStartRead;
    }

    private void zzScanError(int errorCode) {
        String message;
        try {
            message = ZZ_ERROR_MSG[errorCode];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            message = ZZ_ERROR_MSG[0];
        }
        throw new Error(message);
    }

    public void yypushback(int number) {
        if (number > this.yylength()) {
            this.zzScanError(2);
        }
        this.zzMarkedPos -= number;
    }

    private void zzDoEOF() {
        if (!this.zzEOFDone) {
            this.zzEOFDone = true;
        }
    }

    public IElementType advance() throws IOException {
        int zzEndReadL = this.zzEndRead;
        CharSequence zzBufferL = this.zzBuffer;
        char[] zzCMapL = ZZ_CMAP;
        int[] zzTransL = ZZ_TRANS;
        int[] zzRowMapL = ZZ_ROWMAP;
        int[] zzAttrL = ZZ_ATTRIBUTE;
        block8: while (true) {
            int zzInput;
            int zzMarkedPosL = this.zzMarkedPos;
            int zzAction = -1;
            this.zzCurrentPos = this.zzStartRead = zzMarkedPosL;
            int zzCurrentPosL = this.zzStartRead;
            this.zzState = this.zzLexicalState;
            while (true) {
                if (zzCurrentPosL < zzEndReadL) {
                    zzInput = zzBufferL.charAt(zzCurrentPosL++);
                } else {
                    if (this.zzAtEOF) {
                        zzInput = -1;
                        break;
                    }
                    this.zzCurrentPos = zzCurrentPosL;
                    this.zzMarkedPos = zzMarkedPosL;
                    boolean eof = this.zzRefill();
                    zzCurrentPosL = this.zzCurrentPos;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    zzEndReadL = this.zzEndRead;
                    if (eof) {
                        zzInput = -1;
                        break;
                    }
                    zzInput = zzBufferL.charAt(zzCurrentPosL++);
                }
                int zzNext = zzTransL[zzRowMapL[this.zzState] + zzCMapL[zzInput]];
                if (zzNext == -1) break;
                this.zzState = zzNext;
                int zzAttributes = zzAttrL[this.zzState];
                if ((zzAttributes & 1) != 1) continue;
                zzAction = this.zzState;
                zzMarkedPosL = zzCurrentPosL;
                if ((zzAttributes & 8) == 8) break;
            }
            this.zzMarkedPos = zzMarkedPosL;
            switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
                case 2: {
                    return FileTemplateTokenType.MACRO;
                }
                case 4: {
                    continue block8;
                }
                case 1: {
                    return FileTemplateTokenType.TEXT;
                }
                case 5: {
                    continue block8;
                }
                case 3: {
                    return FileTemplateTokenType.DIRECTIVE;
                }
                case 6: {
                    continue block8;
                }
            }
            if (zzInput == -1 && this.zzStartRead == this.zzCurrentPos) {
                this.zzAtEOF = true;
                this.zzDoEOF();
                return null;
            }
            this.zzScanError(1);
        }
    }
}

