/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView;

import com.intellij.ide.favoritesTreeView.AbstractUrlFavoriteAdapter;
import com.intellij.ide.favoritesTreeView.FavoriteNodeProvider;
import com.intellij.ide.favoritesTreeView.actions.AddToFavoritesAction;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.AbstractUrl;
import com.intellij.ide.projectView.impl.DirectoryUrl;
import com.intellij.ide.projectView.impl.LibraryModuleGroupUrl;
import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.ide.projectView.impl.ModuleGroupUrl;
import com.intellij.ide.projectView.impl.ModuleUrl;
import com.intellij.ide.projectView.impl.NamedLibraryUrl;
import com.intellij.ide.projectView.impl.PsiFileUrl;
import com.intellij.ide.projectView.impl.nodes.LibraryGroupElement;
import com.intellij.ide.projectView.impl.nodes.NamedLibraryElement;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FavoritesManager
implements ProjectComponent,
JDOMExternalizable {
    private final Map<String, List<Pair<AbstractUrl, String>>> myName2FavoritesRoots = new LinkedHashMap<String, List<Pair<AbstractUrl, String>>>();
    private final Project myProject;
    private final List<FavoritesListener> myListeners = new ArrayList<FavoritesListener>();
    private final FavoritesListener fireListeners = new FavoritesListener(){

        @Override
        public void rootsChanged(String listName) {
            FavoritesListener[] listeners;
            for (FavoritesListener listener : listeners = FavoritesManager.this.myListeners.toArray(new FavoritesListener[FavoritesManager.this.myListeners.size()])) {
                listener.rootsChanged(listName);
            }
        }

        @Override
        public void listAdded(String listName) {
            FavoritesListener[] listeners;
            for (FavoritesListener listener : listeners = FavoritesManager.this.myListeners.toArray(new FavoritesListener[FavoritesManager.this.myListeners.size()])) {
                listener.listAdded(listName);
            }
        }

        @Override
        public void listRemoved(String listName) {
            FavoritesListener[] listeners;
            for (FavoritesListener listener : listeners = FavoritesManager.this.myListeners.toArray(new FavoritesListener[FavoritesManager.this.myListeners.size()])) {
                listener.listRemoved(listName);
            }
        }
    };
    @NonNls
    private static final String CLASS_NAME = "klass";
    @NonNls
    private static final String FAVORITES_ROOT = "favorite_root";
    @NonNls
    private static final String ELEMENT_FAVORITES_LIST = "favorites_list";
    @NonNls
    private static final String ATTRIBUTE_NAME = "name";
    private static final ArrayList<AbstractUrl> ourAbstractUrlProviders = new ArrayList();
    @NonNls
    private static final String ATTRIBUTE_TYPE = "type";
    @NonNls
    private static final String ATTRIBUTE_URL = "url";
    @NonNls
    private static final String ATTRIBUTE_MODULE = "module";

    public synchronized void addFavoritesListener(FavoritesListener listener) {
        this.myListeners.add(listener);
    }

    public synchronized void removeFavoritesListener(FavoritesListener listener) {
        this.myListeners.remove(listener);
    }

    public static FavoritesManager getInstance(Project project) {
        return (FavoritesManager)project.getComponent(FavoritesManager.class);
    }

    public FavoritesManager(Project project) {
        this.myProject = project;
    }

    @NotNull
    public String[] getAvailableFavoritesLists() {
        Set<String> keys = this.myName2FavoritesRoots.keySet();
        String[] stringArray = ArrayUtil.toStringArray(keys);
        if (stringArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/favoritesTreeView/FavoritesManager.getAvailableFavoritesLists must not return null");
        }
        return stringArray;
    }

    public synchronized void createNewList(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/favoritesTreeView/FavoritesManager.createNewList must not be null");
        }
        this.myName2FavoritesRoots.put(name, new ArrayList());
        this.fireListeners.listAdded(name);
    }

    public synchronized boolean removeFavoritesList(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/favoritesTreeView/FavoritesManager.removeFavoritesList must not be null");
        }
        if (name.equals(this.myProject.getName())) {
            return false;
        }
        boolean result = this.myName2FavoritesRoots.remove(name) != null;
        this.fireListeners.listRemoved(name);
        return result;
    }

    public List<Pair<AbstractUrl, String>> getFavoritesListRootUrls(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/favoritesTreeView/FavoritesManager.getFavoritesListRootUrls must not be null");
        }
        return this.myName2FavoritesRoots.get(name);
    }

    public synchronized boolean addRoots(@NotNull String name, Module moduleContext, @NotNull Object elements) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/favoritesTreeView/FavoritesManager.addRoots must not be null");
        }
        if (elements == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/ide/favoritesTreeView/FavoritesManager.addRoots must not be null");
        }
        Collection<AbstractTreeNode> nodes = AddToFavoritesAction.createNodes(this.myProject, moduleContext, elements, true, ViewSettings.DEFAULT);
        return !nodes.isEmpty() && this.addRoots(name, nodes);
    }

    public boolean addRoots(String name, Collection<AbstractTreeNode> nodes) {
        List<Pair<AbstractUrl, String>> list = this.getFavoritesListRootUrls(name);
        for (AbstractTreeNode node : nodes) {
            String className = node.getClass().getName();
            Object value = node.getValue();
            AbstractUrl url = FavoritesManager.createUrlByElement(value, this.myProject);
            if (url == null) continue;
            list.add((Pair<AbstractUrl, String>)Pair.create((Object)url, (Object)className));
        }
        this.fireListeners.rootsChanged(name);
        return true;
    }

    public synchronized boolean removeRoot(@NotNull String name, @NotNull Object element) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/favoritesTreeView/FavoritesManager.removeRoot must not be null");
        }
        if (element == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ide/favoritesTreeView/FavoritesManager.removeRoot must not be null");
        }
        AbstractUrl url = FavoritesManager.createUrlByElement(element, this.myProject);
        if (url == null) {
            return false;
        }
        List<Pair<AbstractUrl, String>> list = this.getFavoritesListRootUrls(name);
        for (Pair<AbstractUrl, String> pair : list) {
            if (!url.equals(pair.getFirst())) continue;
            list.remove(pair);
            break;
        }
        this.fireListeners.rootsChanged(name);
        return true;
    }

    public synchronized boolean renameFavoritesList(@NotNull String oldName, @NotNull String newName) {
        if (oldName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/favoritesTreeView/FavoritesManager.renameFavoritesList must not be null");
        }
        if (newName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ide/favoritesTreeView/FavoritesManager.renameFavoritesList must not be null");
        }
        List<Pair<AbstractUrl, String>> list = this.myName2FavoritesRoots.remove(oldName);
        if (list != null && newName.length() > 0) {
            this.myName2FavoritesRoots.put(newName, list);
            this.fireListeners.listRemoved(oldName);
            this.fireListeners.listAdded(newName);
            return true;
        }
        return false;
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    public void projectOpened() {
        StartupManager.getInstance((Project)this.myProject).registerPostStartupActivity((Runnable)new DumbAwareRunnable(){

            public void run() {
                if (FavoritesManager.this.myName2FavoritesRoots.isEmpty()) {
                    String name = FavoritesManager.this.myProject.getName();
                    FavoritesManager.this.createNewList(name);
                }
                MyRootsChangeAdapter myPsiTreeChangeAdapter = new MyRootsChangeAdapter();
                PsiManager.getInstance((Project)FavoritesManager.this.myProject).addPsiTreeChangeListener((PsiTreeChangeListener)myPsiTreeChangeAdapter, (Disposable)FavoritesManager.this.myProject);
            }
        });
    }

    public void projectClosed() {
    }

    @NotNull
    public String getComponentName() {
        if ("FavoritesManager" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/favoritesTreeView/FavoritesManager.getComponentName must not return null");
        }
        return "FavoritesManager";
    }

    public void readExternal(Element element) throws InvalidDataException {
        this.myName2FavoritesRoots.clear();
        for (Object list : element.getChildren(ELEMENT_FAVORITES_LIST)) {
            String name = ((Element)list).getAttributeValue(ATTRIBUTE_NAME);
            List<Pair<AbstractUrl, String>> roots = FavoritesManager.readRoots((Element)list, this.myProject);
            this.myName2FavoritesRoots.put(name, roots);
        }
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
    }

    private static List<Pair<AbstractUrl, String>> readRoots(Element list, Project project) {
        ArrayList<Pair<AbstractUrl, String>> result = new ArrayList<Pair<AbstractUrl, String>>();
        for (Object favorite : list.getChildren(FAVORITES_ROOT)) {
            String className = ((Element)favorite).getAttributeValue(CLASS_NAME);
            AbstractUrl abstractUrl = FavoritesManager.readUrlFromElement((Element)favorite, project);
            if (abstractUrl == null) continue;
            result.add((Pair<AbstractUrl, String>)Pair.create((Object)abstractUrl, (Object)className));
        }
        return result;
    }

    @Nullable
    private static AbstractUrl readUrlFromElement(Element element, Project project) {
        String type = element.getAttributeValue(ATTRIBUTE_TYPE);
        String urlValue = element.getAttributeValue(ATTRIBUTE_URL);
        String moduleName = element.getAttributeValue(ATTRIBUTE_MODULE);
        for (FavoriteNodeProvider nodeProvider : (FavoriteNodeProvider[])Extensions.getExtensions((ExtensionPointName)FavoriteNodeProvider.EP_NAME, (AreaInstance)project)) {
            if (!nodeProvider.getFavoriteTypeId().equals(type)) continue;
            return new AbstractUrlFavoriteAdapter(urlValue, moduleName, nodeProvider);
        }
        for (AbstractUrl urlProvider : ourAbstractUrlProviders) {
            AbstractUrl url = urlProvider.createUrl(type, moduleName, urlValue);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    public void writeExternal(Element element) throws WriteExternalException {
        for (String name : this.myName2FavoritesRoots.keySet()) {
            Element list = new Element(ELEMENT_FAVORITES_LIST);
            list.setAttribute(ATTRIBUTE_NAME, name);
            FavoritesManager.writeRoots(list, this.myName2FavoritesRoots.get(name));
            element.addContent(list);
        }
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
    }

    @Nullable
    private static AbstractUrl createUrlByElement(Object element, Project project) {
        if (element instanceof SmartPsiElementPointer) {
            element = ((SmartPsiElementPointer)element).getElement();
        }
        for (FavoriteNodeProvider nodeProvider : (FavoriteNodeProvider[])Extensions.getExtensions((ExtensionPointName)FavoriteNodeProvider.EP_NAME, (AreaInstance)project)) {
            String url = nodeProvider.getElementUrl(element);
            if (url == null) continue;
            return new AbstractUrlFavoriteAdapter(url, nodeProvider.getElementModuleName(element), nodeProvider);
        }
        for (AbstractUrl urlProvider : ourAbstractUrlProviders) {
            AbstractUrl url = urlProvider.createUrlByElement(element);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    private static void writeRoots(Element element, List<Pair<AbstractUrl, String>> roots) {
        for (Pair<AbstractUrl, String> root : roots) {
            AbstractUrl url = (AbstractUrl)root.getFirst();
            if (url == null) continue;
            Element list = new Element(FAVORITES_ROOT);
            url.write(list);
            list.setAttribute(CLASS_NAME, (String)root.getSecond());
            element.addContent(list);
        }
    }

    public boolean contains(@NotNull String name, final @NotNull VirtualFile vFile) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/favoritesTreeView/FavoritesManager.contains must not be null");
        }
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ide/favoritesTreeView/FavoritesManager.contains must not be null");
        }
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        final HashSet find = new HashSet();
        ContentIterator contentIterator = new ContentIterator(){

            public boolean processFile(VirtualFile fileOrDir) {
                if (fileOrDir != null && fileOrDir.getPath().equals(vFile.getPath())) {
                    find.add(Boolean.TRUE);
                }
                return true;
            }
        };
        List<Pair<AbstractUrl, String>> urls = this.getFavoritesListRootUrls(name);
        for (Pair<AbstractUrl, String> pair : urls) {
            NamedLibraryElement namedLibraryElement;
            Object[] files;
            VirtualFile virtualFile;
            Object[] path;
            AbstractUrl abstractUrl = (AbstractUrl)pair.getFirst();
            if (abstractUrl == null || (path = abstractUrl.createPath(this.myProject)) == null || path.length < 1 || path[0] == null) continue;
            Object element = path[path.length - 1];
            if (element instanceof SmartPsiElementPointer) {
                virtualFile = PsiUtilBase.getVirtualFile((PsiElement)((SmartPsiElementPointer)element).getElement());
                if (virtualFile == null) continue;
                if (vFile.getPath().equals(virtualFile.getPath())) {
                    return true;
                }
                if (!virtualFile.isDirectory()) continue;
                projectFileIndex.iterateContentUnderDirectory(virtualFile, contentIterator);
            }
            if (element instanceof PsiElement) {
                virtualFile = PsiUtilBase.getVirtualFile((PsiElement)((PsiElement)element));
                if (virtualFile == null) continue;
                if (vFile.getPath().equals(virtualFile.getPath())) {
                    return true;
                }
                if (!virtualFile.isDirectory()) continue;
                projectFileIndex.iterateContentUnderDirectory(virtualFile, contentIterator);
            }
            if (element instanceof Module) {
                ModuleRootManager.getInstance((Module)((Module)element)).getFileIndex().iterateContent(contentIterator);
            }
            if (element instanceof LibraryGroupElement) {
                boolean inLibrary;
                boolean bl = inLibrary = ModuleRootManager.getInstance((Module)((LibraryGroupElement)element).getModule()).getFileIndex().isInContent(vFile) && projectFileIndex.isInLibraryClasses(vFile);
                if (inLibrary) {
                    return true;
                }
            }
            if (element instanceof NamedLibraryElement && (files = (namedLibraryElement = (NamedLibraryElement)element).getOrderEntry().getFiles(OrderRootType.CLASSES)) != null && ArrayUtil.find((Object[])files, (Object)vFile) > -1) {
                return true;
            }
            if (element instanceof ModuleGroup) {
                ModuleGroup group = (ModuleGroup)element;
                Collection<Module> modules = group.modulesInGroup(this.myProject, true);
                for (Module module : modules) {
                    ModuleRootManager.getInstance((Module)module).getFileIndex().iterateContent(contentIterator);
                }
            }
            for (FavoriteNodeProvider provider : (FavoriteNodeProvider[])Extensions.getExtensions((ExtensionPointName)FavoriteNodeProvider.EP_NAME, (AreaInstance)this.myProject)) {
                if (!provider.elementContainsFile(element, vFile)) continue;
                return true;
            }
            if (find.isEmpty()) continue;
            return true;
        }
        return false;
    }

    static {
        ourAbstractUrlProviders.add(new ModuleUrl(null, null));
        ourAbstractUrlProviders.add(new DirectoryUrl(null, null));
        ourAbstractUrlProviders.add(new ModuleGroupUrl(null));
        ourAbstractUrlProviders.add(new PsiFileUrl(null, null));
        ourAbstractUrlProviders.add(new LibraryModuleGroupUrl(null));
        ourAbstractUrlProviders.add(new NamedLibraryUrl(null, null));
    }

    private class MyRootsChangeAdapter
    extends PsiTreeChangeAdapter {
        private MyRootsChangeAdapter() {
        }

        public void beforeChildMovement(PsiTreeChangeEvent event) {
            PsiElement oldParent = event.getOldParent();
            PsiElement newParent = event.getNewParent();
            PsiElement child = event.getChild();
            if (newParent instanceof PsiDirectory) {
                Module module = ModuleUtil.findModuleForPsiElement((PsiElement)newParent);
                if (module == null) {
                    return;
                }
                AbstractUrl childUrl = null;
                if (child instanceof PsiFile) {
                    childUrl = new PsiFileUrl(((PsiDirectory)newParent).getVirtualFile().getUrl() + "/" + ((PsiFile)child).getName(), module.getName());
                } else if (child instanceof PsiDirectory) {
                    childUrl = new DirectoryUrl(((PsiDirectory)newParent).getVirtualFile().getUrl() + "/" + ((PsiDirectory)child).getName(), module.getName());
                }
                for (String listName : FavoritesManager.this.myName2FavoritesRoots.keySet()) {
                    List roots = (List)FavoritesManager.this.myName2FavoritesRoots.get(listName);
                    ArrayList<Pair> newRoots = new ArrayList<Pair>();
                    for (Pair root : roots) {
                        Object[] path = ((AbstractUrl)root.first).createPath(FavoritesManager.this.myProject);
                        if (path == null || path.length < 1 || path[0] == null) continue;
                        Object element = path[path.length - 1];
                        if (element == child && childUrl != null) {
                            newRoots.add(Pair.create((Object)childUrl, (Object)root.second));
                            continue;
                        }
                        if (element == oldParent) {
                            newRoots.add(Pair.create((Object)((AbstractUrl)root.first).createUrlByElement(newParent), (Object)root.second));
                        }
                        newRoots.add(root);
                    }
                    FavoritesManager.this.myName2FavoritesRoots.put(listName, newRoots);
                }
            }
        }

        public void beforePropertyChange(PsiTreeChangeEvent event) {
            PsiElement psiElement;
            if ((event.getPropertyName().equals("fileName") || event.getPropertyName().equals("directoryName")) && ((psiElement = event.getChild()) instanceof PsiFile || psiElement instanceof PsiDirectory)) {
                Module module = ModuleUtil.findModuleForPsiElement((PsiElement)psiElement);
                if (module == null) {
                    return;
                }
                String url = ((PsiDirectory)psiElement.getParent()).getVirtualFile().getUrl() + "/" + event.getNewValue();
                AbstractUrl childUrl = psiElement instanceof PsiFile ? new PsiFileUrl(url, module.getName()) : new DirectoryUrl(url, module.getName());
                for (String listName : FavoritesManager.this.myName2FavoritesRoots.keySet()) {
                    List roots = (List)FavoritesManager.this.myName2FavoritesRoots.get(listName);
                    ArrayList<Pair> newRoots = new ArrayList<Pair>();
                    for (Pair root : roots) {
                        Object[] path = ((AbstractUrl)root.first).createPath(FavoritesManager.this.myProject);
                        if (path == null || path.length < 1 || path[0] == null) continue;
                        Object element = path[path.length - 1];
                        if (element == psiElement && psiElement instanceof PsiFile) {
                            newRoots.add(Pair.create((Object)childUrl, (Object)root.second));
                            continue;
                        }
                        newRoots.add(root);
                    }
                    FavoritesManager.this.myName2FavoritesRoots.put(listName, newRoots);
                }
            }
        }
    }

    public static interface FavoritesListener {
        public void rootsChanged(String var1);

        public void listAdded(String var1);

        public void listRemoved(String var1);
    }
}

