/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers.firefox;

import com.intellij.ide.browsers.firefox.FirefoxProfile;
import com.intellij.ide.browsers.firefox.FirefoxSettings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SystemProperties;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FirefoxUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.browsers.firefox.FirefoxUtil");
    @NonNls
    public static final String PROFILES_INI_FILE = "profiles.ini";

    private FirefoxUtil() {
    }

    @Nullable
    public static File getDefaultProfileIniPath() {
        File[] roots;
        for (File profilesDir : roots = FirefoxUtil.getProfilesDirs()) {
            File profilesFile = new File(profilesDir, PROFILES_INI_FILE);
            if (!profilesFile.isFile()) continue;
            return profilesFile;
        }
        return null;
    }

    @Nullable
    public static File getFirefoxExtensionsDir(FirefoxSettings settings) {
        File profilesFile = settings.getProfilesIniFile();
        if (profilesFile != null && profilesFile.exists()) {
            File profileDir;
            File dir;
            List<FirefoxProfile> profiles = FirefoxUtil.computeProfiles(profilesFile);
            FirefoxProfile profile = FirefoxUtil.findProfileByNameOrDefault(settings.getProfile(), profiles);
            if (profile != null && (dir = new File(profileDir = profile.getProfileDirectory(profilesFile), "extensions")).isDirectory()) {
                return dir;
            }
        }
        return null;
    }

    @Nullable
    public static FirefoxProfile findProfileByNameOrDefault(@Nullable String name, List<FirefoxProfile> profiles) {
        for (FirefoxProfile profile : profiles) {
            if (!profile.getName().equals(name)) continue;
            return profile;
        }
        return FirefoxUtil.getDefaultProfile(profiles);
    }

    @Nullable
    public static FirefoxProfile getDefaultProfile(List<FirefoxProfile> profiles) {
        if (profiles.isEmpty()) {
            return null;
        }
        for (FirefoxProfile profile : profiles) {
            if (!profile.isDefault()) continue;
            return profile;
        }
        return profiles.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @NotNull
    public static List<FirefoxProfile> computeProfiles(File profilesFile) {
        if (!profilesFile.isFile()) {
            v0 /* !! */  = Collections.emptyList();
            if (v0 /* !! */  == null) lbl-1000:
            // 3 sources

            {
                throw new IllegalStateException("@NotNull method com/intellij/ide/browsers/firefox/FirefoxUtil.computeProfiles must not return null");
            }
            return v0 /* !! */ ;
        }
        reader = new BufferedReader(new FileReader(profilesFile));
        profiles = new ArrayList<FirefoxProfile>();
        insideProfile = false;
        currentName = null;
        currentPath = null;
        isDefault = false;
        isRelative = false;
        eof = false;
        while (!eof) {
            line = reader.readLine();
            if (line == null) {
                eof = true;
                line = "[]";
            } else {
                line = line.trim();
            }
            if (line.startsWith("[") && line.endsWith("]")) {
                if (!StringUtil.isEmpty(currentPath) && !StringUtil.isEmpty(currentName)) {
                    profiles.add(new FirefoxProfile(currentName, currentPath, isDefault, isRelative));
                }
                currentName = null;
                currentPath = null;
                isDefault = false;
                isRelative = false;
                insideProfile = StringUtil.startsWithIgnoreCase((String)line, (String)"[Profile");
                continue;
            }
            i = line.indexOf(61);
            if (i == -1 || !insideProfile) continue;
            name = line.substring(0, i).trim();
            value = line.substring(i + 1).trim();
            if (name.equalsIgnoreCase("path")) {
                currentPath = value;
                continue;
            }
            if (name.equalsIgnoreCase("name")) {
                currentName = value;
                continue;
            }
            if (name.equalsIgnoreCase("default") && value.equals("1")) {
                isDefault = true;
                continue;
            }
            if (!name.equalsIgnoreCase("isrelative") || !value.equals("1")) continue;
            isRelative = true;
        }
        var9_10 = profiles;
        reader.close();
        v0 /* !! */  = var9_10;
        if (v0 /* !! */  == null) ** GOTO lbl-1000
        return v0 /* !! */ ;
        {
            catch (Throwable var13_14) {
                try {
                    reader.close();
                    throw var13_14;
                }
                catch (IOException e) {
                    FirefoxUtil.LOG.info((Throwable)e);
                    v0 /* !! */  = Collections.emptyList();
                    if (v0 /* !! */  != null) ** break;
                    ** continue;
                    return v0 /* !! */ ;
                }
            }
        }
    }

    private static File[] getProfilesDirs() {
        String userHome = SystemProperties.getUserHome();
        if (SystemInfo.isMac) {
            return new File[]{new File(userHome, "Library" + File.separator + "Mozilla" + File.separator + "Firefox"), new File(userHome, "Library" + File.separator + "Application Support" + File.separator + "Firefox")};
        }
        if (SystemInfo.isUnix) {
            return new File[]{new File(userHome, ".mozilla" + File.separator + "firefox")};
        }
        return new File[]{new File(userHome, "Application Data" + File.separator + "Mozilla" + File.separator + "Firefox")};
    }
}

