/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers;

import com.intellij.ide.BrowserUtil;
import com.intellij.ide.browsers.WebBrowserUrlProvider;
import com.intellij.ide.browsers.WebBrowserUrlProviders;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.xml.XmlBundle;

public class OpenFileInBrowserAction
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.browsers.OpenFileInBrowserAction");

    public void update(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        PsiFile file = (PsiFile)LangDataKeys.PSI_FILE.getData(dataContext);
        Presentation presentation = e.getPresentation();
        if (file != null) {
            presentation.setVisible(true);
            presentation.setText(XmlBundle.message((String)"action.OpenInBrowser.text", (Object[])new Object[0]));
            presentation.setDescription(XmlBundle.message((String)"action.open.file.in.browser.description", (Object[])new Object[0]));
            WebBrowserUrlProvider browserUrlProvider = WebBrowserUrlProviders.getProvider((PsiElement)file);
            presentation.setEnabled(browserUrlProvider != null);
            if (browserUrlProvider != null) {
                String description;
                String actionText = browserUrlProvider.getOpenInBrowserActionText(file);
                if (actionText != null) {
                    presentation.setText(actionText);
                }
                if ((description = browserUrlProvider.getOpenInBrowserActionDescription(file)) != null) {
                    presentation.setDescription(description);
                }
            }
            if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
                presentation.setVisible(presentation.isEnabled());
            }
        } else {
            presentation.setVisible(false);
            presentation.setEnabled(false);
        }
    }

    public void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        PsiFile psiFile = (PsiFile)LangDataKeys.PSI_FILE.getData(dataContext);
        LOG.assertTrue(psiFile != null);
        WebBrowserUrlProvider provider = WebBrowserUrlProviders.getProvider((PsiElement)psiFile);
        if (provider != null) {
            try {
                String url = provider.getUrl((PsiElement)psiFile, false);
                ApplicationManager.getApplication().saveAll();
                BrowserUtil.launchBrowser((String)url);
            }
            catch (WebBrowserUrlProvider.BrowserException e1) {
                Messages.showErrorDialog((String)e1.getMessage(), (String)XmlBundle.message((String)"browser.error", (Object[])new Object[0]));
            }
            catch (Exception e1) {
                LOG.error((Throwable)e1);
            }
        }
    }
}

