/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmarks.actions;

import com.intellij.ide.bookmarks.Bookmark;
import com.intellij.ide.bookmarks.BookmarkManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.FileColorManager;
import com.intellij.ui.ListUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.speedSearch.FilteringListModel;
import com.intellij.util.Alarm;
import com.intellij.util.Function;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.Nullable;

public class BookmarksAction
extends AnAction
implements DumbAware {
    private static final Color BORDER_COLOR = new Color(135, 135, 135);
    private final Alarm myPreviewUpdateAlarm = new Alarm();

    public void update(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        e.getPresentation().setEnabled(project != null);
    }

    public void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        final Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return;
        }
        final DefaultListModel model = BookmarksAction.buildModel(project);
        final JLabel pathLabel = new JLabel(" ");
        pathLabel.setHorizontalAlignment(4);
        Font font = pathLabel.getFont();
        pathLabel.setFont(font.deriveFont(10.0f));
        final JList list = new JList(model);
        final PreviewPanel previewPanel = new PreviewPanel(project);
        list.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            private String getTitle2Text(String fullText) {
                int labelWidth = pathLabel.getWidth();
                if (fullText == null || fullText.length() == 0) {
                    return " ";
                }
                while (pathLabel.getFontMetrics(pathLabel.getFont()).stringWidth(fullText) > labelWidth) {
                    int sep = fullText.indexOf(File.separatorChar, 4);
                    if (sep < 0) {
                        return fullText;
                    }
                    fullText = "..." + fullText.substring(sep);
                }
                return fullText;
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        this.updatePathLabel();
                    }
                });
            }

            private void updatePreviewPanel(final ItemWrapper wrapper) {
                BookmarksAction.this.myPreviewUpdateAlarm.cancelAllRequests();
                BookmarksAction.this.myPreviewUpdateAlarm.addRequest(new Runnable(){

                    @Override
                    public void run() {
                        previewPanel.updateWithItem(wrapper);
                    }
                }, 300);
            }

            private void updatePathLabel() {
                Object[] values = list.getSelectedValues();
                if (values != null && values.length == 1) {
                    ItemWrapper wrapper = (ItemWrapper)values[0];
                    pathLabel.setText(this.getTitle2Text(wrapper.footerText()));
                    this.updatePreviewPanel(wrapper);
                } else {
                    this.updatePreviewPanel(null);
                    pathLabel.setText(" ");
                }
            }
        });
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                IdeFocusManager.getInstance((Project)project).doWhenFocusSettlesDown(new Runnable(){

                    @Override
                    public void run() {
                        Object[] values = list.getSelectedValues();
                        if (values.length == 1) {
                            ((ItemWrapper)values[0]).execute(project);
                        } else {
                            for (Object value : values) {
                                if (!(value instanceof BookmarkItem)) continue;
                                ((BookmarkItem)value).execute(project);
                            }
                        }
                    }
                });
            }
        };
        if (list.getModel().getSize() == 0) {
            list.clearSelection();
        }
        list.setCellRenderer(new ItemRenderer(project));
        JPanel footerPanel = new JPanel(new BorderLayout()){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.setColor(BORDER_COLOR);
                g.drawLine(0, 0, this.getWidth(), 0);
            }
        };
        footerPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        footerPanel.add(pathLabel);
        DefaultActionGroup actions = new DefaultActionGroup();
        EditBookmarkDescriptionAction editDescriptionAction = new EditBookmarkDescriptionAction(project, list);
        actions.add((AnAction)editDescriptionAction);
        actions.add((AnAction)new DeleteBookmarkAction(project, list));
        actions.add((AnAction)new MoveBookmarkUpAction(project, list));
        actions.add((AnAction)new MoveBookmarkDownAction(project, list));
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("", (ActionGroup)actions, true);
        actionToolbar.setReservePlaceAutoPopupIcon(false);
        actionToolbar.setMinimumButtonSize(new Dimension(16, 16));
        JComponent toolBar = actionToolbar.getComponent();
        toolBar.setOpaque(false);
        final JBPopup popup = new PopupChooserBuilder(list).setTitle("Bookmarks").setMovable(true).setAutoselectOnMouseMove(false).setSettingButton((Component)toolBar).setSouthComponent((JComponent)footerPanel).setEastComponent((JComponent)previewPanel).setItemChoosenCallback(runnable).setFilteringEnabled((Function)new Function<Object, String>(){

            public String fun(Object o) {
                return ((ItemWrapper)o).speedSearchText();
            }
        }).createPopup();
        list.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    Object[] values;
                    int index = list.getSelectedIndex();
                    if (index == -1 || index >= list.getModel().getSize()) {
                        return;
                    }
                    for (Object value : values = list.getSelectedValues()) {
                        if (!(value instanceof BookmarkItem)) continue;
                        BookmarkItem item = (BookmarkItem)value;
                        model.removeElement(item);
                        if (model.getSize() > 0) {
                            if (model.getSize() == index) {
                                list.setSelectedIndex(model.getSize() - 1);
                            } else if (model.getSize() > index) {
                                list.setSelectedIndex(index);
                            }
                        } else {
                            list.clearSelection();
                        }
                        BookmarkManager.getInstance(project).removeBookmark(item.myBookmark);
                    }
                } else if (e.getModifiersEx() == 0) {
                    char mnemonic = e.getKeyChar();
                    final Bookmark bookmark = BookmarkManager.getInstance(project).findBookmarkForMnemonic(mnemonic);
                    if (bookmark != null) {
                        popup.cancel();
                        IdeFocusManager.getInstance((Project)project).doWhenFocusSettlesDown(new Runnable(){

                            @Override
                            public void run() {
                                bookmark.navigate();
                            }
                        });
                    }
                }
            }
        });
        editDescriptionAction.setPopup(popup);
        popup.showCenteredInCurrentWindow(project);
    }

    private static DefaultListModel buildModel(Project project) {
        DefaultListModel<BookmarkItem> model = new DefaultListModel<BookmarkItem>();
        for (Bookmark bookmark : BookmarkManager.getInstance(project).getValidBookmarks()) {
            model.addElement(new BookmarkItem(bookmark));
        }
        return model;
    }

    private static List<Bookmark> getSelectedBookmarks(JList list) {
        ArrayList<Bookmark> answer = new ArrayList<Bookmark>();
        for (Object value : list.getSelectedValues()) {
            if (!(value instanceof BookmarkItem)) {
                return Collections.emptyList();
            }
            answer.add(((BookmarkItem)value).myBookmark);
        }
        return answer;
    }

    private static boolean notFiltered(JList list) {
        if (!(list.getModel() instanceof FilteringListModel)) {
            return true;
        }
        FilteringListModel model = (FilteringListModel)list.getModel();
        return model.getOriginalModel().getSize() == model.getSize();
    }

    private static class MoveBookmarkDownAction
    extends AnAction {
        private final Project myProject;
        private final JList myList;

        private MoveBookmarkDownAction(Project project, JList list) {
            super("Down", "Move current bookmark down", IconLoader.getIcon((String)"/actions/nextOccurence.png"));
            this.myProject = project;
            this.myList = list;
            this.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(SystemInfo.isMac ? "meta DOWN" : "control DOWN")), list);
        }

        public void update(AnActionEvent e) {
            int modelSize = this.myList.getModel().getSize();
            if (modelSize == 0 || !BookmarksAction.notFiltered(this.myList)) {
                e.getPresentation().setEnabled(false);
            } else {
                int lastIndex = modelSize - 1;
                if (!(this.myList.getModel().getElementAt(lastIndex) instanceof BookmarkItem)) {
                    --lastIndex;
                }
                e.getPresentation().setEnabled(BookmarksAction.getSelectedBookmarks(this.myList).size() == 1 && this.myList.getSelectedIndex() < lastIndex);
            }
        }

        public void actionPerformed(AnActionEvent e) {
            ListUtil.moveSelectedItemsDown((JList)this.myList);
            BookmarkManager.getInstance(this.myProject).moveBookmarkDown((Bookmark)BookmarksAction.getSelectedBookmarks(this.myList).get(0));
        }
    }

    private static class MoveBookmarkUpAction
    extends AnAction {
        private final Project myProject;
        private final JList myList;

        private MoveBookmarkUpAction(Project project, JList list) {
            super("Up", "Move current bookmark up", IconLoader.getIcon((String)"/actions/previousOccurence.png"));
            this.myProject = project;
            this.myList = list;
            this.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(SystemInfo.isMac ? "meta UP" : "control UP")), list);
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(BookmarksAction.notFiltered(this.myList) && BookmarksAction.getSelectedBookmarks(this.myList).size() == 1 && this.myList.getSelectedIndex() > 0);
        }

        public void actionPerformed(AnActionEvent e) {
            ListUtil.moveSelectedItemsUp((JList)this.myList);
            BookmarkManager.getInstance(this.myProject).moveBookmarkUp((Bookmark)BookmarksAction.getSelectedBookmarks(this.myList).get(0));
        }
    }

    private static class DeleteBookmarkAction
    extends AnAction {
        private final Project myProject;
        private final JList myList;

        private DeleteBookmarkAction(Project project, JList list) {
            super("Delete", "Delete current bookmark", IconLoader.getIcon((String)"/general/remove.png"));
            this.myProject = project;
            this.myList = list;
            this.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke("DELETE")), list);
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(BookmarksAction.getSelectedBookmarks(this.myList).size() > 0);
        }

        public void actionPerformed(AnActionEvent e) {
            List bookmarks = BookmarksAction.getSelectedBookmarks(this.myList);
            ListUtil.removeSelectedItems((JList)this.myList);
            for (Bookmark bookmark : bookmarks) {
                BookmarkManager.getInstance(this.myProject).removeBookmark(bookmark);
            }
        }
    }

    private static class EditBookmarkDescriptionAction
    extends AnAction {
        private final JList myList;
        private final Project myProject;
        private JBPopup myPopup;

        private EditBookmarkDescriptionAction(Project project, JList list) {
            super("Edit Description", "Assign short description for the bookmark to be shown along the file name", IconLoader.getIcon((String)"/actions/properties.png"));
            this.myProject = project;
            this.myList = list;
            this.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(SystemInfo.isMac ? "meta ENTER" : "control ENTER")), list);
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(BookmarksAction.getSelectedBookmarks(this.myList).size() == 1);
        }

        public void actionPerformed(AnActionEvent e) {
            Bookmark b = (Bookmark)BookmarksAction.getSelectedBookmarks(this.myList).get(0);
            this.myPopup.setUiVisible(false);
            String description = Messages.showInputDialog((Project)this.myProject, (String)"Enter short bookmark description", (String)"Bookmark Description", (Icon)Messages.getQuestionIcon(), (String)b.getDescription(), (InputValidator)new InputValidator(){

                public boolean checkInput(String inputString) {
                    return true;
                }

                public boolean canClose(String inputString) {
                    return true;
                }
            });
            BookmarkManager.getInstance(this.myProject).setDescription(b, description);
            this.myPopup.setUiVisible(true);
            this.myPopup.setSize(this.myPopup.getContent().getPreferredSize());
        }

        public void setPopup(JBPopup popup) {
            this.myPopup = popup;
        }
    }

    private static class PreviewPanel
    extends JPanel {
        private final Project myProject;
        private Editor myEditor;
        private ItemWrapper myWrapper;

        public PreviewPanel(Project project) {
            super(new BorderLayout());
            this.myProject = project;
            this.setPreferredSize(new Dimension(600, 400));
        }

        public void updateWithItem(ItemWrapper wrapper) {
            if (this.myWrapper != wrapper) {
                this.myWrapper = wrapper;
                if (wrapper != null) {
                    wrapper.updatePreviewPanel(this);
                } else {
                    this.cleanup();
                    this.repaint();
                }
                this.revalidate();
            }
        }

        private void cleanup() {
            this.removeAll();
            if (this.myEditor != null) {
                EditorFactory.getInstance().releaseEditor(this.myEditor);
                this.myEditor = null;
            }
        }

        @Override
        public void removeNotify() {
            super.removeNotify();
            this.cleanup();
        }
    }

    protected static class BookmarkInContextInfo {
        private DataContext myDataContext;
        private Project myProject;
        private Bookmark myBookmarkAtPlace;
        private VirtualFile myFile;
        private int myLine;

        public BookmarkInContextInfo(DataContext dataContext, Project project) {
            this.myDataContext = dataContext;
            this.myProject = project;
        }

        public Bookmark getBookmarkAtPlace() {
            return this.myBookmarkAtPlace;
        }

        public VirtualFile getFile() {
            return this.myFile;
        }

        public int getLine() {
            return this.myLine;
        }

        public BookmarkInContextInfo invoke() {
            Editor editor;
            this.myBookmarkAtPlace = null;
            this.myFile = null;
            this.myLine = -1;
            BookmarkManager bookmarkManager = BookmarkManager.getInstance(this.myProject);
            if (ToolWindowManager.getInstance((Project)this.myProject).isEditorComponentActive() && (editor = (Editor)PlatformDataKeys.EDITOR.getData(this.myDataContext)) != null) {
                Document document = editor.getDocument();
                this.myLine = editor.getCaretModel().getLogicalPosition().line;
                this.myFile = FileDocumentManager.getInstance().getFile(document);
                this.myBookmarkAtPlace = bookmarkManager.findEditorBookmark(document, this.myLine);
            }
            if (this.myFile == null) {
                this.myFile = (VirtualFile)PlatformDataKeys.VIRTUAL_FILE.getData(this.myDataContext);
                this.myLine = -1;
                if (this.myBookmarkAtPlace == null) {
                    this.myBookmarkAtPlace = bookmarkManager.findFileBookmark(this.myFile);
                }
            }
            return this;
        }
    }

    private static class ItemRenderer
    extends JPanel
    implements ListCellRenderer {
        private final Project myProject;
        private ColoredListCellRenderer myRenderer;

        private ItemRenderer(Project project) {
            super(new BorderLayout());
            this.myProject = project;
            this.setBackground(UIUtil.getListBackground());
            final JLabel label = new JLabel();
            label.setFont(Bookmark.MNEMONIC_FONT);
            label.setPreferredSize(new JLabel("W.").getPreferredSize());
            label.setOpaque(false);
            if (BookmarkManager.getInstance(project).hasBookmarksWithMnemonics()) {
                this.add((Component)label, "West");
            }
            this.myRenderer = new ColoredListCellRenderer(){

                protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                    if (value instanceof ItemWrapper) {
                        ItemWrapper wrapper = (ItemWrapper)value;
                        wrapper.setupRenderer(this, ItemRenderer.this.myProject, selected);
                        wrapper.updateMnemonicLabel(label);
                    }
                }
            };
            this.add((Component)this.myRenderer, "Center");
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.myRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            return this;
        }
    }

    private static class BookmarkItem
    implements ItemWrapper {
        private final Bookmark myBookmark;

        private BookmarkItem(Bookmark bookmark) {
            this.myBookmark = bookmark;
        }

        @Override
        public void setupRenderer(ColoredListCellRenderer renderer, Project project, boolean selected) {
            String description;
            PsiDirectory fileOrDir;
            VirtualFile file = this.myBookmark.getFile();
            PsiManager psiManager = PsiManager.getInstance((Project)project);
            Object object = fileOrDir = file.isDirectory() ? psiManager.findDirectory(file) : psiManager.findFile(file);
            if (fileOrDir != null) {
                renderer.setIcon(fileOrDir.getIcon(8));
            }
            FileStatus fileStatus = FileStatusManager.getInstance((Project)project).getStatus(file);
            TextAttributes attributes = new TextAttributes(fileStatus.getColor(), null, null, EffectType.LINE_UNDERSCORE, 0);
            renderer.append(file.getName(), SimpleTextAttributes.fromTextAttributes((TextAttributes)attributes));
            if (this.myBookmark.getLine() >= 0) {
                renderer.append(":", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                renderer.append(String.valueOf(this.myBookmark.getLine() + 1), SimpleTextAttributes.GRAYED_ATTRIBUTES);
            }
            if (!selected) {
                Color color;
                FileColorManager colorManager = FileColorManager.getInstance((Project)project);
                if (fileOrDir instanceof PsiFile && (color = colorManager.getRendererBackground((PsiFile)fileOrDir)) != null) {
                    renderer.setBackground(color);
                }
            }
            if ((description = this.myBookmark.getDescription()) != null) {
                renderer.append(" " + description, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            }
        }

        @Override
        public void updateMnemonicLabel(JLabel label) {
            char mnemonic = this.myBookmark.getMnemonic();
            if (mnemonic != '\u0000') {
                label.setText(Character.toString(mnemonic) + '.');
            } else {
                label.setText("");
            }
        }

        @Override
        public String speedSearchText() {
            return this.myBookmark.getFile().getName() + " " + this.myBookmark.getDescription();
        }

        @Override
        public void execute(Project project) {
            this.myBookmark.navigate();
        }

        @Override
        public String footerText() {
            return this.myBookmark.getFile().getPresentableUrl();
        }

        @Override
        public void updatePreviewPanel(PreviewPanel panel) {
            VirtualFile file = this.myBookmark.getFile();
            Document document = FileDocumentManager.getInstance().getDocument(file);
            Project project = panel.myProject;
            if (document != null) {
                if (panel.myEditor == null || panel.myEditor.getDocument() != document) {
                    panel.cleanup();
                    panel.myEditor = EditorFactory.getInstance().createViewer(document, project);
                    EditorHighlighter highlighter = EditorHighlighterFactory.getInstance().createEditorHighlighter(file, EditorColorsManager.getInstance().getGlobalScheme(), project);
                    ((EditorEx)panel.myEditor).setHighlighter(highlighter);
                    ((EditorEx)panel.myEditor).setFile(file);
                    panel.myEditor.getSettings().setAnimatedScrolling(false);
                    panel.myEditor.getSettings().setRefrainFromScrolling(false);
                    panel.myEditor.getSettings().setLineNumbersShown(true);
                    panel.myEditor.getSettings().setFoldingOutlineShown(false);
                    panel.add((Component)panel.myEditor.getComponent(), "Center");
                }
                panel.myEditor.getCaretModel().moveToLogicalPosition(new LogicalPosition(this.myBookmark.getLine(), 0));
                panel.validate();
                panel.myEditor.getScrollingModel().scrollToCaret(ScrollType.CENTER);
            } else {
                panel.cleanup();
                JLabel label = new JLabel("Navigate to selected " + (file.isDirectory() ? "directory " : "file ") + "in Project View");
                label.setHorizontalAlignment(0);
                panel.add(label);
            }
        }
    }

    private static interface ItemWrapper {
        public void setupRenderer(ColoredListCellRenderer var1, Project var2, boolean var3);

        public void updateMnemonicLabel(JLabel var1);

        public void execute(Project var1);

        public String speedSearchText();

        @Nullable
        public String footerText();

        public void updatePreviewPanel(PreviewPanel var1);
    }
}

