/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.ExcludingActionGroup;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.actionSystem.impl.Utils;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class WeighingActionGroup
extends ActionGroup {
    private final PresentationFactory myPresentationFactory = new PresentationFactory();

    public void update(AnActionEvent e) {
        this.getDelegate().update(e);
    }

    protected abstract ActionGroup getDelegate();

    private static void getAllChildren(@Nullable AnActionEvent e, ActionGroup group, List<AnAction> result) {
        for (AnAction action : group.getChildren(e)) {
            if (action instanceof ActionGroup && !((ActionGroup)action).isPopup()) {
                WeighingActionGroup.getAllChildren(e, (ActionGroup)action, result);
                continue;
            }
            result.add(action);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        AnAction[] anActionArray;
        AnAction[] children = this.getDelegate().getChildren(e);
        if (e == null) {
            anActionArray = children;
            if (children == null) throw new IllegalStateException("@NotNull method com/intellij/ide/actions/WeighingActionGroup.getChildren must not return null");
            return anActionArray;
        }
        ArrayList<AnAction> all = new ArrayList<AnAction>();
        WeighingActionGroup.getAllChildren(e, this.getDelegate(), all);
        LinkedHashSet<AnAction> heaviest = null;
        double maxWeight = 0.0;
        for (AnAction action : all) {
            Presentation presentation = this.myPresentationFactory.getPresentation(action);
            presentation.setWeight(0.0);
            Utils.updateGroupChild(e.getDataContext(), e.getPlace(), action, presentation);
            if (!presentation.isEnabled() || !presentation.isVisible()) continue;
            if (presentation.getWeight() > maxWeight) {
                maxWeight = presentation.getWeight();
                heaviest = new LinkedHashSet<AnAction>();
            }
            if (presentation.getWeight() != maxWeight || heaviest == null) continue;
            heaviest.add(action);
        }
        if (heaviest == null) {
            anActionArray = children;
            if (children == null) throw new IllegalStateException("@NotNull method com/intellij/ide/actions/WeighingActionGroup.getChildren must not return null");
            return anActionArray;
        }
        DefaultActionGroup chosen = new DefaultActionGroup();
        boolean prevSeparator = true;
        for (AnAction action : all) {
            boolean separator = action instanceof Separator;
            if (separator && !prevSeparator) {
                chosen.add(action);
            }
            prevSeparator = separator;
            if (this.shouldBeChosenAnyway(action)) {
                heaviest.add(action);
            }
            if (!heaviest.contains(action)) continue;
            chosen.add(action);
        }
        ExcludingActionGroup other = new ExcludingActionGroup(this.getDelegate(), heaviest);
        other.setPopup(true);
        other.getTemplatePresentation().setText("Other...");
        anActionArray = new AnAction[]{chosen, new Separator(), other};
        if (anActionArray != null) return anActionArray;
        throw new IllegalStateException("@NotNull method com/intellij/ide/actions/WeighingActionGroup.getChildren must not return null");
    }

    protected boolean shouldBeChosenAnyway(AnAction action) {
        return false;
    }
}

