/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import javax.swing.Icon;

public class ReloadFromDiskAction
extends AnAction
implements DumbAware {
    public void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        final Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        Editor editor = (Editor)PlatformDataKeys.EDITOR.getData(dataContext);
        if (editor == null) {
            return;
        }
        final PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        if (psiFile == null) {
            return;
        }
        int res = Messages.showOkCancelDialog((Project)project, (String)IdeBundle.message((String)"prompt.reload.file.from.disk", (Object[])new Object[]{psiFile.getVirtualFile().getPresentableUrl()}), (String)IdeBundle.message((String)"title.reload.file", (Object[])new Object[0]), (Icon)Messages.getWarningIcon());
        if (res != 0) {
            return;
        }
        CommandProcessor.getInstance().executeCommand(project, new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        PsiManager.getInstance((Project)project).reloadFromDisk(psiFile);
                        CommandProcessor.getInstance().markCurrentCommandAsGlobal(project);
                    }
                });
            }
        }, IdeBundle.message((String)"command.reload.from.disk", (Object[])new Object[0]), null);
    }

    public void update(AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        DataContext dataContext = event.getDataContext();
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            presentation.setEnabled(false);
            return;
        }
        Editor editor = (Editor)PlatformDataKeys.EDITOR.getData(dataContext);
        if (editor == null) {
            presentation.setEnabled(false);
            return;
        }
        Document document = editor.getDocument();
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (psiFile == null || psiFile.getVirtualFile() == null) {
            presentation.setEnabled(false);
        }
    }
}

