/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.ElementsChooser;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ExportableComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.FieldPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class ChooseComponentsToExportDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.actions.ChooseComponentsToExportDialog");
    private final ElementsChooser<ComponentElementProperties> myChooser;
    private final FieldPanel myPathPanel;
    @NonNls
    public static final String DEFAULT_PATH = FileUtil.toSystemDependentName((String)(PathManager.getConfigPath() + "/" + "settings.jar"));
    private final boolean myShowFilePath;
    private final String myDescription;

    public ChooseComponentsToExportDialog(List<ExportableComponent> components, Map<File, Set<ExportableComponent>> fileToComponents, boolean showFilePath, String title, String description) {
        super(false);
        this.myDescription = description;
        this.myShowFilePath = showFilePath;
        LinkedHashMap<ExportableComponent, ComponentElementProperties> componentToContainingListElement = new LinkedHashMap<ExportableComponent, ComponentElementProperties>();
        for (ExportableComponent component : components) {
            if (ChooseComponentsToExportDialog.addToExistingListElement(component, componentToContainingListElement, fileToComponents)) continue;
            ComponentElementProperties componentElementProperties = new ComponentElementProperties();
            componentElementProperties.addComponent(component);
            componentToContainingListElement.put(component, componentElementProperties);
        }
        LinkedHashSet componentElementProperties = new LinkedHashSet(componentToContainingListElement.values());
        this.myChooser = new ElementsChooser(true);
        for (ComponentElementProperties componentElementProperty : componentElementProperties) {
            this.myChooser.addElement(componentElementProperty, true, componentElementProperty);
        }
        ActionListener browseAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String oldPath = ChooseComponentsToExportDialog.this.myPathPanel.getText();
                String path = ChooseComponentsToExportDialog.chooseSettingsFile(oldPath, ChooseComponentsToExportDialog.this.getWindow(), IdeBundle.message((String)"title.export.file.location", (Object[])new Object[0]), IdeBundle.message((String)"prompt.choose.export.settings.file.path", (Object[])new Object[0]));
                if (path == null) {
                    return;
                }
                ChooseComponentsToExportDialog.this.myPathPanel.setText(FileUtil.toSystemDependentName((String)path));
            }
        };
        this.myPathPanel = new FieldPanel(IdeBundle.message((String)"editbox.export.settings.to", (Object[])new Object[0]), null, browseAction, null);
        String exportPath = PropertiesComponent.getInstance().getOrInit("export.settings.path", DEFAULT_PATH);
        this.myPathPanel.setText(exportPath);
        this.setTitle(title);
        this.init();
    }

    protected void doOKAction() {
        PropertiesComponent.getInstance().setValue("export.settings.path", this.myPathPanel.getText());
        super.doOKAction();
    }

    private static boolean addToExistingListElement(ExportableComponent component, Map<ExportableComponent, ComponentElementProperties> componentToContainingListElement, Map<File, Set<ExportableComponent>> fileToComponents) {
        File[] exportFiles = component.getExportFiles();
        File file = null;
        for (File exportFile : exportFiles) {
            Set<ExportableComponent> tiedComponents = fileToComponents.get(exportFile);
            for (ExportableComponent tiedComponent : tiedComponents) {
                ComponentElementProperties elementProperties;
                if (tiedComponent == component || (elementProperties = componentToContainingListElement.get(tiedComponent)) == null || exportFile.equals(file)) continue;
                LOG.assertTrue(file == null, (Object)("Component " + component + " serialize itself into " + file + " and " + exportFile));
                elementProperties.addComponent(component);
                componentToContainingListElement.put(component, elementProperties);
                file = exportFile;
            }
        }
        return file != null;
    }

    @Nullable
    public static String chooseSettingsFile(String oldPath, Component parent, String title, String description) {
        String path;
        VirtualFile initialDir;
        FileChooserDescriptor chooserDescriptor = new FileChooserDescriptor(true, true, true, true, false, false);
        chooserDescriptor.setDescription(description);
        chooserDescriptor.setHideIgnored(false);
        chooserDescriptor.setTitle(title);
        if (oldPath != null) {
            File oldFile = new File(oldPath);
            initialDir = LocalFileSystem.getInstance().findFileByIoFile(oldFile);
            if (initialDir == null && oldFile.getParentFile() != null) {
                initialDir = LocalFileSystem.getInstance().findFileByIoFile(oldFile.getParentFile());
            }
        } else {
            initialDir = null;
        }
        VirtualFile[] files = FileChooser.chooseFiles((Component)parent, (FileChooserDescriptor)chooserDescriptor, initialDir);
        if (files.length == 0) {
            return null;
        }
        VirtualFile file = files[0];
        if (file.isDirectory()) {
            String defaultName = new File(DEFAULT_PATH).getName();
            path = file.getPath() + "/" + defaultName;
        } else {
            path = file.getPath();
        }
        return path;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myPathPanel.getTextField();
    }

    protected JComponent createNorthPanel() {
        return new JLabel(this.myDescription);
    }

    protected JComponent createCenterPanel() {
        return this.myChooser;
    }

    protected JComponent createSouthPanel() {
        JComponent buttons = super.createSouthPanel();
        if (!this.myShowFilePath) {
            return buttons;
        }
        JPanel panel = new JPanel((LayoutManager)new VerticalFlowLayout());
        panel.add((Component)this.myPathPanel);
        panel.add(buttons);
        return panel;
    }

    Set<ExportableComponent> getExportableComponents() {
        List<ComponentElementProperties> markedElements = this.myChooser.getMarkedElements();
        HashSet<ExportableComponent> components = new HashSet<ExportableComponent>();
        for (ComponentElementProperties elementProperties : markedElements) {
            components.addAll(elementProperties.myComponents);
        }
        return components;
    }

    File getExportFile() {
        return new File(this.myPathPanel.getText());
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.ide.actions.ChooseComponentsToExportDialog";
    }

    private static class ComponentElementProperties
    implements ElementsChooser.ElementProperties {
        private final Set<ExportableComponent> myComponents = new HashSet<ExportableComponent>();

        private ComponentElementProperties() {
        }

        private boolean addComponent(ExportableComponent component) {
            return this.myComponents.add(component);
        }

        @Override
        @Nullable
        public Icon getIcon() {
            return null;
        }

        @Override
        @Nullable
        public Color getColor() {
            return null;
        }

        public String toString() {
            String result = "";
            for (ExportableComponent component : this.myComponents) {
                result = result + (result.length() == 0 ? "" : ", ") + component.getPresentableName();
            }
            return result;
        }
    }
}

