/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actionMacro;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.actionMacro.ActionMacro;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ExportableApplicationComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.playback.PlaybackRunner;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.NamedJDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import java.awt.AWTEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ActionMacroManager
implements ExportableApplicationComponent,
NamedJDOMExternalizable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.actionMacro.ActionMacroManager");
    private boolean myIsRecording;
    private final ActionManagerEx myActionManager;
    private ActionMacro myLastMacro;
    private ActionMacro myRecordingMacro;
    private ArrayList<ActionMacro> myMacros = new ArrayList();
    private String myLastMacroName = null;
    private boolean myIsPlaying = false;
    @NonNls
    private static final String ELEMENT_MACRO = "macro";
    private IdeEventQueue.EventDispatcher myKeyProcessor;
    private InputEvent myLastActionInputEvent;

    public ActionMacroManager(ActionManagerEx actionManagerEx) {
        this.myActionManager = actionManagerEx;
        this.myActionManager.addAnActionListener(new AnActionListener(){

            @Override
            public void beforeActionPerformed(AnAction action, DataContext dataContext, AnActionEvent event) {
                if (ActionMacroManager.this.myIsRecording) {
                    String id = ActionMacroManager.this.myActionManager.getId(action);
                    if (id != null && !"StartStopMacroRecording".equals(id)) {
                        ActionMacroManager.this.myRecordingMacro.appendAction(id);
                    }
                    ActionMacroManager.this.myLastActionInputEvent = event.getInputEvent();
                }
            }

            @Override
            public void beforeEditorTyping(char c, DataContext dataContext) {
            }

            @Override
            public void afterActionPerformed(AnAction action, DataContext dataContext, AnActionEvent event) {
            }
        });
        this.myKeyProcessor = new MyKeyPostpocessor();
        IdeEventQueue.getInstance().addPostprocessor(this.myKeyProcessor, null);
    }

    public void readExternal(Element element) throws InvalidDataException {
        this.myMacros = new ArrayList();
        List macros = element.getChildren(ELEMENT_MACRO);
        for (Element macroElement : macros) {
            ActionMacro macro = new ActionMacro();
            macro.readExternal(macroElement);
            this.myMacros.add(macro);
        }
        this.registerActions();
    }

    public String getExternalFileName() {
        return "macros";
    }

    @NotNull
    public File[] getExportFiles() {
        File[] fileArray = new File[]{PathManager.getOptionsFile((NamedJDOMExternalizable)this)};
        if (fileArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/actionMacro/ActionMacroManager.getExportFiles must not return null");
        }
        return fileArray;
    }

    @NotNull
    public String getPresentableName() {
        String string = IdeBundle.message((String)"title.macros", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/actionMacro/ActionMacroManager.getPresentableName must not return null");
        }
        return string;
    }

    public void writeExternal(Element element) throws WriteExternalException {
        for (ActionMacro macro : this.myMacros) {
            Element macroElement = new Element(ELEMENT_MACRO);
            macro.writeExternal(macroElement);
            element.addContent(macroElement);
        }
    }

    public static ActionMacroManager getInstance() {
        return (ActionMacroManager)ApplicationManager.getApplication().getComponent(ActionMacroManager.class);
    }

    @NotNull
    public String getComponentName() {
        if ("ActionMacroManager" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/actionMacro/ActionMacroManager.getComponentName must not return null");
        }
        return "ActionMacroManager";
    }

    public void initComponent() {
    }

    public void startRecording(String macroName) {
        LOG.assertTrue(!this.myIsRecording);
        this.myIsRecording = true;
        this.myRecordingMacro = new ActionMacro(macroName);
    }

    public void stopRecording(Project project) {
        String macroName;
        LOG.assertTrue(this.myIsRecording);
        this.myIsRecording = false;
        do {
            if ((macroName = Messages.showInputDialog((Project)project, (String)IdeBundle.message((String)"prompt.enter.macro.name", (Object[])new Object[0]), (String)IdeBundle.message((String)"title.enter.macro.name", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon())) == null) {
                this.myRecordingMacro = null;
                return;
            }
            if (!"".equals(macroName)) continue;
            macroName = null;
        } while (macroName != null && !this.checkCanCreateMacro(macroName));
        this.myLastMacro = this.myRecordingMacro;
        this.addRecordedMacroWithName(macroName);
        this.registerActions();
    }

    private void addRecordedMacroWithName(String macroName) {
        if (macroName != null) {
            this.myRecordingMacro.setName(macroName);
            this.myMacros.add(this.myRecordingMacro);
            this.myRecordingMacro = null;
        } else {
            for (int i = 0; i < this.myMacros.size(); ++i) {
                ActionMacro macro = this.myMacros.get(i);
                if (!IdeBundle.message((String)"macro.noname", (Object[])new Object[0]).equals(macro.getName())) continue;
                this.myMacros.set(i, this.myRecordingMacro);
                this.myRecordingMacro = null;
                break;
            }
            if (this.myRecordingMacro != null) {
                this.myMacros.add(this.myRecordingMacro);
                this.myRecordingMacro = null;
            }
        }
    }

    public void playbackLastMacro() {
        if (this.myLastMacro != null) {
            this.playbackMacro(this.myLastMacro);
        }
    }

    private void playbackMacro(ActionMacro macro) {
        ActionMacro.ActionDescriptor[] actions;
        final IdeFrame frame = WindowManager.getInstance().getIdeFrame(null);
        assert (frame != null);
        StringBuffer script = new StringBuffer();
        for (ActionMacro.ActionDescriptor each : actions = macro.getActions()) {
            each.generateTo(script);
        }
        PlaybackRunner runner = new PlaybackRunner(script.toString(), new PlaybackRunner.StatusCallback.Edt(){

            @Override
            public void errorEdt(String text, int curentLine) {
                frame.getStatusBar().setInfo("Line " + curentLine + ":" + " Error: " + text);
            }

            @Override
            public void messageEdt(String text, int curentLine) {
                frame.getStatusBar().setInfo("Line " + curentLine + ": " + text);
            }
        }, Registry.is((String)"actionSystem.playback.useDirectActionCall"));
        this.myIsPlaying = true;
        runner.run().doWhenDone(new Runnable(){

            @Override
            public void run() {
                frame.getStatusBar().setInfo("Script execution finished");
            }
        }).doWhenProcessed(new Runnable(){

            @Override
            public void run() {
                ActionMacroManager.this.myIsPlaying = false;
            }
        });
    }

    public boolean isRecording() {
        return this.myIsRecording;
    }

    public void disposeComponent() {
        IdeEventQueue.getInstance().removePostprocessor(this.myKeyProcessor);
    }

    public ActionMacro[] getAllMacros() {
        return this.myMacros.toArray(new ActionMacro[this.myMacros.size()]);
    }

    public void removeAllMacros() {
        if (this.myLastMacro != null) {
            this.myLastMacroName = this.myLastMacro.getName();
            this.myLastMacro = null;
        }
        this.myMacros = new ArrayList();
    }

    public void addMacro(ActionMacro macro) {
        this.myMacros.add(macro);
        if (this.myLastMacroName != null && this.myLastMacroName.equals(macro.getName())) {
            this.myLastMacro = macro;
            this.myLastMacroName = null;
        }
    }

    public void playMacro(ActionMacro macro) {
        this.playbackMacro(macro);
        this.myLastMacro = macro;
    }

    public boolean hasRecentMacro() {
        return this.myLastMacro != null;
    }

    public void registerActions() {
        ActionMacro[] macros;
        this.unregisterActions();
        HashSet<String> registeredIds = new HashSet<String>();
        for (ActionMacro macro : macros = this.getAllMacros()) {
            String actionId = macro.getActionId();
            if (registeredIds.contains(actionId)) continue;
            registeredIds.add(actionId);
            this.myActionManager.registerAction(actionId, new InvokeMacroAction(macro));
        }
    }

    public void unregisterActions() {
        String[] oldIds;
        for (String oldId : oldIds = this.myActionManager.getActionIds("Macro.")) {
            this.myActionManager.unregisterAction(oldId);
        }
    }

    public boolean checkCanCreateMacro(String name) {
        String actionId;
        ActionManagerEx actionManager = (ActionManagerEx)ActionManager.getInstance();
        if (actionManager.getAction(actionId = "Macro." + name) != null) {
            if (Messages.showYesNoDialog((String)IdeBundle.message((String)"message.macro.exists", (Object[])new Object[]{name}), (String)IdeBundle.message((String)"title.macro.name.already.used", (Object[])new Object[0]), (Icon)Messages.getWarningIcon()) != 0) {
                return false;
            }
            actionManager.unregisterAction(actionId);
            this.removeMacro(name);
        }
        return true;
    }

    private void removeMacro(String name) {
        for (int i = 0; i < this.myMacros.size(); ++i) {
            ActionMacro macro = this.myMacros.get(i);
            if (!name.equals(macro.getName())) continue;
            this.myMacros.remove(i);
            break;
        }
    }

    public boolean isPlaying() {
        return this.myIsPlaying;
    }

    private class MyKeyPostpocessor
    implements IdeEventQueue.EventDispatcher {
        private MyKeyPostpocessor() {
        }

        @Override
        public boolean dispatch(AWTEvent e) {
            if (ActionMacroManager.this.isRecording() && e instanceof KeyEvent) {
                this.postProcessKeyEvent((KeyEvent)e);
            }
            return false;
        }

        public void postProcessKeyEvent(KeyEvent e) {
            boolean noModifierKeyIsPressed;
            boolean isChar = e.getKeyChar() != '\uffff';
            boolean hasActionModifiers = e.isAltDown() | e.isControlDown() | e.isMetaDown();
            boolean plainType = isChar && !hasActionModifiers;
            boolean isEnter = e.getKeyCode() == 10;
            boolean bl = noModifierKeyIsPressed = e.getKeyCode() != 17 && e.getKeyCode() != 18 && e.getKeyCode() != 157 && e.getKeyCode() != 16;
            if (e.getID() == 401 && plainType && !isEnter) {
                ActionMacroManager.this.myRecordingMacro.appendKeytyped(e.getKeyChar(), e.getKeyCode(), e.getModifiers());
            } else if (e.getID() == 401 && noModifierKeyIsPressed && (!plainType || isEnter)) {
                boolean waiting = IdeEventQueue.getInstance().getKeyEventDispatcher().isWaitingForSecondKeyStroke();
                if (!e.equals(ActionMacroManager.this.myLastActionInputEvent) && !waiting || isEnter) {
                    String stroke = KeyStroke.getKeyStrokeForEvent(e).toString();
                    int pressed = stroke.indexOf("pressed");
                    String key = stroke.substring(pressed + "pressed".length());
                    String modifiers = stroke.substring(0, pressed);
                    String ready = (modifiers.replaceAll("ctrl", "control").trim() + " " + key.trim()).trim();
                    ActionMacroManager.this.myRecordingMacro.appendShortuct(ready);
                    if (!isEnter) {
                        ActionMacroManager.this.myLastActionInputEvent = null;
                    }
                }
            }
        }
    }

    private static class InvokeMacroAction
    extends AnAction {
        private final ActionMacro myMacro;

        InvokeMacroAction(ActionMacro macro) {
            this.myMacro = macro;
            this.getTemplatePresentation().setText(macro.getName(), false);
        }

        public void actionPerformed(AnActionEvent e) {
            ActionMacroManager.getInstance().playMacro(this.myMacro);
        }

        public void update(AnActionEvent e) {
            super.update(e);
            e.getPresentation().setEnabled(!ActionMacroManager.getInstance().isPlaying() && PlatformDataKeys.EDITOR.getData(e.getDataContext()) != null);
        }
    }
}

