/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.Patches;
import com.intellij.concurrency.JobSchedulerImpl;
import com.intellij.ide.ActivityTracker;
import com.intellij.ide.IdePopupManager;
import com.intellij.ide.ToolkitBugsProcessor;
import com.intellij.ide.dnd.DnDManager;
import com.intellij.ide.dnd.DnDManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.impl.IdeKeyEventDispatcher;
import com.intellij.openapi.keymap.impl.IdeMouseEventDispatcher;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.util.Alarm;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.InputEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.InvocationEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class IdeEventQueue
extends EventQueue {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.IdeEventQueue");
    private final Object myLock = new Object();
    private final ArrayList<Runnable> myIdleListeners = new ArrayList(2);
    private final ArrayList<Runnable> myActivityListeners = new ArrayList(2);
    private final Alarm myIdleRequestsAlarm = new Alarm();
    private final Alarm myIdleTimeCounterAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
    private long myIdleTime;
    private final Map<Runnable, MyFireIdleRequest> myListener2Request = new HashMap();
    private final IdeKeyEventDispatcher myKeyEventDispatcher = new IdeKeyEventDispatcher(this);
    private final IdeMouseEventDispatcher myMouseEventDispatcher = new IdeMouseEventDispatcher();
    private final IdePopupManager myPopupManager = new IdePopupManager();
    private final ToolkitBugsProcessor myToolkitBugsProcessor = new ToolkitBugsProcessor();
    private boolean mySuspendMode;
    private Component myFocusOwner;
    private final Runnable myExitSuspendModeRunnable = new ExitSuspendModeRunnable();
    private final Alarm mySuspendModeAlarm = new Alarm();
    private int myEventCount;
    private boolean myIsInInputEvent = false;
    private AWTEvent myCurrentEvent = null;
    private long myLastActiveTime;
    private WindowManagerEx myWindowManager;
    private final Set<EventDispatcher> myDispatchers = new LinkedHashSet<EventDispatcher>();
    private final Set<EventDispatcher> myPostprocessors = new LinkedHashSet<EventDispatcher>();
    private final Set<Runnable> myReady = new HashSet<Runnable>();
    private boolean myKeyboardBusy;

    public static IdeEventQueue getInstance() {
        return IdeEventQueueHolder.INSTANCE;
    }

    private IdeEventQueue() {
        this.addIdleTimeCounterRequest();
        final KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        keyboardFocusManager.addPropertyChangeListener("permanentFocusOwner", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                Application application = ApplicationManager.getApplication();
                if (application == null) {
                    return;
                }
                application.assertIsDispatchThread();
                Window focusedWindow = keyboardFocusManager.getFocusedWindow();
                Component focusOwner = keyboardFocusManager.getFocusOwner();
                if (IdeEventQueue.this.mySuspendMode && focusedWindow != null && focusOwner != null && focusOwner != IdeEventQueue.this.myFocusOwner && !(focusOwner instanceof Window)) {
                    IdeEventQueue.this.exitSuspendMode();
                }
            }
        });
    }

    public void setWindowManager(WindowManagerEx windowManager) {
        this.myWindowManager = windowManager;
    }

    private void addIdleTimeCounterRequest() {
        Application application = ApplicationManager.getApplication();
        if (application != null && application.isUnitTestMode()) {
            return;
        }
        this.myIdleTimeCounterAlarm.cancelAllRequests();
        this.myLastActiveTime = System.currentTimeMillis();
        this.myIdleTimeCounterAlarm.addRequest(new Runnable(){

            @Override
            public void run() {
                IdeEventQueue.this.myIdleTime += System.currentTimeMillis() - IdeEventQueue.this.myLastActiveTime;
                IdeEventQueue.this.addIdleTimeCounterRequest();
            }
        }, 20000, ModalityState.NON_MODAL);
    }

    public boolean shouldNotTypeInEditor() {
        return this.myKeyEventDispatcher.isWaitingForSecondKeyStroke() || this.mySuspendMode;
    }

    private void enterSuspendMode() {
        this.mySuspendMode = true;
        this.myFocusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        this.mySuspendModeAlarm.cancelAllRequests();
        this.mySuspendModeAlarm.addRequest(this.myExitSuspendModeRunnable, 750);
    }

    private void exitSuspendMode() {
        if (this.shallEnterSuspendMode()) {
            this.mySuspendModeAlarm.cancelAllRequests();
            this.mySuspendModeAlarm.addRequest(this.myExitSuspendModeRunnable, 250);
        } else {
            this.mySuspendMode = false;
            this.myFocusOwner = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIdleListener(@NotNull Runnable runnable, int timeout) {
        if (runnable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/IdeEventQueue.addIdleListener must not be null");
        }
        LOG.assertTrue(timeout > 0);
        Object object = this.myLock;
        synchronized (object) {
            this.myIdleListeners.add(runnable);
            MyFireIdleRequest request = new MyFireIdleRequest(runnable, timeout);
            this.myListener2Request.put(runnable, request);
            this.myIdleRequestsAlarm.addRequest((Runnable)request, timeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIdleListener(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/IdeEventQueue.removeIdleListener must not be null");
        }
        Object object = this.myLock;
        synchronized (object) {
            MyFireIdleRequest request;
            boolean wasRemoved = this.myIdleListeners.remove(runnable);
            if (!wasRemoved) {
                LOG.error("unknown runnable: " + runnable);
            }
            LOG.assertTrue((request = this.myListener2Request.remove(runnable)) != null);
            this.myIdleRequestsAlarm.cancelRequest((Runnable)request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActivityListener(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/IdeEventQueue.addActivityListener must not be null");
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myActivityListeners.add(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActivityListener(@NotNull Runnable runnable, Disposable parentDisposable) {
        if (runnable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/IdeEventQueue.addActivityListener must not be null");
        }
        Object object = this.myLock;
        synchronized (object) {
            ContainerUtil.add((Object)runnable, this.myActivityListeners, (Disposable)parentDisposable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeActivityListener(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/IdeEventQueue.removeActivityListener must not be null");
        }
        Object object = this.myLock;
        synchronized (object) {
            boolean wasRemoved = this.myActivityListeners.remove(runnable);
            if (!wasRemoved) {
                LOG.error("unknown runnable: " + runnable);
            }
        }
    }

    public void addDispatcher(EventDispatcher dispatcher, Disposable parent) {
        this._addProcessor(dispatcher, parent, this.myDispatchers);
    }

    public void removeDispatcher(EventDispatcher dispatcher) {
        this.myDispatchers.remove(dispatcher);
    }

    public boolean containsDispatcher(EventDispatcher dispatcher) {
        return this.myDispatchers.contains(dispatcher);
    }

    public void addPostprocessor(EventDispatcher dispatcher, Disposable parent) {
        this._addProcessor(dispatcher, parent, this.myPostprocessors);
    }

    public void removePostprocessor(EventDispatcher dispatcher) {
        this.myPostprocessors.remove(dispatcher);
    }

    private void _addProcessor(final EventDispatcher dispatcher, Disposable parent, Set<EventDispatcher> set) {
        set.add(dispatcher);
        if (parent != null) {
            Disposer.register((Disposable)parent, (Disposable)new Disposable(){

                public void dispose() {
                    IdeEventQueue.this.removeDispatcher(dispatcher);
                }
            });
        }
    }

    public int getEventCount() {
        return this.myEventCount;
    }

    public void setEventCount(int evCount) {
        this.myEventCount = evCount;
    }

    public AWTEvent getTrueCurrentEvent() {
        return this.myCurrentEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatchEvent(AWTEvent e) {
        boolean wasInputEvent = this.myIsInInputEvent;
        this.myIsInInputEvent = e instanceof InputEvent || e instanceof InputMethodEvent || e instanceof WindowEvent || e instanceof ActionEvent;
        AWTEvent oldEvent = this.myCurrentEvent;
        this.myCurrentEvent = e;
        JobSchedulerImpl.suspend();
        try {
            this._dispatchEvent(e);
        }
        finally {
            this.myIsInInputEvent = wasInputEvent;
            this.myCurrentEvent = oldEvent;
            JobSchedulerImpl.resume();
            for (EventDispatcher each : this.myPostprocessors) {
                each.dispatch(e);
            }
            if (e instanceof KeyEvent) {
                this.maybeReady();
            }
        }
    }

    private static String toDebugString(AWTEvent e) {
        if (e instanceof InvocationEvent) {
            try {
                Field f = InvocationEvent.class.getDeclaredField("runnable");
                f.setAccessible(true);
                Object runnable = f.get(e);
                return "Invoke Later[" + runnable.toString() + "]";
            }
            catch (NoSuchFieldException e1) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return e.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _dispatchEvent(AWTEvent e) {
        InputEvent inputEvent;
        Object dndManager;
        if (e.getID() == 506 && (dndManager = (DnDManagerImpl)DnDManager.getInstance()) != null) {
            dndManager.setLastDropHandler(null);
        }
        ++this.myEventCount;
        if (IdeEventQueue.processAppActivationEvents(e)) {
            return;
        }
        IdeEventQueue.fixStickyFocusedComponents(e);
        if (!this.myPopupManager.isPopupActive()) {
            this.enterSuspendModeIfNeeded(e);
        }
        if (e instanceof KeyEvent) {
            boolean bl = this.myKeyboardBusy = e.getID() != 402 || ((KeyEvent)e).getModifiers() != 0;
        }
        if (IdeEventQueue.typeAheadDispatchToFocusManager(e)) {
            return;
        }
        if (e instanceof WindowEvent) {
            ActivityTracker.getInstance().inc();
        }
        if (e instanceof KeyEvent || e instanceof MouseEvent) {
            ActivityTracker.getInstance().inc();
            dndManager = this.myLock;
            synchronized (dndManager) {
                this.myIdleRequestsAlarm.cancelAllRequests();
                for (Runnable idleListener : this.myIdleListeners) {
                    MyFireIdleRequest request = this.myListener2Request.get(idleListener);
                    if (request == null) {
                        LOG.error("There is no request for " + idleListener);
                    }
                    int timeout = request.getTimeout();
                    this.myIdleRequestsAlarm.addRequest((Runnable)request, timeout, ModalityState.NON_MODAL);
                }
                if (401 == e.getID() || 400 == e.getID() || 501 == e.getID() || 502 == e.getID() || 500 == e.getID()) {
                    this.addIdleTimeCounterRequest();
                    for (Runnable activityListener : this.myActivityListeners) {
                        activityListener.run();
                    }
                }
            }
        }
        if (this.myPopupManager.isPopupActive() && this.myPopupManager.dispatch(e)) {
            return;
        }
        for (EventDispatcher eachDispatcher : this.myDispatchers) {
            if (!eachDispatcher.dispatch(e)) continue;
            return;
        }
        if (e instanceof InputMethodEvent && SystemInfo.isMac && this.myKeyEventDispatcher.isWaitingForSecondKeyStroke()) {
            return;
        }
        if (e instanceof InputEvent && Patches.SPECIAL_WINPUT_METHOD_PROCESSING && !(inputEvent = (InputEvent)e).getComponent().isShowing()) {
            return;
        }
        if (e instanceof ComponentEvent && this.myWindowManager != null) {
            this.myWindowManager.dispatchComponentEvent((ComponentEvent)e);
        }
        if (e instanceof KeyEvent) {
            if (this.mySuspendMode || !this.myKeyEventDispatcher.dispatchKeyEvent((KeyEvent)e)) {
                this.defaultDispatchEvent(e);
            } else {
                ((KeyEvent)e).consume();
                this.defaultDispatchEvent(e);
            }
        } else if (e instanceof MouseEvent) {
            if (!this.myMouseEventDispatcher.dispatchMouseEvent((MouseEvent)e)) {
                this.defaultDispatchEvent(e);
            }
        } else {
            this.defaultDispatchEvent(e);
        }
    }

    private static void fixStickyWindow(KeyboardFocusManager mgr, Window wnd, String resetMethod) {
        if (wnd != null && !wnd.isShowing()) {
            Method setActive;
            Window showingWindow;
            for (showingWindow = wnd; showingWindow != null && !showingWindow.isShowing(); showingWindow = (Window)showingWindow.getParent()) {
            }
            if (showingWindow == null) {
                Frame[] allFrames;
                for (Frame each : allFrames = Frame.getFrames()) {
                    if (!each.isShowing()) continue;
                    showingWindow = each;
                    break;
                }
            }
            if (showingWindow != null && showingWindow != wnd && (setActive = ReflectionUtil.findMethod((Method[])KeyboardFocusManager.class.getDeclaredMethods(), (String)resetMethod, (Class[])new Class[]{Window.class})) != null) {
                try {
                    setActive.setAccessible(true);
                    setActive.invoke((Object)mgr, showingWindow);
                }
                catch (Exception exc) {
                    LOG.info((Throwable)exc);
                }
            }
        }
    }

    private static void fixStickyFocusedComponents(AWTEvent e) {
        Window showingWindow;
        Component focusOwner;
        if (!(e instanceof InputEvent)) {
            return;
        }
        final KeyboardFocusManager mgr = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        if (Registry.is((String)"actionSystem.fixStickyFocusedWindows")) {
            IdeEventQueue.fixStickyWindow(mgr, mgr.getActiveWindow(), "setGlobalActiveWindow");
            IdeEventQueue.fixStickyWindow(mgr, mgr.getFocusedWindow(), "setGlobalFocusedWindow");
        }
        if (Registry.is((String)"actionSystem.fixNullFocusedComponent") && (focusOwner = mgr.getFocusOwner()) == null && (showingWindow = mgr.getActiveWindow()) != null) {
            final IdeFocusManager fm = IdeFocusManager.findInstanceByComponent((Component)showingWindow);
            fm.doWhenFocusSettlesDown(new Runnable(){

                @Override
                public void run() {
                    Application app;
                    if (mgr.getFocusOwner() == null && (app = ApplicationManager.getApplication()) != null && app.isActive()) {
                        fm.requestDefaultFocus(false);
                    }
                }
            });
        }
    }

    private void enterSuspendModeIfNeeded(AWTEvent e) {
        if (e instanceof KeyEvent && !this.mySuspendMode && this.shallEnterSuspendMode()) {
            this.enterSuspendMode();
        }
    }

    private boolean shallEnterSuspendMode() {
        return this.peekEvent(200) != null;
    }

    private static boolean processAppActivationEvents(AWTEvent e) {
        Application app = ApplicationManager.getApplication();
        if (!(app instanceof ApplicationImpl)) {
            return false;
        }
        ApplicationImpl appImpl = (ApplicationImpl)app;
        boolean consumed = false;
        if (e instanceof WindowEvent) {
            WindowEvent we = (WindowEvent)e;
            if (we.getID() == 207 && we.getWindow() != null) {
                if (we.getOppositeWindow() == null && !appImpl.isActive()) {
                    consumed = appImpl.tryToApplyActivationState(true, we.getWindow());
                }
            } else if (we.getID() == 208 && we.getWindow() != null && we.getOppositeWindow() == null && appImpl.isActive()) {
                consumed = appImpl.tryToApplyActivationState(false, we.getWindow());
            }
        }
        return false;
    }

    private void defaultDispatchEvent(AWTEvent e) {
        block3: {
            try {
                super.dispatchEvent(e);
            }
            catch (ProcessCanceledException pce) {
                throw pce;
            }
            catch (Throwable exc) {
                if (this.myToolkitBugsProcessor.process(exc)) break block3;
                LOG.error("Error during dispatching of " + e, exc);
            }
        }
    }

    private static boolean typeAheadDispatchToFocusManager(AWTEvent e) {
        KeyEvent event;
        if (e instanceof KeyEvent && !(event = (KeyEvent)e).isConsumed()) {
            IdeFocusManager focusManager = IdeFocusManager.findInstanceByComponent((Component)event.getComponent());
            return focusManager.dispatch(event);
        }
        return false;
    }

    public void flushQueue() {
        AWTEvent event;
        while ((event = this.peekEvent()) != null) {
            try {
                AWTEvent event1 = this.getNextEvent();
                this.dispatchEvent(event1);
                continue;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                continue;
            }
            break;
        }
        return;
    }

    public void pumpEventsForHierarchy(Component modalComponent, Condition<AWTEvent> exitCondition) {
        AWTEvent event;
        do {
            try {
                Object s;
                event = this.getNextEvent();
                boolean eventOk = true;
                if (event instanceof InputEvent && (s = event.getSource()) instanceof Component) {
                    Component c;
                    Window modalWindow = SwingUtilities.windowForComponent(modalComponent);
                    for (c = (Component)s; c != null && c != modalWindow; c = c.getParent()) {
                    }
                    if (c == null) {
                        eventOk = false;
                        ((InputEvent)event).consume();
                    }
                }
                if (!eventOk) continue;
                this.dispatchEvent(event);
            }
            catch (Throwable e) {
                LOG.error(e);
                event = null;
            }
        } while (!exitCondition.value((Object)event));
    }

    public long getIdleTime() {
        return this.myIdleTime;
    }

    public IdePopupManager getPopupManager() {
        return this.myPopupManager;
    }

    public IdeKeyEventDispatcher getKeyEventDispatcher() {
        return this.myKeyEventDispatcher;
    }

    public void blockNextEvents(MouseEvent e) {
        this.myMouseEventDispatcher.blockNextEvents(e);
    }

    public boolean isSuspendMode() {
        return this.mySuspendMode;
    }

    public boolean hasFocusEventsPending() {
        return this.peekEvent(1004) != null || this.peekEvent(1005) != null;
    }

    private boolean isReady() {
        return !this.myKeyboardBusy && this.myKeyEventDispatcher.isReady();
    }

    public void maybeReady() {
        this.flushReady();
    }

    private void flushReady() {
        if (this.myReady.isEmpty() || !this.isReady()) {
            return;
        }
        Runnable[] ready = this.myReady.toArray(new Runnable[this.myReady.size()]);
        this.myReady.clear();
        for (Runnable each : ready) {
            each.run();
        }
    }

    public void doWhenReady(final Runnable runnable) {
        if (EventQueue.isDispatchThread()) {
            this.myReady.add(runnable);
            this.maybeReady();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    IdeEventQueue.this.myReady.add(runnable);
                    IdeEventQueue.this.maybeReady();
                }
            });
        }
    }

    public boolean isPopupActive() {
        return this.myPopupManager.isPopupActive();
    }

    private final class ExitSuspendModeRunnable
    implements Runnable {
        private ExitSuspendModeRunnable() {
        }

        @Override
        public void run() {
            if (IdeEventQueue.this.mySuspendMode) {
                IdeEventQueue.this.exitSuspendMode();
            }
        }
    }

    private final class MyFireIdleRequest
    implements Runnable {
        private final Runnable myRunnable;
        private final int myTimeout;

        public MyFireIdleRequest(Runnable runnable, int timeout) {
            this.myTimeout = timeout;
            this.myRunnable = runnable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.myRunnable.run();
            Object object = IdeEventQueue.this.myLock;
            synchronized (object) {
                IdeEventQueue.this.myIdleRequestsAlarm.addRequest((Runnable)this, this.myTimeout, ModalityState.NON_MODAL);
            }
        }

        public int getTimeout() {
            return this.myTimeout;
        }
    }

    public static interface EventDispatcher {
        public boolean dispatch(AWTEvent var1);
    }

    private static class IdeEventQueueHolder {
        private static final IdeEventQueue INSTANCE = new IdeEventQueue();

        private IdeEventQueueHolder() {
        }
    }
}

