/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration.ui.views.table;

import com.intellij.openapi.diagnostic.Logger;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.TableUI;
import javax.swing.plaf.basic.BasicTableUI;
import org.jetbrains.annotations.NonNls;

public class RevisionsTableUI
extends BasicTableUI {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.localVcs.ui.RevisionListTableUI2");
    private final TableUI myBaseUI;
    @NonNls
    protected static final String SELECTION_MODEL_PROPERTY_NAME = "selectionModel";

    public RevisionsTableUI(TableUI ui) {
        this.myBaseUI = ui;
    }

    @Override
    public void installUI(JComponent c) {
        this.myBaseUI.installUI(c);
        this.table = (JTable)c;
        this.rendererPane = new CellRendererPane();
        this.table.add(this.rendererPane);
        this.table.addPropertyChangeListener(SELECTION_MODEL_PROPERTY_NAME, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                RevisionsTableUI.this.removeSelectionListener((ListSelectionModel)evt.getOldValue());
            }
        });
    }

    private void removeSelectionListener(ListSelectionModel listSelectionModel) {
        ListSelectionListener myRowSelectionListener = new ListSelectionListener(){
            boolean myDuringChange = false;

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (this.myDuringChange) {
                    return;
                }
                int focusedColumn = RevisionsTableUI.this.table.getColumnModel().getSelectionModel().getAnchorSelectionIndex();
                if (focusedColumn != RevisionsTableUI.this.table.getColumnCount() - 1) {
                    return;
                }
                this.myDuringChange = true;
            }
        };
        listSelectionModel.addListSelectionListener(myRowSelectionListener);
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.myBaseUI.uninstallUI(c);
        this.table.remove(this.rendererPane);
        this.rendererPane = null;
        this.table = null;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        LOG.assertTrue(this.table != null && this.rendererPane != null, (Object)"Disposed");
        JTable table = (JTable)c;
        if (table.getRowCount() == 0 || table.getColumnCount() == 0) {
            return;
        }
        VisibleCells visibleCells = this.visibleCells(table, g.getClipBounds());
        if (visibleCells.hasShiftedColumn()) {
            this.drawShiftedColumns(g, visibleCells);
        }
        Shape prevClip = visibleCells.clipShiftedCells(g);
        this.myBaseUI.paint(g, c);
        g.setClip(prevClip);
    }

    private void drawShiftedColumns(Graphics g, VisibleCells visibleCells) {
        int column = visibleCells.getShiftedColumn();
        Rectangle firstCell = visibleCells.getTopShiftedCell();
        int x = firstCell.x;
        int columnWidth = firstCell.width;
        int lineY = firstCell.y - 1;
        for (int row = visibleCells.getFirstRow(); row <= visibleCells.getLastRow(); ++row) {
            int height = this.table.getRowHeight(row);
            int cellY = lineY + height / 2;
            Component component = this.table.prepareRenderer(this.table.getCellRenderer(row, column), row, column);
            this.rendererPane.paintComponent(g, component, this.table, x, cellY, columnWidth, height + 1, true);
            lineY += height;
        }
    }

    private VisibleCells visibleCells(JTable table, Rectangle visibleArea) {
        int maxRowIndex = table.getRowCount() - 2;
        int firstRow = this.correctRange(visibleArea.y / table.getRowHeight() - 1, 0, maxRowIndex);
        Point corner = new Point(visibleArea.x + visibleArea.width, visibleArea.y + visibleArea.height);
        int lastRow = this.correctRange(corner.y / table.getRowHeight(), 0, maxRowIndex);
        int firstColumn = table.columnAtPoint(visibleArea.getLocation());
        int lastColumn = table.columnAtPoint(corner);
        if (lastColumn == -1) {
            lastColumn = table.getColumnCount() - 1;
        }
        return new VisibleCells(table, firstRow, firstColumn, lastRow, lastColumn);
    }

    private int correctRange(int value, int min, int max) {
        if (value < min) {
            value = min;
        }
        if (value > max) {
            value = max;
        }
        return value;
    }

    private static class VisibleCells {
        private final int myFirstRow;
        private final int myFirstColumn;
        private final int myLastRow;
        private final int myLastColumn;
        private final JTable myTable;

        public VisibleCells(JTable table, int firstRow, int firstColumn, int lastRow, int lastColumn) {
            this.myTable = table;
            this.myFirstRow = firstRow;
            this.myFirstColumn = firstColumn;
            this.myLastRow = lastRow;
            this.myLastColumn = lastColumn;
        }

        public Rectangle leftTopCell(JTable table) {
            return table.getCellRect(this.myFirstRow, this.myFirstColumn, true);
        }

        public int getFirstRow() {
            return this.myFirstRow;
        }

        public int getLastRow() {
            return this.myLastRow;
        }

        public int getEndX(JTable table) {
            Rectangle rightBottom = table.getCellRect(this.myLastRow, this.myLastColumn, true);
            return rightBottom.x + rightBottom.width;
        }

        public Shape clipShiftedCells(Graphics g) {
            int lastColumn = this.hasShiftedColumn() ? this.myLastColumn - 1 : this.myLastColumn;
            Rectangle baseCellsRect = this.getAreaRect(this.myFirstRow, this.myFirstColumn, this.myLastRow, lastColumn);
            Shape prevClip = g.getClip();
            baseCellsRect = g.getClipBounds().intersection(baseCellsRect);
            g.setClip(baseCellsRect.x, baseCellsRect.y, baseCellsRect.width, baseCellsRect.height);
            return prevClip;
        }

        public boolean hasShiftedColumn() {
            return this.myTable.getColumnCount() - 1 == this.myLastColumn && this.myLastRow >= 0 && this.myFirstRow >= 0;
        }

        private Rectangle getAreaRect(int firstRow, int firstColumn, int lastRow, int lastColumn) {
            Point leftTop = this.myTable.getCellRect(firstRow, firstColumn, true).getLocation();
            Rectangle rightBottomCell = this.myTable.getCellRect(lastRow, lastColumn, true);
            Point rightBottom = new Point(rightBottomCell.x + rightBottomCell.width, rightBottomCell.y + rightBottomCell.width);
            return new Rectangle(leftTop.x, leftTop.y, rightBottom.x - leftTop.x, rightBottom.y - leftTop.y);
        }

        public Rectangle getTopShiftedCell() {
            return this.myTable.getCellRect(this.myFirstRow, this.myLastColumn, true);
        }

        public Color getGrigColor() {
            return this.myTable.getGridColor();
        }

        public int getShiftedColumn() {
            return this.myTable.getColumnCount() - 1;
        }
    }
}

