/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration.ui.views;

import com.intellij.CommonBundle;
import com.intellij.history.LocalHistoryConfiguration;
import com.intellij.history.core.LocalVcs;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.LocalHistoryBundle;
import com.intellij.history.integration.LocalHistoryComponent;
import com.intellij.history.integration.revertion.Reverter;
import com.intellij.history.integration.ui.models.FileDifferenceModel;
import com.intellij.history.integration.ui.models.HistoryDialogModel;
import com.intellij.history.integration.ui.models.RevisionProcessingProgress;
import com.intellij.history.integration.ui.views.table.RevisionsTable;
import com.intellij.ide.ui.SplitterProportionsDataImpl;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.SimpleDiffRequest;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.SplitterProportionsData;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.patch.CreatePatchConfigurationPanel;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.Consumer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public abstract class HistoryDialog<T extends HistoryDialogModel>
extends DialogWrapper {
    protected IdeaGateway myGateway;
    protected VirtualFile myFile;
    private RevisionsTable myRevisionsTable;
    protected Splitter mySplitter;
    protected T myModel;

    protected HistoryDialog(IdeaGateway gw, VirtualFile f, boolean doInit) {
        super(gw.getProject(), true);
        this.myGateway = gw;
        this.myFile = f;
        if (doInit) {
            this.init();
        }
    }

    protected void init() {
        this.initModel();
        super.init();
    }

    private void initModel() {
        LocalVcs vcs = LocalHistoryComponent.getLocalVcsFor(this.getProject());
        this.myModel = this.createModel(vcs);
        this.restoreShowChangesOnlyOption();
    }

    protected abstract T createModel(LocalVcs var1);

    protected JComponent createCenterPanel() {
        JComponent diff = this.createDiffPanel();
        JComponent revisions = this.createRevisionsList();
        this.mySplitter = new Splitter(true, 0.7f);
        this.mySplitter.setFirstComponent(diff);
        this.mySplitter.setSecondComponent(revisions);
        this.mySplitter.setPreferredSize(this.getInitialSize());
        this.restoreSplitterProportion();
        return this.mySplitter;
    }

    protected abstract Dimension getInitialSize();

    protected void dispose() {
        this.saveShowChangesOnlyOption();
        this.saveSplitterProportion();
        super.dispose();
    }

    protected abstract JComponent createDiffPanel();

    private JComponent createRevisionsList() {
        ActionGroup actions = this.createRevisionsActions();
        ActionToolbar tb = this.createRevisionsToolbar(actions);
        JComponent t = this.createRevisionsTable(actions);
        JPanel result = new JPanel(new BorderLayout());
        result.add((Component)tb.getComponent(), "North");
        result.add((Component)t, "Center");
        return result;
    }

    private ActionToolbar createRevisionsToolbar(ActionGroup actions) {
        ActionManager am = ActionManager.getInstance();
        return am.createActionToolbar("unknown", actions, true);
    }

    private ActionGroup createRevisionsActions() {
        DefaultActionGroup result = new DefaultActionGroup();
        result.add((AnAction)new RevertAction());
        result.add((AnAction)new CreatePatchAction());
        result.add((AnAction)Separator.getInstance());
        result.add((AnAction)new ShowChangesOnlyAction());
        result.add((AnAction)Separator.getInstance());
        result.add((AnAction)new HelpAction());
        return result;
    }

    private JComponent createRevisionsTable(ActionGroup actions) {
        this.myRevisionsTable = new RevisionsTable((HistoryDialogModel)this.myModel, new RevisionsTable.SelectionListener(){

            @Override
            public void changesSelected(int first, int last) {
                ((HistoryDialogModel)HistoryDialog.this.myModel).selectChanges(first, last);
                HistoryDialog.this.updateDiffs();
            }

            @Override
            public void revisionsSelected(int first, int last) {
                ((HistoryDialogModel)HistoryDialog.this.myModel).selectRevisions(first, last);
                HistoryDialog.this.updateDiffs();
            }
        });
        this.addPopupMenuToComponent((JComponent)((Object)this.myRevisionsTable), actions);
        return ScrollPaneFactory.createScrollPane((JComponent)((Object)this.myRevisionsTable));
    }

    private void addPopupMenuToComponent(JComponent comp, final ActionGroup ag) {
        comp.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component c, int x, int y) {
                ActionPopupMenu m = HistoryDialog.this.createPopupMenu(ag);
                m.getComponent().show(c, x, y);
            }
        });
    }

    private ActionPopupMenu createPopupMenu(ActionGroup ag) {
        ActionManager m = ActionManager.getInstance();
        return m.createActionPopupMenu("unknown", ag);
    }

    protected abstract void updateDiffs();

    protected SimpleDiffRequest createDifference(final FileDifferenceModel m) {
        final SimpleDiffRequest r = new SimpleDiffRequest(this.getProject(), m.getTitle());
        this.processRevisions(new RevisionProcessingTask(){

            @Override
            public void run(RevisionProcessingProgress p) {
                p.processingLeftRevision();
                DiffContent left = m.getLeftDiffContent(p);
                p.processingRightRevision();
                DiffContent right = m.getRightDiffContent(p);
                r.setContents(left, right);
                r.setContentTitles(m.getLeftTitle(p), m.getRightTitle(p));
            }
        });
        return r;
    }

    private void restoreShowChangesOnlyOption() {
        ((HistoryDialogModel)this.myModel).showChangesOnly(LocalHistoryConfiguration.getInstance().SHOW_CHANGES_ONLY);
    }

    private void saveShowChangesOnlyOption() {
        boolean value;
        LocalHistoryConfiguration.getInstance().SHOW_CHANGES_ONLY = value = ((HistoryDialogModel)this.myModel).doesShowChangesOnly();
    }

    private void restoreSplitterProportion() {
        SplitterProportionsData d = this.createSplitterData();
        d.externalizeFromDimensionService(this.getDimensionServiceKey());
        d.restoreSplitterProportions((Component)this.mySplitter);
    }

    private void saveSplitterProportion() {
        SplitterProportionsData d = this.createSplitterData();
        d.saveSplitterProportions((Component)this.mySplitter);
        d.externalizeToDimensionService(this.getDimensionServiceKey());
    }

    private SplitterProportionsData createSplitterData() {
        return new SplitterProportionsDataImpl();
    }

    protected String getDimensionServiceKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected Action[] createActions() {
        return new Action[0];
    }

    protected abstract String getHelpId();

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp(this.getHelpId());
    }

    protected void revert() {
        this.revert(((HistoryDialogModel)this.myModel).createReverter());
    }

    private boolean isRevertEnabled() {
        return ((HistoryDialogModel)this.myModel).isRevertEnabled();
    }

    protected void revert(Reverter r) {
        try {
            if (!this.askForProceeding(r)) {
                return;
            }
            List<String> errors = r.checkCanRevert();
            if (!errors.isEmpty()) {
                this.showRevertErrors(errors);
                return;
            }
            r.revert();
            this.close(0);
        }
        catch (IOException e) {
            this.myGateway.showError(LocalHistoryBundle.message("message.error.during.revert", e));
        }
    }

    private boolean askForProceeding(Reverter r) throws IOException {
        List<String> questions = r.askUserForProceeding();
        if (questions.isEmpty()) {
            return true;
        }
        return this.myGateway.askForProceeding(LocalHistoryBundle.message("message.do.you.want.to.proceed", this.formatQuestions(questions)));
    }

    private String formatQuestions(List<String> questions) {
        if (questions.size() == 1) {
            return questions.get(0);
        }
        String result = "";
        for (int i = 0; i < questions.size(); ++i) {
            result = result + (i + 1) + ") " + questions.get(i) + "\n";
        }
        return result.substring(0, result.length() - 1);
    }

    private void showRevertErrors(List<String> errors) {
        this.myGateway.showError(LocalHistoryBundle.message("message.cannot.revert.because", this.formatErrors(errors)));
    }

    private String formatErrors(List<String> errors) {
        if (errors.size() == 1) {
            return errors.get(0);
        }
        String result = "";
        for (String e : errors) {
            result = result + "\n    -" + e;
        }
        return result;
    }

    private boolean isCreatePatchEnabled() {
        return ((HistoryDialogModel)this.myModel).isCreatePatchEnabled();
    }

    private void createPatch() {
        try {
            if (!((HistoryDialogModel)this.myModel).canPerformCreatePatch()) {
                this.myGateway.showError(LocalHistoryBundle.message("message.cannot.create.patch.because.of.unavailable.content", new Object[0]));
                return;
            }
            CreatePatchConfigurationPanel p = new CreatePatchConfigurationPanel();
            p.setFileName(this.getDefaultPatchFile());
            if (!this.showAsDialog(p)) {
                return;
            }
            ((HistoryDialogModel)this.myModel).createPatch(p.getFileName(), p.isReversePatch());
            this.close(0);
        }
        catch (VcsException e) {
            this.myGateway.showError(LocalHistoryBundle.message("message.error.during.create.patch", new Object[]{e}));
        }
        catch (IOException e) {
            this.myGateway.showError(LocalHistoryBundle.message("message.error.during.create.patch", e));
        }
    }

    private File getDefaultPatchFile() {
        return FileUtil.findSequentNonexistentFile((File)new File(this.myGateway.getBaseDir()), (String)"local_history", (String)"patch");
    }

    private boolean showAsDialog(CreatePatchConfigurationPanel p) {
        final DialogBuilder b = new DialogBuilder(this.myGateway.getProject());
        b.setTitle(LocalHistoryBundle.message("create.patch.dialog.title", new Object[0]));
        b.setCenterPanel((JComponent)p.getPanel());
        p.installOkEnabledListener(new Consumer<Boolean>(){

            public void consume(Boolean aBoolean) {
                b.setOkActionEnabled(aBoolean.booleanValue());
            }
        });
        return b.show() == 0;
    }

    protected void showHelp() {
        HelpManager.getInstance().invokeHelp(this.getHelpId());
    }

    protected void processRevisions(final RevisionProcessingTask t) {
        new Task.Modal(this.getProject(), LocalHistoryBundle.message("message.processing.revisions", new Object[0]), false){

            public void run(@NotNull ProgressIndicator i) {
                if (i == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/history/integration/ui/views/HistoryDialog$5.run must not be null");
                }
                t.run(new RevisionProcessingProgressAdapter(i));
            }
        }.queue();
    }

    protected Project getProject() {
        return this.myGateway.getProject();
    }

    private static class RevisionProcessingProgressAdapter
    implements RevisionProcessingProgress {
        private final ProgressIndicator myIndicator;

        public RevisionProcessingProgressAdapter(ProgressIndicator i) {
            this.myIndicator = i;
        }

        @Override
        public void processingLeftRevision() {
            this.myIndicator.setText(LocalHistoryBundle.message("message.processing.left.revision", new Object[0]));
        }

        @Override
        public void processingRightRevision() {
            this.myIndicator.setText(LocalHistoryBundle.message("message.processing.right.revision", new Object[0]));
        }

        @Override
        public void processed(int percentage) {
            this.myIndicator.setFraction((double)percentage / 100.0);
        }
    }

    protected static interface RevisionProcessingTask {
        public void run(RevisionProcessingProgress var1);
    }

    private class HelpAction
    extends AnAction {
        public HelpAction() {
            super(CommonBundle.getHelpButtonText(), null, IconLoader.getIcon((String)"/actions/help.png"));
        }

        public void actionPerformed(AnActionEvent e) {
            HistoryDialog.this.doHelpAction();
        }
    }

    private class ShowChangesOnlyAction
    extends ToggleAction {
        public ShowChangesOnlyAction() {
            super(LocalHistoryBundle.message("action.show.changes.only", new Object[0]), null, IconLoader.getIcon((String)"/actions/showChangesOnly.png"));
        }

        public boolean isSelected(AnActionEvent e) {
            return ((HistoryDialogModel)HistoryDialog.this.myModel).doesShowChangesOnly();
        }

        public void setSelected(AnActionEvent e, boolean state) {
            ((HistoryDialogModel)HistoryDialog.this.myModel).showChangesOnly(state);
            HistoryDialog.this.myRevisionsTable.updateData();
        }
    }

    private class CreatePatchAction
    extends AnAction {
        public CreatePatchAction() {
            super(LocalHistoryBundle.message("action.create.patch", new Object[0]), null, IconLoader.getIcon((String)"/actions/createPatch.png"));
        }

        public void actionPerformed(AnActionEvent e) {
            HistoryDialog.this.createPatch();
        }

        public void update(AnActionEvent e) {
            Presentation p = e.getPresentation();
            p.setEnabled(HistoryDialog.this.isCreatePatchEnabled());
        }
    }

    private class RevertAction
    extends AnAction {
        public RevertAction() {
            super(LocalHistoryBundle.message("action.revert", new Object[0]), null, IconLoader.getIcon((String)"/actions/rollback.png"));
        }

        public void actionPerformed(AnActionEvent e) {
            HistoryDialog.this.revert();
        }

        public void update(AnActionEvent e) {
            Presentation p = e.getPresentation();
            p.setEnabled(HistoryDialog.this.isRevertEnabled());
        }
    }
}

