/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration.revertion;

import com.intellij.history.core.IdPath;
import com.intellij.history.core.LocalVcs;
import com.intellij.history.core.changes.ChangeVisitor;
import com.intellij.history.core.changes.StructuralChange;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.LocalHistoryBundle;
import com.intellij.history.utils.RunnableAdapter;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public abstract class Reverter {
    protected LocalVcs myVcs;
    protected IdeaGateway myGateway;

    protected Reverter(LocalVcs vcs, IdeaGateway gw) {
        this.myVcs = vcs;
        this.myGateway = gw;
    }

    public List<String> askUserForProceeding() throws IOException {
        return Collections.emptyList();
    }

    public List<String> checkCanRevert() throws IOException {
        ArrayList<String> errors = new ArrayList<String>();
        this.doCheckCanRevert(errors);
        return this.removeDuplicatesAndSort(errors);
    }

    private List<String> removeDuplicatesAndSort(List<String> list) {
        ArrayList<String> result = new ArrayList<String>(new HashSet<String>(list));
        Collections.sort(result);
        return result;
    }

    protected void doCheckCanRevert(List<String> errors) throws IOException {
        if (!this.askForReadOnlyStatusClearing()) {
            errors.add(LocalHistoryBundle.message("revert.error.files.are.read.only", new Object[0]));
        }
    }

    protected boolean askForReadOnlyStatusClearing() throws IOException {
        return this.myGateway.ensureFilesAreWritable(this.getFilesToClearROStatus());
    }

    protected List<VirtualFile> getFilesToClearROStatus() throws IOException {
        final HashSet files = new HashSet();
        this.myVcs.acceptRead(this.selective(new ChangeVisitor(){

            @Override
            public void visit(StructuralChange c) {
                for (IdPath p : c.getAffectedIdPaths()) {
                    Entry e = this.myRoot.findEntry(p);
                    if (e == null) continue;
                    files.addAll(Reverter.this.myGateway.getAllFilesFrom(e.getPath()));
                }
            }
        }));
        return new ArrayList<VirtualFile>(files);
    }

    protected ChangeVisitor selective(ChangeVisitor v) {
        return v;
    }

    public void revert() throws IOException {
        try {
            this.myGateway.performCommandInsideWriteAction(this.formatCommandName(), new RunnableAdapter(){

                @Override
                public void doRun() throws Exception {
                    Reverter.this.myGateway.saveAllUnsavedDocuments();
                    Reverter.this.doRevert();
                    Reverter.this.myGateway.saveAllUnsavedDocuments();
                }
            });
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw e;
        }
    }

    protected abstract String formatCommandName();

    protected abstract void doRevert() throws IOException;
}

