/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration;

import com.intellij.history.core.LocalVcs;
import com.intellij.history.core.Paths;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.integration.CacheUpdaterProcessor;
import com.intellij.history.integration.FileFilter;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.LocalHistoryFacade;
import com.intellij.history.utils.LocalHistoryLog;
import com.intellij.ide.caches.CacheUpdater;
import com.intellij.ide.caches.FileContent;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.vfs.DeprecatedVirtualFile;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileManagerListener;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.VirtualFileSystem;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EventDispatcher
extends VirtualFileAdapter
implements VirtualFileManagerListener,
CommandListener,
CacheUpdater {
    private final LocalVcs myVcs;
    private final IdeaGateway myGateway;
    private final LocalHistoryFacade myFacade;
    private int myRefreshDepth = 0;
    private CacheUpdaterProcessor myProcessor;

    public EventDispatcher(LocalVcs vcs, IdeaGateway gw) {
        this.myVcs = vcs;
        this.myGateway = gw;
        this.myFacade = new LocalHistoryFacade(vcs, gw);
    }

    public void beforeRefreshStart(boolean asynchonous) {
        ++this.myRefreshDepth;
        this.myFacade.startRefreshing();
    }

    public void afterRefreshFinish(boolean asynchonous) {
    }

    private boolean isRefreshing() {
        return this.myRefreshDepth > 0;
    }

    public int getNumberOfPendingUpdateJobs() {
        return 0;
    }

    public VirtualFile[] queryNeededFiles() {
        return this.getOrInitProcessor().queryNeededFiles();
    }

    public void processFile(FileContent c) {
        this.getOrInitProcessor().processFile(c);
    }

    public void updatingDone() {
        if (this.myRefreshDepth == 0) {
            return;
        }
        --this.myRefreshDepth;
        this.myFacade.finishRefreshing();
        this.myProcessor = null;
    }

    public void canceled() {
        this.updatingDone();
    }

    public void commandStarted(CommandEvent e) {
        if (this.notForMe(e)) {
            return;
        }
        this.myFacade.startCommand();
    }

    public void commandFinished(CommandEvent e) {
        if (this.notForMe(e)) {
            return;
        }
        this.myFacade.finishCommand(e.getCommandName());
    }

    private boolean notForMe(CommandEvent e) {
        return e.getProject() != this.myGateway.getProject();
    }

    public void startAction() {
        this.myFacade.startAction();
    }

    public void finishAction(String name) {
        this.myFacade.finishAction(name);
    }

    public void fileCreated(VirtualFileEvent e) {
        if (this.notAllowedOrNotUnderContentRoot(e)) {
            return;
        }
        VirtualFile f = e.getFile();
        if (e.getRequestor() instanceof Entry) {
            this.myFacade.restore(f, (Entry)e.getRequestor());
        } else {
            if (this.wasCreatedDuringRootsUpdate(f)) {
                return;
            }
            this.create(f);
        }
    }

    private boolean wasCreatedDuringRootsUpdate(VirtualFile f) {
        return this.hasEntryFor(f);
    }

    private boolean hasEntryFor(VirtualFile f) {
        return this.myVcs.hasEntry(f.getPath());
    }

    private void create(VirtualFile fileOrDir) {
        this.myFacade.beginChangeSet();
        this.createRecursively(fileOrDir);
        this.myFacade.endChangeSet(null);
    }

    private void createRecursively(VirtualFile f) {
        if (this.notAllowedOrNotUnderContentRoot(f)) {
            return;
        }
        if (this.isRefreshing() && !f.isDirectory()) {
            this.getOrInitProcessor().addFileToCreate(f);
            return;
        }
        this.myFacade.create(f);
        if (f.isDirectory()) {
            for (VirtualFile child : f.getChildren()) {
                this.createRecursively(child);
            }
        }
    }

    public void contentsChanged(VirtualFileEvent e) {
        if (this.notAllowedOrNotUnderContentRoot(e)) {
            return;
        }
        if (!this.checkFileValidity(e.getFile())) {
            return;
        }
        this.changeContent(e.getFile());
    }

    private boolean checkFileValidity(VirtualFile f) {
        VirtualFile validParent;
        if (f.isValid() && this.hasEntryFor(f)) {
            return true;
        }
        String s = "\nhas entry for file: " + this.hasEntryFor(f);
        s = s + "\nfile is not valid: " + f.getPath();
        for (validParent = f.getParent(); validParent != null && !validParent.isValid(); validParent = validParent.getParent()) {
        }
        s = s + "\nfirst valid parent: " + (validParent == null ? "null" : validParent.getPath());
        LocalHistoryLog.LOG.warn(s);
        return false;
    }

    private void changeContent(VirtualFile f) {
        if (this.isRefreshing()) {
            this.getOrInitProcessor().addFileToUpdate(f);
        } else {
            this.myFacade.changeFileContent(f);
        }
    }

    private CacheUpdaterProcessor getOrInitProcessor() {
        if (this.myProcessor == null) {
            this.myProcessor = new CacheUpdaterProcessor(this.myVcs);
        }
        return this.myProcessor;
    }

    public void propertyChanged(VirtualFilePropertyEvent e) {
        if (e.getPropertyName().equals("name")) {
            this.fileRenamed(e);
        }
        if (e.getPropertyName().equals("writable")) {
            this.readOnlyStatusChanged(e);
        }
    }

    private void fileRenamed(VirtualFilePropertyEvent e) {
        VirtualFile newFile = e.getFile();
        RenamedVirtualFile oldFile = new RenamedVirtualFile(e.getFile(), (String)e.getOldValue());
        boolean wasInContent = this.hasEntryFor((VirtualFile)oldFile);
        if (this.notAllowedOrNotUnderContentRoot(newFile)) {
            if (wasInContent) {
                this.myFacade.delete((VirtualFile)oldFile);
            }
            return;
        }
        if (!wasInContent) {
            this.create(newFile);
            return;
        }
        this.myFacade.rename((VirtualFile)oldFile, e.getFile().getName());
    }

    private void readOnlyStatusChanged(VirtualFilePropertyEvent e) {
        if (this.notAllowedOrNotUnderContentRoot((VirtualFileEvent)e)) {
            return;
        }
        VirtualFile f = e.getFile();
        if (f.isDirectory()) {
            return;
        }
        this.myFacade.changeROStatus(f);
    }

    public void fileMoved(VirtualFileMoveEvent e) {
        if (this.isMovedFromOutside(e) && this.isMovedToOutside(e)) {
            return;
        }
        if (this.isMovedFromOutside(e)) {
            if (this.notAllowedOrNotUnderContentRoot((VirtualFileEvent)e)) {
                return;
            }
            this.create(e.getFile());
            return;
        }
        ReparentedVirtualFile oldFile = new ReparentedVirtualFile(e.getOldParent(), e.getFile());
        if (this.isMovedToOutside(e)) {
            boolean wasInContent = this.hasEntryFor((VirtualFile)oldFile);
            if (wasInContent) {
                this.myFacade.delete((VirtualFile)oldFile);
            }
            return;
        }
        if (this.notAllowedOrNotUnderContentRoot((VirtualFileEvent)e)) {
            return;
        }
        this.myFacade.move((VirtualFile)oldFile, e.getNewParent());
    }

    public void fileDeleted(VirtualFileEvent e) {
        VirtualFile f = e.getFile();
        if (this.wasDeletedDuringRootsUpdate(f)) {
            return;
        }
        this.myFacade.delete(f);
    }

    private boolean wasDeletedDuringRootsUpdate(VirtualFile f) {
        return !this.hasEntryFor(f);
    }

    private boolean notAllowedOrNotUnderContentRoot(VirtualFile f) {
        return !this.getFileFilter().isAllowedAndUnderContentRoot(f);
    }

    private boolean notAllowedOrNotUnderContentRoot(VirtualFileEvent e) {
        return this.notAllowedOrNotUnderContentRoot(e.getFile());
    }

    private boolean isMovedFromOutside(VirtualFileMoveEvent e) {
        return !this.getFileFilter().isUnderContentRoot(e.getOldParent());
    }

    private boolean isMovedToOutside(VirtualFileMoveEvent e) {
        return !this.getFileFilter().isUnderContentRoot(e.getNewParent());
    }

    public void beforeCommandFinished(CommandEvent e) {
    }

    public void undoTransparentActionStarted() {
    }

    public void undoTransparentActionFinished() {
    }

    private FileFilter getFileFilter() {
        return this.myGateway.getFileFilter();
    }

    private static class NullVirtualFile
    extends DeprecatedVirtualFile {
        private NullVirtualFile() {
        }

        @NotNull
        @NonNls
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @NotNull
        public VirtualFileSystem getFileSystem() {
            throw new UnsupportedOperationException();
        }

        public String getPath() {
            throw new UnsupportedOperationException();
        }

        public boolean isWritable() {
            throw new UnsupportedOperationException();
        }

        public boolean isDirectory() {
            throw new UnsupportedOperationException();
        }

        public boolean isValid() {
            throw new UnsupportedOperationException();
        }

        @Nullable
        public VirtualFile getParent() {
            throw new UnsupportedOperationException();
        }

        public VirtualFile[] getChildren() {
            throw new UnsupportedOperationException();
        }

        @NotNull
        public OutputStream getOutputStream(Object requestor, long newModificationStamp, long newTimeStamp) throws IOException {
            throw new UnsupportedOperationException();
        }

        @NotNull
        public byte[] contentsToByteArray() throws IOException {
            throw new UnsupportedOperationException();
        }

        public long getTimeStamp() {
            throw new UnsupportedOperationException();
        }

        public long getLength() {
            throw new UnsupportedOperationException();
        }

        public void refresh(boolean asynchronous, boolean recursive, Runnable postRunnable) {
            throw new UnsupportedOperationException();
        }

        public InputStream getInputStream() throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    private static class RenamedVirtualFile
    extends NullVirtualFile {
        private final VirtualFile myFile;
        private final String myNewName;

        public RenamedVirtualFile(VirtualFile f, String newName) {
            this.myFile = f;
            this.myNewName = newName;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myNewName;
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/history/integration/EventDispatcher$RenamedVirtualFile.getName must not return null");
            }
            return string;
        }

        @Override
        public String getPath() {
            return Paths.renamed(this.myFile.getPath(), this.myNewName);
        }

        @Override
        public VirtualFile getParent() {
            return this.myFile.getParent();
        }

        @Override
        public boolean isDirectory() {
            return this.myFile.isDirectory();
        }
    }

    private static class ReparentedVirtualFile
    extends NullVirtualFile {
        private final VirtualFile myParent;
        private final VirtualFile myChild;

        public ReparentedVirtualFile(VirtualFile newParent, VirtualFile child) {
            this.myChild = child;
            this.myParent = newParent;
        }

        @Override
        public String getPath() {
            return Paths.appended(this.myParent.getPath(), this.myChild.getName());
        }
    }
}

