/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core.storage;

import com.intellij.history.core.storage.BrokenStorageException;
import com.intellij.history.core.storage.Content;
import com.intellij.history.core.storage.Storage;
import com.intellij.history.core.storage.Stream;
import java.io.IOException;

public class StoredContent
extends Content {
    private final Storage myStorage;
    private final int myId;

    public StoredContent(Storage s, int id) {
        this.myStorage = s;
        this.myId = id;
    }

    public StoredContent(Stream s) throws IOException {
        this.myId = s.readInteger();
        this.myStorage = s.getStorage();
    }

    @Override
    public void write(Stream s) throws IOException {
        s.writeInteger(this.myId);
    }

    @Override
    public byte[] getBytes() {
        try {
            return this.getBytesUnsafe();
        }
        catch (BrokenStorageException e) {
            throw new RuntimeException(e);
        }
    }

    private byte[] getBytesUnsafe() throws BrokenStorageException {
        return this.myStorage.loadContentData(this.myId);
    }

    @Override
    public boolean isAvailable() {
        try {
            this.getBytesUnsafe();
            return true;
        }
        catch (BrokenStorageException e) {
            return false;
        }
    }

    public int getId() {
        return this.myId;
    }

    @Override
    public void purge() {
        this.myStorage.purgeContent(this);
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && this.myId == ((StoredContent)o).myId;
    }

    public int hashCode() {
        return this.myId;
    }
}

