/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core.changes;

import com.intellij.history.core.IdPath;
import com.intellij.history.core.changes.Change;
import com.intellij.history.core.changes.StructuralChangeAppliedState;
import com.intellij.history.core.changes.StructuralChangeNonAppliedState;
import com.intellij.history.core.changes.StructuralChangeState;
import com.intellij.history.core.storage.Content;
import com.intellij.history.core.storage.Stream;
import com.intellij.history.core.tree.Entry;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public abstract class StructuralChange<NON_APPLIED_STATE_TYPE extends StructuralChangeNonAppliedState, APPLIED_STATE_TYPE extends StructuralChangeAppliedState>
extends Change {
    private StructuralChangeState myState;

    protected StructuralChange(String path) {
        this.myState = this.createNonAppliedState();
        ((StructuralChangeNonAppliedState)this.getNonAppliedState()).myPath = path;
    }

    protected StructuralChange(Stream s) throws IOException {
        this.myState = this.createAppliedState();
        ((StructuralChangeAppliedState)this.getAppliedState()).myAffectedIdPath = s.readIdPath();
    }

    @Override
    public void write(Stream s) throws IOException {
        s.writeIdPath(this.getAffectedIdPath());
    }

    protected String getPath() {
        return ((StructuralChangeNonAppliedState)this.getNonAppliedState()).myPath;
    }

    protected IdPath getAffectedIdPath() {
        return ((StructuralChangeAppliedState)this.getAppliedState()).myAffectedIdPath;
    }

    protected abstract NON_APPLIED_STATE_TYPE createNonAppliedState();

    protected abstract APPLIED_STATE_TYPE createAppliedState();

    protected NON_APPLIED_STATE_TYPE getNonAppliedState() {
        return (NON_APPLIED_STATE_TYPE)((StructuralChangeNonAppliedState)this.myState);
    }

    protected APPLIED_STATE_TYPE getAppliedState() {
        return (APPLIED_STATE_TYPE)((StructuralChangeAppliedState)this.myState);
    }

    @Override
    public void applyTo(Entry r) {
        APPLIED_STATE_TYPE newState = this.createAppliedState();
        ((StructuralChangeAppliedState)newState).myAffectedIdPath = this.doApplyTo(r, newState);
        this.myState = newState;
    }

    protected abstract IdPath doApplyTo(Entry var1, APPLIED_STATE_TYPE var2);

    @Override
    public abstract void doRevertOn(Entry var1);

    protected boolean hasNoSuchEntry(Entry parent, String name) {
        return parent.findChild(name) == null;
    }

    protected void removeEntry(Entry e) {
        e.getParent().removeChild(e);
    }

    @Override
    protected boolean affects(IdPath ... pp) {
        for (IdPath p1 : this.getAffectedIdPaths()) {
            for (IdPath p2 : pp) {
                if (!p1.isChildOrParentOf(p2)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean affectsOnlyInside(Entry e) {
        for (IdPath p : this.getAffectedIdPaths()) {
            if (p.startsWith(e.getIdPath())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean affectsSameAs(List<Change> cc) {
        for (Change c : cc) {
            if (!c.affects(this.getAffectedIdPaths())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isCreationalFor(Entry e) {
        return false;
    }

    public IdPath[] getAffectedIdPaths() {
        return new IdPath[]{this.getAffectedIdPath()};
    }

    @Override
    public List<Content> getContentsToPurge() {
        return Collections.emptyList();
    }
}

