/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core.changes;

import com.intellij.history.core.IdPath;
import com.intellij.history.core.changes.ChangeVisitor;
import com.intellij.history.core.changes.ROStatusChangeAppliedState;
import com.intellij.history.core.changes.ROStatusChangeNonAppliedState;
import com.intellij.history.core.changes.StructuralChange;
import com.intellij.history.core.storage.Stream;
import com.intellij.history.core.tree.Entry;
import java.io.IOException;

public class ROStatusChange
extends StructuralChange<ROStatusChangeNonAppliedState, ROStatusChangeAppliedState> {
    public ROStatusChange(String path, boolean isReadOnly) {
        super(path);
        ((ROStatusChangeNonAppliedState)this.getNonAppliedState()).myNewStatus = isReadOnly;
    }

    public ROStatusChange(Stream s) throws IOException {
        super(s);
        ((ROStatusChangeAppliedState)this.getAppliedState()).myOldStatus = s.readBoolean();
    }

    @Override
    public void write(Stream s) throws IOException {
        super.write(s);
        s.writeBoolean(((ROStatusChangeAppliedState)this.getAppliedState()).myOldStatus);
    }

    @Override
    protected ROStatusChangeAppliedState createAppliedState() {
        return new ROStatusChangeAppliedState();
    }

    @Override
    protected ROStatusChangeNonAppliedState createNonAppliedState() {
        return new ROStatusChangeNonAppliedState();
    }

    public boolean getOldStatus() {
        return ((ROStatusChangeAppliedState)this.getAppliedState()).myOldStatus;
    }

    @Override
    protected IdPath doApplyTo(Entry r, ROStatusChangeAppliedState newState) {
        Entry e = r.getEntry(this.getPath());
        newState.myOldStatus = e.isReadOnly();
        e.setReadOnly(((ROStatusChangeNonAppliedState)this.getNonAppliedState()).myNewStatus);
        return e.getIdPath();
    }

    @Override
    public void doRevertOn(Entry root) {
        this.getEntry(root).setReadOnly(((ROStatusChangeAppliedState)this.getAppliedState()).myOldStatus);
    }

    private Entry getEntry(Entry r) {
        return r.getEntry(this.getAffectedIdPath());
    }

    @Override
    public void accept(ChangeVisitor v) throws IOException, ChangeVisitor.StopVisitingException {
        v.visit(this);
    }
}

