/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core.changes;

import com.intellij.history.core.IdPath;
import com.intellij.history.core.changes.ChangeVisitor;
import com.intellij.history.core.changes.MoveChangeAppliedState;
import com.intellij.history.core.changes.MoveChangeNonAppliedState;
import com.intellij.history.core.changes.StructuralChange;
import com.intellij.history.core.storage.Stream;
import com.intellij.history.core.tree.Entry;
import java.io.IOException;

public class MoveChange
extends StructuralChange<MoveChangeNonAppliedState, MoveChangeAppliedState> {
    public MoveChange(String path, String newParentPath) {
        super(path);
        ((MoveChangeNonAppliedState)this.getNonAppliedState()).myNewParentPath = newParentPath;
    }

    public MoveChange(Stream s) throws IOException {
        super(s);
        ((MoveChangeAppliedState)this.getAppliedState()).myTargetIdPath = s.readIdPath();
    }

    @Override
    public void write(Stream s) throws IOException {
        super.write(s);
        s.writeIdPath(((MoveChangeAppliedState)this.getAppliedState()).myTargetIdPath);
    }

    @Override
    protected MoveChangeAppliedState createAppliedState() {
        return new MoveChangeAppliedState();
    }

    @Override
    protected MoveChangeNonAppliedState createNonAppliedState() {
        return new MoveChangeNonAppliedState();
    }

    @Override
    protected IdPath doApplyTo(Entry r, MoveChangeAppliedState newState) {
        Entry e = r.getEntry(this.getPath());
        IdPath firstIdPath = e.getIdPath();
        this.removeEntry(e);
        Entry newParent = r.getEntry(((MoveChangeNonAppliedState)this.getNonAppliedState()).myNewParentPath);
        newParent.addChild(e);
        newState.myTargetIdPath = e.getIdPath();
        return firstIdPath;
    }

    @Override
    public void doRevertOn(Entry root) {
        Entry e = this.getEntry(root);
        this.removeEntry(e);
        Entry oldParent = this.getOldParent(root);
        oldParent.addChild(e);
    }

    @Override
    public boolean canRevertOn(Entry r) {
        return this.hasNoSuchEntry(this.getOldParent(r), this.getEntry(r).getName());
    }

    private Entry getEntry(Entry r) {
        return r.getEntry(((MoveChangeAppliedState)this.getAppliedState()).myTargetIdPath);
    }

    private Entry getOldParent(Entry r) {
        return r.getEntry(this.getAffectedIdPath().getParent());
    }

    @Override
    public IdPath[] getAffectedIdPaths() {
        return new IdPath[]{this.getAffectedIdPath(), ((MoveChangeAppliedState)this.getAppliedState()).myTargetIdPath};
    }

    @Override
    public void accept(ChangeVisitor v) throws IOException, ChangeVisitor.StopVisitingException {
        v.visit(this);
    }
}

