/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core.changes;

import com.intellij.history.core.IdPath;
import com.intellij.history.core.changes.ChangeVisitor;
import com.intellij.history.core.storage.Content;
import com.intellij.history.core.storage.Stream;
import com.intellij.history.core.tree.Entry;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public abstract class Change {
    public abstract void write(Stream var1) throws IOException;

    public String getName() {
        throw new UnsupportedOperationException();
    }

    public long getTimestamp() {
        throw new UnsupportedOperationException();
    }

    public List<Change> getChanges() {
        return Collections.singletonList(this);
    }

    public abstract void applyTo(Entry var1);

    public void revertOn(Entry r) {
        this.revertOnUpTo(r, null, false);
    }

    public boolean revertOnUpTo(Entry r, Change upTo, boolean revertTargetChange) {
        if (!revertTargetChange && this == upTo) {
            return false;
        }
        this.doRevertOn(r);
        return this != upTo;
    }

    protected abstract void doRevertOn(Entry var1);

    public boolean canRevertOn(Entry r) {
        return true;
    }

    public boolean affects(Entry e) {
        return this.affects(e.getIdPath());
    }

    protected abstract boolean affects(IdPath ... var1);

    public boolean affectsSameAs(List<Change> cc) {
        return false;
    }

    public abstract boolean affectsOnlyInside(Entry var1);

    public abstract boolean isCreationalFor(Entry var1);

    public abstract List<Content> getContentsToPurge();

    public boolean isLabel() {
        return false;
    }

    public boolean isSystemLabel() {
        return false;
    }

    public boolean isFileContentChange() {
        return false;
    }

    public void accept(ChangeVisitor v) throws IOException, ChangeVisitor.StopVisitingException {
    }
}

