/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.formatting.FormatProcessor;
import com.intellij.formatting.FormattingDocumentModel;
import com.intellij.formatting.IndentInfo;
import com.intellij.formatting.InitialInfoBuilder;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.SpacingImpl;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.FormattingDocumentModelImpl;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;

class WhiteSpace {
    private final int myStart;
    private int myEnd;
    private int mySpaces;
    private int myIndentSpaces;
    private CharSequence myInitial;
    private int myFlags;
    private static final byte FIRST = 1;
    private static final byte SAFE = 2;
    private static final byte KEEP_FIRST_COLUMN = 4;
    private static final byte LINE_FEEDS_ARE_READ_ONLY = 8;
    private static final byte READ_ONLY = 16;
    private static final byte CONTAINS_LF_INITIALLY = 32;
    private static final byte CONTAINS_SPACES_INITIALLY = 64;
    private static final int LF_COUNT_SHIFT = 7;
    private static final int MAX_LF_COUNT = 0x1000000;
    @NonNls
    private static final String CDATA_START = "<![CDATA[";
    @NonNls
    private static final String CDATA_END = "]]>";

    public WhiteSpace(int startOffset, boolean isFirst) {
        this.myStart = startOffset;
        this.myEnd = startOffset;
        this.setIsFirstWhiteSpace(isFirst);
    }

    public void append(int newEndOffset, FormattingDocumentModel model, CodeStyleSettings.IndentOptions options) {
        int oldEndOffset = this.myEnd;
        if (newEndOffset == oldEndOffset) {
            return;
        }
        if (this.myStart >= newEndOffset) {
            InitialInfoBuilder.assertInvalidRanges(this.myStart, newEndOffset, model, "some block intersects with whitespace");
        }
        this.myEnd = newEndOffset;
        TextRange range = new TextRange(this.myStart, this.myEnd);
        this.myInitial = model.getText(range);
        if (!this.coveredByBlock(model)) {
            InitialInfoBuilder.assertInvalidRanges(this.myStart, this.myEnd, model, "nonempty text is not covered by block");
        }
        int tabsize = options.TAB_SIZE;
        block5: for (int i = oldEndOffset - this.myStart; i < newEndOffset - this.myStart; ++i) {
            switch (this.myInitial.charAt(i)) {
                case '\n': {
                    this.setLineFeeds(this.getLineFeeds() + 1);
                    this.mySpaces = 0;
                    this.myIndentSpaces = 0;
                    continue block5;
                }
                case ' ': {
                    ++this.mySpaces;
                    continue block5;
                }
                case '\t': {
                    this.myIndentSpaces += tabsize;
                }
            }
        }
        this.myFlags = this.getLineFeeds() > 0 ? (this.myFlags |= 0x20) : (this.myFlags &= 0xFFFFFFDF);
        int totalSpaces = this.getTotalSpaces();
        this.myFlags = totalSpaces > 0 ? (this.myFlags |= 0x40) : (this.myFlags &= 0xFFFFFFBF);
    }

    private boolean coveredByBlock(FormattingDocumentModel model) {
        if (this.myInitial == null) {
            return true;
        }
        String s = ((Object)this.myInitial).toString().trim();
        if (s.length() == 0) {
            return true;
        }
        if (!(model instanceof FormattingDocumentModelImpl)) {
            return false;
        }
        PsiFile psiFile = ((FormattingDocumentModelImpl)model).getFile();
        if (psiFile == null) {
            return false;
        }
        PsiElement start = psiFile.findElementAt(this.myStart);
        PsiElement end = psiFile.findElementAt(this.myEnd - 1);
        if (s.startsWith(CDATA_START)) {
            s = s.substring(CDATA_START.length());
        }
        if (s.endsWith(CDATA_END)) {
            s = s.substring(0, s.length() - CDATA_END.length());
        }
        if ((s = s.trim()).length() == 0) {
            return true;
        }
        return start == end && start instanceof PsiWhiteSpace;
    }

    public String generateWhiteSpace(CodeStyleSettings.IndentOptions options) {
        StringBuilder buffer = new StringBuilder();
        StringUtil.repeatSymbol((Appendable)buffer, (char)'\n', (int)this.getLineFeeds());
        WhiteSpace.repeatTrailingSymbols(options, buffer, this.myIndentSpaces, this.mySpaces);
        return buffer.toString();
    }

    private static void repeatTrailingSymbols(CodeStyleSettings.IndentOptions options, StringBuilder buffer, int indentSpaces, int spaces) {
        if (options.USE_TAB_CHARACTER) {
            if (options.SMART_TABS) {
                int tabCount = indentSpaces / options.TAB_SIZE;
                int leftSpaces = indentSpaces - tabCount * options.TAB_SIZE;
                StringUtil.repeatSymbol((Appendable)buffer, (char)'\t', (int)tabCount);
                StringUtil.repeatSymbol((Appendable)buffer, (char)' ', (int)(leftSpaces + spaces));
            } else {
                int size = spaces + indentSpaces;
                while (size > 0) {
                    if (size >= options.TAB_SIZE) {
                        buffer.append('\t');
                        size -= options.TAB_SIZE;
                        continue;
                    }
                    buffer.append(' ');
                    --size;
                }
            }
        } else {
            StringUtil.repeatSymbol((Appendable)buffer, (char)' ', (int)(spaces + indentSpaces));
        }
    }

    public void setSpaces(final int spaces, final int indent) {
        this.performModification(new Runnable(){

            @Override
            public void run() {
                if (!WhiteSpace.this.isKeepFirstColumn() || (WhiteSpace.this.myFlags & 0x40) != 0) {
                    WhiteSpace.this.mySpaces = spaces;
                    WhiteSpace.this.myIndentSpaces = indent;
                }
            }
        });
    }

    private boolean doesNotContainAnySpaces() {
        return this.getTotalSpaces() == 0 && this.getLineFeeds() == 0;
    }

    public int getStartOffset() {
        return this.myStart;
    }

    public int getEndOffset() {
        return this.myEnd;
    }

    private void performModification(Runnable action) {
        if (this.isIsReadOnly()) {
            return;
        }
        boolean before = this.doesNotContainAnySpaces();
        int lineFeedsBefore = this.getLineFeeds();
        action.run();
        if (this.isLineFeedsAreReadOnly()) {
            this.setLineFeeds(lineFeedsBefore);
        }
        if (this.isIsSafe()) {
            boolean after = this.doesNotContainAnySpaces();
            if (before && !after) {
                this.mySpaces = 0;
                this.myIndentSpaces = 0;
                this.setLineFeeds(0);
            } else if (!before && after) {
                this.mySpaces = 1;
                this.myIndentSpaces = 0;
            }
        }
    }

    public void arrangeSpaces(final SpacingImpl spaceProperty) {
        this.performModification(new Runnable(){

            @Override
            public void run() {
                if (spaceProperty != null && WhiteSpace.this.getLineFeeds() == 0) {
                    if (WhiteSpace.this.getTotalSpaces() < spaceProperty.getMinSpaces()) {
                        WhiteSpace.this.setSpaces(spaceProperty.getMinSpaces(), 0);
                    }
                    if (WhiteSpace.this.getTotalSpaces() > spaceProperty.getMaxSpaces()) {
                        WhiteSpace.this.setSpaces(spaceProperty.getMaxSpaces(), 0);
                    }
                }
            }
        });
    }

    public void arrangeLineFeeds(final SpacingImpl spaceProperty, final FormatProcessor formatProcessor) {
        this.performModification(new Runnable(){

            @Override
            public void run() {
                if (spaceProperty != null) {
                    spaceProperty.refresh(formatProcessor);
                    if (spaceProperty.getMinLineFeeds() >= 0 && WhiteSpace.this.getLineFeeds() < spaceProperty.getMinLineFeeds()) {
                        WhiteSpace.this.setLineFeeds(spaceProperty.getMinLineFeeds());
                    }
                    if (WhiteSpace.this.getLineFeeds() > 0) {
                        if (spaceProperty.getKeepBlankLines() > 0) {
                            if (WhiteSpace.this.getLineFeeds() >= spaceProperty.getKeepBlankLines() + 1) {
                                WhiteSpace.this.setLineFeeds(spaceProperty.getKeepBlankLines() + 1);
                            }
                        } else if (WhiteSpace.this.getLineFeeds() > spaceProperty.getMinLineFeeds()) {
                            if (spaceProperty.shouldKeepLineFeeds()) {
                                WhiteSpace.this.setLineFeeds(Math.max(spaceProperty.getMinLineFeeds(), 1));
                            } else {
                                WhiteSpace.this.setLineFeeds(spaceProperty.getMinLineFeeds());
                                if (WhiteSpace.this.getLineFeeds() == 0) {
                                    WhiteSpace.this.mySpaces = 0;
                                }
                            }
                        }
                        if (WhiteSpace.this.getLineFeeds() == 1 && !spaceProperty.shouldKeepLineFeeds() && spaceProperty.getMinLineFeeds() == 0) {
                            WhiteSpace.this.setLineFeeds(0);
                            WhiteSpace.this.mySpaces = 0;
                        }
                        if (WhiteSpace.this.getLineFeeds() > 0 && WhiteSpace.this.getLineFeeds() < spaceProperty.getPrefLineFeeds()) {
                            WhiteSpace.this.setLineFeeds(spaceProperty.getPrefLineFeeds());
                        }
                    }
                } else if (WhiteSpace.this.isFirst()) {
                    WhiteSpace.this.setLineFeeds(0);
                    WhiteSpace.this.mySpaces = 0;
                }
            }
        });
    }

    public boolean containsLineFeeds() {
        return this.isIsFirstWhiteSpace() || this.getLineFeeds() > 0;
    }

    public int getTotalSpaces() {
        return this.mySpaces + this.myIndentSpaces;
    }

    public void ensureLineFeed() {
        this.performModification(new Runnable(){

            @Override
            public void run() {
                if (!WhiteSpace.this.containsLineFeeds()) {
                    WhiteSpace.this.setLineFeeds(1);
                    WhiteSpace.this.mySpaces = 0;
                }
            }
        });
    }

    public boolean isReadOnly() {
        return this.isIsReadOnly() || this.isIsSafe() && this.doesNotContainAnySpaces();
    }

    public boolean equalsToString(CharSequence ws) {
        if (this.myInitial == null) {
            return ws.length() == 0;
        }
        return Comparing.equal((CharSequence)ws, (CharSequence)this.myInitial, (boolean)true);
    }

    public void setIsSafe(boolean value) {
        this.setFlag(2, value);
    }

    private void setFlag(int mask, boolean value) {
        this.myFlags = value ? (this.myFlags |= mask) : (this.myFlags &= ~mask);
    }

    private boolean getFlag(int mask) {
        return (this.myFlags & mask) != 0;
    }

    private boolean isFirst() {
        return this.isIsFirstWhiteSpace();
    }

    public boolean containsLineFeedsInitially() {
        if (this.myInitial == null) {
            return false;
        }
        return (this.myFlags & 0x20) != 0;
    }

    public void removeLineFeeds(Spacing spacing, FormatProcessor formatProcessor) {
        this.performModification(new Runnable(){

            @Override
            public void run() {
                WhiteSpace.this.setLineFeeds(0);
                WhiteSpace.this.mySpaces = 0;
                WhiteSpace.this.myIndentSpaces = 0;
            }
        });
        this.arrangeLineFeeds((SpacingImpl)spacing, formatProcessor);
        this.arrangeSpaces((SpacingImpl)spacing);
    }

    public int getIndentOffset() {
        return this.myIndentSpaces;
    }

    public int getSpaces() {
        return this.mySpaces;
    }

    public void setKeepFirstColumn(boolean b) {
        this.setFlag(4, b);
    }

    public void setLineFeedsAreReadOnly() {
        this.setLineFeedsAreReadOnly(true);
    }

    public void setReadOnly(boolean isReadOnly) {
        this.setIsReadOnly(isReadOnly);
    }

    public boolean isIsFirstWhiteSpace() {
        return this.getFlag(1);
    }

    public boolean isIsSafe() {
        return this.getFlag(2);
    }

    public boolean isKeepFirstColumn() {
        return this.getFlag(4);
    }

    public boolean isLineFeedsAreReadOnly() {
        return this.getFlag(8);
    }

    public void setLineFeedsAreReadOnly(boolean lineFeedsAreReadOnly) {
        this.setFlag(8, lineFeedsAreReadOnly);
    }

    public boolean isIsReadOnly() {
        return this.getFlag(16);
    }

    public void setIsReadOnly(boolean isReadOnly) {
        this.setFlag(16, isReadOnly);
    }

    public void setIsFirstWhiteSpace(boolean isFirstWhiteSpace) {
        this.setFlag(1, isFirstWhiteSpace);
    }

    public StringBuilder generateWhiteSpace(CodeStyleSettings.IndentOptions indentOptions, int offset, IndentInfo indent) {
        StringBuilder result = new StringBuilder();
        int currentOffset = this.getStartOffset();
        CharSequence[] lines = this.getInitialLines();
        int currentLine = 0;
        for (int i = 0; i < lines.length - 1 && currentOffset + lines[i].length() <= offset; ++i) {
            result.append(lines[i]);
            currentOffset += lines[i].length();
            result.append('\n');
            ++currentLine;
            if (++currentOffset == offset) break;
        }
        String newIndentSpaces = indent.generateNewWhiteSpace(indentOptions);
        result.append(newIndentSpaces);
        WhiteSpace.appendNonWhitespaces(result, lines, currentLine);
        if (currentLine + 1 < lines.length) {
            result.append('\n');
            for (int i = currentLine + 1; i < lines.length - 1; ++i) {
                result.append(lines[i]);
                result.append('\n');
            }
            WhiteSpace.appendNonWhitespaces(result, lines, lines.length - 1);
            result.append(lines[lines.length - 1]);
        }
        return result;
    }

    private static void appendNonWhitespaces(StringBuilder result, CharSequence[] lines, int currentLine) {
        if (currentLine != lines.length && !((Object)lines[currentLine]).toString().matches("\\s*")) {
            result.append(lines[currentLine]);
        }
    }

    private CharSequence[] getInitialLines() {
        if (this.myInitial == null) {
            return new CharSequence[]{""};
        }
        ArrayList<StringBuffer> result = new ArrayList<StringBuffer>();
        StringBuffer currentLine = new StringBuffer();
        for (int i = 0; i < this.myInitial.length(); ++i) {
            char c = this.myInitial.charAt(i);
            if (c == '\n') {
                result.add(currentLine);
                currentLine = new StringBuffer();
                continue;
            }
            currentLine.append(c);
        }
        result.add(currentLine);
        return result.toArray(new CharSequence[result.size()]);
    }

    public int getIndentSpaces() {
        return this.myIndentSpaces;
    }

    public int getLength() {
        return this.myEnd - this.myStart;
    }

    public final int getLineFeeds() {
        return this.myFlags >>> 7;
    }

    public void setLineFeeds(int lineFeeds) {
        assert (lineFeeds < 0x1000000);
        int flags = this.myFlags;
        this.myFlags &= 0x7F;
        this.myFlags |= lineFeeds << 7;
        assert (this.getLineFeeds() == lineFeeds);
        assert ((flags & 0x7F) == (this.myFlags & 0x7F));
    }

    public TextRange getTextRange() {
        return new TextRange(this.myStart, this.myEnd);
    }

    public String toString() {
        return "WhiteSpace(" + this.myStart + "-" + this.myEnd + " spaces=" + this.mySpaces + " LFs=" + this.getLineFeeds() + ")";
    }
}

